/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.filters;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataFacade;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FilterProviderManager {
    private static final ILogger logger = Logger.getLogger(FilterProviderManager.class);
    private static final String FILTER_ITEM_PROVIDER_EXTENSION_POINT_ID = "DocGenFilterItemProvider";
    private static final String FILTER_ITEM_PROVIDER_ELEMENT = "FilterItemProvider";
    private static final String FILTER_ITEM_PROVIDER_ATTRIBUTE = "FilterItemProvider";
    private static LinkedHashMap<String, IFilterItemProvider> moduleID2filterItemProviders;
    private static String runningProjectUID;

    static {
        runningProjectUID = null;
    }

    public static <T extends Throwable> void doWithFilterItemProviders(IDocGeneratorProjectAgent projectAgent, IProcessor<T> processor) throws T {
        boolean locked = false;
        try {
            String projectUID = projectAgent.getProjectUID();
            locked = FilterProviderManager.lock(projectUID);
            List<IFilterItemProvider> filterItemProviders = FilterProviderManager.initializeFilterItemProvidersAndGetFilterItemList(projectAgent);
            HashMap<String, List<IFilterItemProvider>> projectUID2FilterItemProviders = new HashMap<String, List<IFilterItemProvider>>();
            projectUID2FilterItemProviders.put(projectUID, filterItemProviders);
            processor.run(projectUID2FilterItemProviders);
        }
        finally {
            if (locked) {
                FilterProviderManager.unlock();
            }
        }
    }

    private static synchronized boolean lock(String projectUID) {
        boolean locked;
        if (runningProjectUID != null) {
            logger.error("Concurrent filter access. A report is already running for project " + runningProjectUID + " when a new report for project " + projectUID + " was started concurrently.");
            locked = false;
        } else {
            runningProjectUID = projectUID;
            locked = true;
        }
        return locked;
    }

    private static synchronized void unlock() {
        runningProjectUID = null;
    }

    private static List<IFilterItemProvider> initializeFilterItemProvidersAndGetFilterItemList(IDocGeneratorProjectAgent projectAgent) {
        FilterProviderManager.retrieveFilterItemProviders();
        ArrayList<IFilterItemProvider> filterItemProvidersList = new ArrayList<IFilterItemProvider>(moduleID2filterItemProviders.values());
        for (IFilterItemProvider provider : filterItemProvidersList) {
            IModuleDataFacade dataFacade = null;
            IFMCAModule module = projectAgent.getModule(provider.getModuleID());
            if (module != null) {
                dataFacade = module.getModuleDataFacade();
            }
            provider.initialize(dataFacade, (IFrameProjectAgent)projectAgent.getProjectAgent());
        }
        return filterItemProvidersList;
    }

    public static boolean hasFilterItemProviderForModule(String moduleID) {
        FilterProviderManager.retrieveFilterItemProviders();
        return moduleID2filterItemProviders.containsKey(moduleID);
    }

    private static synchronized void retrieveFilterItemProviders() {
        if (moduleID2filterItemProviders == null) {
            moduleID2filterItemProviders = new LinkedHashMap();
            List<IFilterItemProvider> filterItemProvidersList = ExtensionMgr.getDefault().getExtension(FILTER_ITEM_PROVIDER_EXTENSION_POINT_ID, "FilterItemProvider", "FilterItemProvider", IFilterItemProvider.class);
            for (IFilterItemProvider filterItemProvider : filterItemProvidersList) {
                moduleID2filterItemProviders.put(filterItemProvider.getModuleID(), filterItemProvider);
            }
        }
    }

    public static interface IProcessor<T extends Throwable> {
        public void run(Map<String, List<IFilterItemProvider>> var1) throws T;
    }
}

