/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.IFrameStakeholderManager;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.ISectionAddID;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItemBody;
import com.arcway.cockpit.frame.client.project.core.files.FilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.DataManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.FilesAsAttributeValuesHelper;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.FilesAsObjectTypeCategoryIconHelper;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.IFrameLinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.Plan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.Section;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionImportHelper;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleConnectionAddID;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IImportedPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementAddID;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeTypesModifier;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.datainterchange.IFrameExportDataProvider;
import com.arcway.cockpit.frame.client.project.datainterchange.IFrameImporter;
import com.arcway.cockpit.frame.client.project.datainterchange.ISectionExportDataProvider;
import com.arcway.cockpit.frame.client.project.datainterchange.ImportFailedException;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileWriter;
import com.arcway.cockpit.frame.client.project.modules.IExportDataProvider;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule2;
import com.arcway.cockpit.frame.client.project.modules.IImportDataAgent;
import com.arcway.cockpit.frame.client.project.modules.ModuleInformation;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOFileID;
import com.arcway.cockpit.frame.shared.message.EOFileMetaInformation;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOObjectTypeCategory;
import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.EOSection;
import com.arcway.cockpit.frame.shared.message.EOStakeholder;
import com.arcway.cockpit.frame.shared.message.EOStakeholderRole;
import com.arcway.cockpit.frame.shared.message.EOUniqueElement;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import com.arcway.cockpit.frame.shared.message.IRoleAndStakeholder;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.EOUserDefinedAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.FileSystemErrorMessageDialogue;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.util.gui.ISubActivityProgressManager;
import de.plans.lib.util.gui.UsableProcessProgressManager;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.IPermissionOwner;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class FrameImportExportManager
implements IFrameExportDataProvider,
IFrameImporter {
    private static final ILogger logger = Logger.getLogger(FrameImportExportManager.class);
    private final IFrameProjectAgent projectAgent;

    public FrameImportExportManager(IFrameProjectAgent projectAgent) {
        assert (projectAgent != null);
        this.projectAgent = projectAgent;
    }

    public boolean canExport(ICockpitProjectData projectData) {
        return projectData instanceof IFrameProjectAgent;
    }

    @Override
    public void exportData(File saveFile, IProgressDisplay pDisplay) throws IOException, JvmExternalResourceInteractionException {
        ProjectFileWriter.createProjectFile(new ProjectFileWriter.IProjectDataProvider(){

            @Override
            public EOList<EOList<? extends EncodableObjectBase>> getMainData() {
                return FrameImportExportManager.this.getExportData(FrameImportExportManager.this.projectAgent);
            }

            @Override
            public Collection<EOFileMetaInformation> doExportFiles(File fileArchiveDirectory) throws JvmExternalResourceInteractionException {
                Collection<FileID> usedFiles = FilesAsAttributeValuesHelper.getAllFilesUsedAsAttributeValues(FrameImportExportManager.this.projectAgent);
                usedFiles.addAll(FilesAsObjectTypeCategoryIconHelper.getAllFilesUsedAsObjectTypeCategoryIcons(FrameImportExportManager.this.projectAgent));
                try {
                    return FrameImportExportManager.this.projectAgent.getFilesManager().doExportFiles(usedFiles, fileArchiveDirectory);
                }
                catch (ServerNotAvailableException e) {
                    throw new JvmExternalResourceInteractionException((Throwable)e);
                }
                catch (EXServerException e) {
                    throw new JvmExternalResourceInteractionException((Throwable)e);
                }
                catch (LoginCanceledException e) {
                    throw new JvmExternalResourceInteractionException((Throwable)e);
                }
                catch (UnknownServerException e) {
                    throw new JvmExternalResourceInteractionException((Throwable)e);
                }
                catch (ExPrematureEndOfTransfer e) {
                    throw new JvmExternalResourceInteractionException((Throwable)e);
                }
            }
        }, saveFile);
    }

    public static void saveProjectMetadataAsExportFile(final EOProject project, File saveFile) throws IOException, JvmExternalResourceInteractionException {
        ProjectFileWriter.createProjectFile(new ProjectFileWriter.IProjectDataProvider(){

            @Override
            public EOList<EOList<? extends EncodableObjectBase>> getMainData() {
                EOList metadata = new EOList("metadata");
                metadata.add((EncodableObjectBase)project);
                EOList mainData = new EOList("project");
                mainData.add((EncodableObjectBase)metadata);
                return mainData;
            }

            @Override
            public Collection<EOFileMetaInformation> doExportFiles(File fileArchiveDirectory) {
                return null;
            }
        }, saveFile);
    }

    private EOList<EOList<? extends EncodableObjectBase>> getExportData(IFrameProjectAgent projectToExport) {
        EOList result = new EOList("project");
        EOList metadata = new EOList("metadata");
        Project project = projectToExport.getProjectMetaDataManager().getProject();
        metadata.add((EncodableObjectBase)project.createEncodableObject());
        EOList userDefinedAttributeTypes = new EOList("userDefinedAttributeTypes");
        for (AttributeType type : projectToExport.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes()) {
            userDefinedAttributeTypes.add((EncodableObjectBase)type.createEOUserDefinedAttributeType());
        }
        EOList objectTypeCategories = new EOList("object-type-category");
        for (ObjectTypeCategory type : projectToExport.getObjectTypeCategoriesManager().getAllCategories()) {
            objectTypeCategories.add((EncodableObjectBase)type.createEncodableObject());
        }
        EOList ueRelationships = new EOList("uniqueElementContainment");
        ueRelationships.addAll(projectToExport.getUniqueElementRelationshipManager().getAllRelationshipsOfProject());
        EOList stakeholders = new EOList("stakeholders");
        stakeholders.addAll(projectToExport.getFrameStakeholderManager().getExportManager().getEOStakeholders());
        EOList roles = new EOList("stakeholder roles");
        roles.addAll(projectToExport.getFrameStakeholderManager().getExportManager().getEORoles());
        EOList stakeholderRoleConnections = new EOList("stakeholder role connections");
        stakeholderRoleConnections.addAll(projectToExport.getFrameStakeholderManager().getExportManager().getConnections((Collection<EOStakeholder>)stakeholders, (Collection<EOStakeholderRole>)roles));
        EOList uniqueElements = new EOList("unique elements");
        uniqueElements.addAll(projectToExport.getFrameUniqueElementMgr().getExportDataProvider().getAllUniqueElements());
        EOList sections = new EOList("sections");
        ISectionExportDataProvider sectionDataProvider = projectToExport.getFrameSectionManager().getExportDataProvider();
        sections.addAll(sectionDataProvider.getAllSections());
        EOList plans = new EOList("plans");
        for (IPlanRW iPlanRW : projectToExport.getFrameSectionManager().getPlanRWs()) {
            plans.add((EncodableObjectBase)iPlanRW.createEncodableObject());
        }
        EOList eOList = new EOList("unique element occurences");
        eOList.addAll(projectToExport.getFrameUniqueElementMgr().getExportDataProvider().getUniqueElementOccurences((Collection<EOUniqueElement>)uniqueElements));
        EOList users = new EOList("serverusersandgroups");
        Collection<IPermissionOwner> allOwners = projectToExport.getFramePermissionManager().getAllPermissionOwners();
        for (IPermissionOwner owner : allOwners) {
            if (owner.getPermissionOwnerType() == 2) continue;
            assert (owner instanceof EncodableObjectBase);
            users.add((EncodableObjectBase)owner);
        }
        EOList permissions = new EOList("permissions");
        permissions.addAll(projectToExport.getFramePermissionManager().getAllPermissions());
        EOList links = new EOList("links");
        IFrameLinkManager linkManager = projectToExport.getLinkManager();
        links.addAll(linkManager.getAllLinks());
        EOList frameData = new EOList("frame_data");
        for (IFrameDataManager iFrameDataManager : this.projectAgent.getDataManagers()) {
            if (!(iFrameDataManager instanceof DataManager)) continue;
            FrameImportExportManager.addEOLists(iFrameDataManager, (Collection<EOList<? extends EOFrameData>>)frameData);
        }
        EOList eOList2 = new EOList("module data");
        List<ModuleInformation> allModuleInformation = this.projectAgent.getModuleController().getAllModuleInformation();
        for (ModuleInformation moduleInformation : allModuleInformation) {
            IFMCAModule2 moduleFacade = moduleInformation.getModuleFacade();
            Collection<String> moduleDataTypes = moduleFacade.getTrueDataTypeIDs();
            IExportDataProvider dataProvider = moduleFacade.getExportDataProvider();
            for (String moduleDataTypeID : moduleDataTypes) {
                EOList<? extends EncodableObjectBase> allModuleDataOfCurrentType = dataProvider.getExportList(moduleDataTypeID);
                allModuleDataOfCurrentType.setRole(moduleDataTypeID);
                eOList2.add(allModuleDataOfCurrentType);
            }
        }
        result.add((EncodableObjectBase)metadata);
        result.add((EncodableObjectBase)userDefinedAttributeTypes);
        result.add((EncodableObjectBase)objectTypeCategories);
        result.add((EncodableObjectBase)ueRelationships);
        result.add((EncodableObjectBase)stakeholders);
        result.add((EncodableObjectBase)users);
        result.add((EncodableObjectBase)roles);
        result.add((EncodableObjectBase)stakeholderRoleConnections);
        result.add((EncodableObjectBase)uniqueElements);
        result.add((EncodableObjectBase)sections);
        result.add((EncodableObjectBase)plans);
        result.add((EncodableObjectBase)eOList);
        result.add((EncodableObjectBase)frameData);
        result.add((EncodableObjectBase)permissions);
        result.add((EncodableObjectBase)eOList2);
        result.add((EncodableObjectBase)links);
        return result;
    }

    private static void addEOLists(IFrameDataManager dataManager, Collection<EOList<? extends EOFrameData>> collection) {
        HashMap<String, EOList> lists = new HashMap<String, EOList>();
        Collection<? extends IAttributeOwner> data = dataManager.getData();
        for (IAttributeOwner iAttributeOwner : data) {
            if (iAttributeOwner instanceof IFrameDataRW) {
                EOFrameData frameDataAsEO = ((IFrameDataRW)iAttributeOwner).createEncodableObject();
                EOList list = (EOList)lists.get(iAttributeOwner.getTypeID());
                if (list == null) {
                    list = new EOList(iAttributeOwner.getTypeID());
                    lists.put(iAttributeOwner.getTypeID(), list);
                }
                list.add((EncodableObjectBase)frameDataAsEO);
                continue;
            }
            logger.warn("Data manager returned data items for export which are not of type IFrameDataRW: UID = " + iAttributeOwner.getUID() + " / TypeID = " + iAttributeOwner.getTypeID() + " / Type = " + iAttributeOwner.getClass().getName());
        }
        collection.addAll(lists.values());
    }

    @Override
    public void importProjectTemplate(ProjectFileAccess projectFile, Shell shell) throws ImportFailedException {
        this.importProjectFileWithProgressMonitor(projectFile, shell, true, true, false, true, false);
    }

    @Override
    public void loadProjectFromACP(ProjectFileAccess projectFile, Shell shell) throws ImportFailedException {
        this.importProjectFileWithProgressMonitor(projectFile, shell, true, true, true, false, true);
    }

    private void importProjectFileWithProgressMonitor(final ProjectFileAccess projectFile, final Shell shell, final boolean withPermissions, final boolean withProjectAttributes, final boolean withProjectFileLogoAndCopyright, final boolean generateNewUIDs, final boolean importFileMetaInformation) throws ImportFailedException {
        final ImportFailedException[] exceptionWrapper = new ImportFailedException[1];
        this.projectAgent.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            ImportState importState = new ImportState();
                            FrameImportExportManager.this.importProjectFile(projectFile, withPermissions, withProjectAttributes, withProjectFileLogoAndCopyright, generateNewUIDs, importFileMetaInformation, monitor, importState);
                            FrameImportExportManager.displayWarningForNonImportedModuleData(importState.nonSupportedModuleIDs2CountOfNonImportedData, importState.nonSupportedModuleIDs2CountOfNonImportedLinks, shell);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
                progressDialog.setOpenOnRun(true);
                try {
                    progressDialog.run(false, false, runnable);
                }
                catch (InvocationTargetException ite) {
                    Throwable ta = ite.getTargetException();
                    if (ta instanceof ImportFailedException) {
                        exceptionWrapper[0] = (ImportFailedException)ta;
                    } else if (ta instanceof ProjectFileAccess.ProjectFileAccessException) {
                        exceptionWrapper[0] = new ImportFailedException(ta);
                    }
                    logger.error("Exception during client project import:", ta);
                }
                catch (InterruptedException e) {
                    logger.error("Import unexpectedly canceled.", (Throwable)e);
                    exceptionWrapper[0] = new ImportFailedException(e);
                }
            }
        });
        if (exceptionWrapper[0] != null) {
            throw exceptionWrapper[0];
        }
    }

    private static void displayWarningForNonImportedModuleData(Map<String, Integer> nonSupportedModuleIDs2CountOfNonImportedData, Map<String, Integer> nonSupportedModuleIDs2CountOfNonImportedLinks, Shell parentShell) {
        if (!nonSupportedModuleIDs2CountOfNonImportedData.isEmpty() || !nonSupportedModuleIDs2CountOfNonImportedLinks.isEmpty()) {
            ModificationProblem modificationProblem;
            int severity;
            String consequence;
            int numberOfNonImportedData;
            String moduleName;
            String cause;
            String moduleID;
            ArrayList<ModificationProblem> modificationProblems = new ArrayList<ModificationProblem>(nonSupportedModuleIDs2CountOfNonImportedData.size());
            for (Map.Entry<String, Integer> nonSupportedModuleID2CountOfNonImportedData : nonSupportedModuleIDs2CountOfNonImportedData.entrySet()) {
                moduleID = nonSupportedModuleID2CountOfNonImportedData.getKey();
                cause = Messages.getString("FrameImportExportManagerIngoredData.CauseUnspecified");
                moduleName = Messages.getString("FrameImportExportManagerIngoredData.ModuleName." + moduleID);
                if (moduleName.startsWith("!")) {
                    moduleName = moduleID;
                }
                if ((numberOfNonImportedData = nonSupportedModuleID2CountOfNonImportedData.getValue().intValue()) > 1) {
                    consequence = NLS.bind((String)Messages.getString("FrameImportExportManagerIngoredData.ConsequenceDatas"), (Object)Integer.toString(numberOfNonImportedData), (Object)moduleName);
                    severity = 3;
                    modificationProblem = new ModificationProblem(cause, consequence, severity);
                    modificationProblems.add(modificationProblem);
                    continue;
                }
                if (numberOfNonImportedData != 1) continue;
                consequence = NLS.bind((String)Messages.getString("FrameImportExportManagerIngoredData.ConsequenceData"), (Object)moduleName);
                severity = 3;
                modificationProblem = new ModificationProblem(cause, consequence, severity);
                modificationProblems.add(modificationProblem);
            }
            for (Map.Entry<String, Integer> nonSupportedModuleID2CountOfNonImportedLinks : nonSupportedModuleIDs2CountOfNonImportedLinks.entrySet()) {
                moduleID = nonSupportedModuleID2CountOfNonImportedLinks.getKey();
                cause = Messages.getString("FrameImportExportManagerIngoredData.CauseUnspecified");
                moduleName = Messages.getString("FrameImportExportManagerIngoredData.ModuleName." + moduleID);
                if (moduleName.startsWith("!")) {
                    moduleName = moduleID;
                }
                if ((numberOfNonImportedData = nonSupportedModuleID2CountOfNonImportedLinks.getValue().intValue()) > 1) {
                    consequence = NLS.bind((String)Messages.getString("FrameImportExportManagerIngoredData.ConsequenceLinks"), (Object)Integer.toString(numberOfNonImportedData), (Object)moduleName);
                    severity = 3;
                    modificationProblem = new ModificationProblem(cause, consequence, severity);
                    modificationProblems.add(modificationProblem);
                    continue;
                }
                if (numberOfNonImportedData != 1) continue;
                consequence = NLS.bind((String)Messages.getString("FrameImportExportManagerIngoredData.ConsequenceLink"), (Object)moduleName);
                severity = 3;
                modificationProblem = new ModificationProblem(cause, consequence, severity);
                modificationProblems.add(modificationProblem);
            }
            if (!modificationProblems.isEmpty()) {
                ModificationProblemsDialog modificationProblemsDialog = new ModificationProblemsDialog(modificationProblems, Messages.getString("FrameImportExportManagerIngoredData.Title"), Messages.getString("FrameImportExportManagerIngoredData.Message"), parentShell);
                modificationProblemsDialog.open();
            }
        }
    }

    private void importProjectFile(ProjectFileAccess projectFile, boolean withPermissions, boolean withProjectAttributes, boolean withProjectDescriptionLogoAndCopyright, boolean generateNewUIDs, boolean importFileMetaInformation, IProgressMonitor progressMonitor, ImportState importState) throws ImportFailedException, ProjectFileAccess.ProjectFileAccessException {
        UsableProcessProgressManager progressManager = new UsableProcessProgressManager(progressMonitor, Messages.getString("FrameImportExportManager.import_data"), 18);
        progressManager.startNextTask(Messages.getString("FrameImportExportManager.start_import"));
        this.importStarted();
        progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_server_users"));
        FrameImportExportManager.storeServerUsersAndGroups(projectFile.getDataList("serverusersandgroups"), importState);
        ISubActivityProgressManager subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_custom_properties"));
        this.importUserDefinedAttributeTypes((Collection<? extends EncodableObjectBase>)projectFile.getDataList("userDefinedAttributeTypes"), subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_files"));
        this.initialiseFileImport(projectFile.getDataList("fileMetaInformation"), projectFile, importFileMetaInformation, importState);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_objecttypecategories"));
        EOList<? extends EncodableObjectBase> objectTypeCategoryList = projectFile.getDataList("object-type-category");
        this.importObjectTypeCategories((Collection<? extends EncodableObjectBase>)objectTypeCategoryList, generateNewUIDs, importState, subProgressManager);
        progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_projectproperties"));
        if (withProjectAttributes) {
            this.importMetadata((Collection<? extends EncodableObjectBase>)projectFile.getDataList("metadata"), withProjectDescriptionLogoAndCopyright, importState);
        }
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_stakeholders"));
        this.importStakeholders((Collection<? extends EncodableObjectBase>)projectFile.getDataList("stakeholders"), generateNewUIDs, importState, subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_roles"));
        this.importStakeholderRoles((Collection<? extends EncodableObjectBase>)projectFile.getDataList("stakeholder roles"), generateNewUIDs, importState, subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_connections"));
        this.importStakeholderRoleConnections((Collection<? extends EncodableObjectBase>)projectFile.getDataList("stakeholder role connections"), importState, subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_permissions"));
        FrameImportExportManager.storePermissions(projectFile.getDataList("permissions"), importState);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_unique_elements"));
        this.importUniqueElements(projectFile.getDataList("unique elements"), generateNewUIDs, importState, subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_folders"));
        this.importSections(projectFile.getDataList("sections"), generateNewUIDs, projectFile, importState, subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_plans"));
        Map<String, Collection<EOUniqueElementOccurrence>> ueOccurrenceMap = FrameImportExportManager.prepareUniqueElementOccurrences(projectFile.getDataList("unique element occurences"));
        this.importPlans((Collection<? extends EncodableObjectBase>)projectFile.getDataList("plans"), ueOccurrenceMap, generateNewUIDs, importState, subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_frame_data"));
        this.importFrameData(projectFile.getDataList("frame_data"), generateNewUIDs, importState, subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_module_data"));
        this.importModuleData(projectFile.getDataList("module data"), generateNewUIDs, importState, subProgressManager);
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_links"));
        this.importLinks((Collection<? extends EncodableObjectBase>)projectFile.getDataList("links"), subProgressManager, importState);
        progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_permissions"));
        if (withPermissions) {
            this.importPermissions(importState, false);
        }
        subProgressManager = progressManager.startNextTask(Messages.getString("FrameImportExportManager.import_files"));
        this.finaliseFileImport(importState);
        boolean success = this.projectAgent.getConfigurationManager().updateUIDsInConfigurationItems(importState.replacedUIDsOfAllObjects);
        if (!success) {
            throw new ImportFailedException("Could not update the configuration items.");
        }
        progressManager.startNextTask(Messages.getString("FrameImportExportManager.delete_temporary_files"));
        this.importFinished(projectFile);
        progressManager.finishProcess();
    }

    private void importStarted() {
        for (ModuleInformation mi : this.projectAgent.getModuleController().getAllModuleInformation()) {
            IImportDataAgent agent = mi.getModuleFacade().getImportDataAgent();
            agent.importStarted();
        }
    }

    private void importFinished(ProjectFileAccess preparedLoadFile) {
        List<ModuleInformation> modules = this.projectAgent.getModuleController().getAllModuleInformation();
        for (ModuleInformation mi : modules) {
            IImportDataAgent agent = mi.getModuleFacade().getImportDataAgent();
            agent.importFinished();
        }
        preparedLoadFile.dispose();
    }

    private static void logIgnoredData(Map<String, Integer> nonSupportedModuleIDs2CountOfNonImportedData, String moduleID, int dataCount) {
        Integer currentCount = nonSupportedModuleIDs2CountOfNonImportedData.get(moduleID);
        if (currentCount == null) {
            currentCount = 0;
        }
        nonSupportedModuleIDs2CountOfNonImportedData.put(moduleID, currentCount + dataCount);
    }

    private static void storeServerUsersAndGroups(EOList<? extends EncodableObjectBase> serverUsersAndGroups, ImportState importState) {
        if (serverUsersAndGroups != null) {
            for (EncodableObjectBase eo : serverUsersAndGroups) {
                if (!(eo instanceof IPermissionOwner)) continue;
                importState.originalUsersAndGroups.add((IPermissionOwner)eo);
            }
        }
    }

    private static void storePermissions(EOList<? extends EncodableObjectBase> permissions, ImportState importState) {
        if (permissions != null) {
            for (EncodableObjectBase eo : permissions) {
                if (!(eo instanceof EOPermission)) continue;
                importState.originalPermissions.add((EOPermission)eo);
            }
        }
    }

    private void importPermissions(ImportState importState, boolean forPermissionOperandsInReplacementMapOnly) {
        HashSet<String> nonExistingPermissionOwners = new HashSet<String>();
        Iterator<EOPermission> permissionIterator = importState.originalPermissions.iterator();
        while (permissionIterator.hasNext()) {
            EOPermission permission = permissionIterator.next();
            IFrameProjectAgent operand = permission.getOperandType().equals(this.projectAgent.getPermissionOperandType()) ? this.projectAgent : FrameImportExportManager.getReplacedPermissionOperand(permission, importState);
            if (operand == null && forPermissionOperandsInReplacementMapOnly) continue;
            Object owner = null;
            owner = permission.getOwnerType() == 2 ? this.getStakeholderRole(permission.getOwnerID(), importState) : this.getServerUserOrGroup(permission.getOwnerType(), permission.getOwnerID(), importState);
            if (owner != null) {
                CockpitPermissionTemplate template = this.projectAgent.getFramePermissionManager().getTemplate(permission);
                if (template != null) {
                    if (operand != null) {
                        this.projectAgent.getFramePermissionManager().addPermission((IPermissionOwner)owner, operand, template);
                    } else {
                        EOPermission newPermission = new EOPermission(permission);
                        newPermission.setSubSetUID(this.projectAgent.getUID());
                        newPermission.setOwnerID(owner.getPermissionOwnerID());
                        this.projectAgent.getFramePermissionManager().addPermission(newPermission);
                    }
                } else {
                    logger.warn("Permission not imported because no permission template is registered for permission operation " + permission.getOperation() + (permission.getOperation2() != null ? " (sub type: " + permission.getOperation2() + ")" : "") + " on operandtype " + permission.getOperandType() + ".");
                }
            } else {
                String permissionOwnerID = permission.getOwnerID();
                if (nonExistingPermissionOwners.add(permissionOwnerID)) {
                    logger.warn("Permissions for non-existing permissionowner " + permissionOwnerID + " were not imported.");
                }
            }
            permissionIterator.remove();
        }
        try {
            this.projectAgent.getFramePermissionManager().commit();
        }
        catch (EXServerException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (ServerNotAvailableException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (UnknownServerException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    private static IPermissionOperand getReplacedPermissionOperand(EOPermission permission, ImportState importState) {
        String key = String.valueOf(permission.getOperandUID()) + permission.getOperandType();
        IPermissionOperand replacedOperand = importState.replacedPermissionOperands.get(key);
        return replacedOperand;
    }

    private IPermissionOwner getServerUserOrGroup(int ownerType, String ownerID, ImportState importState) {
        String ownerNID = null;
        for (IPermissionOwner owner : importState.originalUsersAndGroups) {
            if (owner.getPermissionOwnerType() != ownerType || !owner.getPermissionOwnerID().equals(ownerID)) continue;
            ownerNID = owner.getPermissionOwnerID();
            break;
        }
        if (ownerNID != null) {
            for (IPermissionOwner owner : this.projectAgent.getFramePermissionManager().getAllPermissionOwners()) {
                if (owner.getPermissionOwnerType() != ownerType || !owner.getPermissionOwnerID().equalsIgnoreCase(ownerNID)) continue;
                return owner;
            }
        }
        return null;
    }

    private void initialiseFileImport(EOList<? extends EncodableObjectBase> fileMetaInformationList, ProjectFileAccess projectFile, boolean importFileMetaInformation, ImportState importState) throws ProjectFileAccess.ProjectFileAccessException, ImportFailedException {
        try {
            for (EncodableObjectBase fileMetaInformation_asObject : fileMetaInformationList) {
                EOFileMetaInformation fileMetaInformation;
                FileID oldFileID;
                File file;
                if (!(fileMetaInformation_asObject instanceof EOFileMetaInformation) || (file = FilesManager.getFileInExport(oldFileID = new FileID((fileMetaInformation = (EOFileMetaInformation)fileMetaInformation_asObject).getFileUID()), projectFile.getFilesRoot())) == null) continue;
                IStreamResource streamResource = new IStreamResource(){

                    public String getName() {
                        return fileMetaInformation.getOriginalFileName();
                    }

                    public InputStream toInputStream() throws JvmExternalResourceInteractionException {
                        try {
                            return new FileInputStream(file);
                        }
                        catch (FileNotFoundException e) {
                            logger.error("Can not create file input stream for imported file.", (Throwable)e);
                            throw new JvmExternalResourceInteractionException((Throwable)e);
                        }
                    }
                };
                FileID newFileID = null;
                newFileID = importFileMetaInformation ? this.projectAgent.getFilesManager().loadFileIntoTemporaryStorage(streamResource, new FileMetaInformationItemBody(fileMetaInformation.getOriginalFileName(), fileMetaInformation.getCreationDate())) : this.projectAgent.getFilesManager().loadFileIntoTemporaryStorage(streamResource);
                importState.replacedFileIDs.put(oldFileID, newFileID);
            }
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            throw new ImportFailedException(FileSystemErrorMessageDialogue.getFileSystemErrorMessage());
        }
    }

    private void finaliseFileImport(ImportState importState) {
        for (FileID newFileID : importState.replacedFileIDs.values()) {
            this.projectAgent.getFilesManager().removeFileFromTemporaryStorage(newFileID);
        }
    }

    private void importUniqueElements(EOList<? extends EncodableObjectBase> uniqueElements, boolean generateNewUIDs, ImportState importState, ISubActivityProgressManager progressManager) {
        if (uniqueElements == null) {
            return;
        }
        progressManager.setNumberOfSteps(uniqueElements.size());
        for (EncodableObjectBase eo : uniqueElements) {
            progressManager.startNextStep();
            if (!(eo instanceof EOUniqueElement)) continue;
            EOUniqueElement eoUE = (EOUniqueElement)eo;
            IFrameUniqueElementManager ueManager = this.projectAgent.getFrameUniqueElementMgr();
            String oldUniqueElementUID = eoUE.getUID();
            if (generateNewUIDs) {
                eoUE.setUID(UUIDGenerator.getUniqueID());
                eoUE.setProjectUID(this.projectAgent.getProjectUID());
                FrameImportExportManager.removeMetaAttributes((EOFrameData)eoUE);
            }
            this.handleFileAttributes(eoUE.getAttributes(), importState);
            IUniqueElementAddID addID = ueManager.requestUniqueElementImportPermission(eoUE);
            if (addID.permissionGranted()) {
                try {
                    IUniqueElement importedUE = this.projectAgent.getFrameUniqueElementMgr().createUniqueElement(addID);
                    if (!generateNewUIDs) continue;
                    importState.replacedUniqueElementUIDs.put(oldUniqueElementUID, importedUE.getUID());
                    importState.replacedUIDsOfAllObjects.put(oldUniqueElementUID, importedUE.getUID());
                }
                catch (EXNoPermission e) {
                    logger.error("Could not create unique element due to missing permission.", (Throwable)e);
                }
                continue;
            }
            logger.warn("Could not import unique element for the following reason: " + addID.getModificationProblem().getHumanReadableDescriptionOfCause());
        }
    }

    private void importUserDefinedAttributeTypes(Collection<? extends EncodableObjectBase> userDefinedAttributeTypes, ISubActivityProgressManager progressManager) {
        if (userDefinedAttributeTypes == null) {
            return;
        }
        progressManager.setNumberOfSteps(2);
        IFrameUserDefinedAttributeTypesManager udManager = this.projectAgent.getFrameUserDefinedAttributeTypesManager();
        ISubActivityProgressManager subProgressManager = progressManager.startNextStep();
        subProgressManager.setNumberOfSteps(userDefinedAttributeTypes.size());
        HashMap<IAttributeTypeID, AttributeType> attributeTypesToAdd = new HashMap<IAttributeTypeID, AttributeType>();
        for (EncodableObjectBase encodableObjectBase : userDefinedAttributeTypes) {
            EOUserDefinedAttributeType eoAttributeType;
            AttributeType candidateAttributeTypeToAdd;
            IAttributeType existingType;
            if (!(encodableObjectBase instanceof EOUserDefinedAttributeType) || (existingType = udManager.getUserDefinedAttributeType((candidateAttributeTypeToAdd = AttributeType.createAttributeType(eoAttributeType = (EOUserDefinedAttributeType)encodableObjectBase, this.projectAgent)).getAttributeTypeID())) != null) continue;
            if (candidateAttributeTypeToAdd.getCockpitDataType() != null) {
                ILocksAndPermissionsTransactionController transactionController = this.projectAgent.getLocksAndPermissionsTransactionController();
                udManager.requestAddAttributeTypePermissions(candidateAttributeTypeToAdd, transactionController, IAttributeTypesModifier.DUMMY);
                Collection<IModificationProblem> modProblems = transactionController.execute();
                if (modProblems.isEmpty()) {
                    if (attributeTypesToAdd.containsKey(candidateAttributeTypeToAdd.getAttributeTypeID())) {
                        assert (false);
                        logger.warn("ambigous custom property type encountered during import: " + candidateAttributeTypeToAdd.getAttributeTypeID());
                        continue;
                    }
                    attributeTypesToAdd.put(candidateAttributeTypeToAdd.getAttributeTypeID(), candidateAttributeTypeToAdd);
                    continue;
                }
                for (IModificationProblem modProblem : modProblems) {
                    logger.warn(modProblem.getHumanReadableDescriptionOfConsequence());
                }
                continue;
            }
            logger.info("Ignored user defined attribute type \"" + candidateAttributeTypeToAdd.getDisplayName() + "\" for unknown type \"" + candidateAttributeTypeToAdd.getCockpitDataTypeID() + "\" during client import.");
        }
        progressManager.startNextStep();
        if (!attributeTypesToAdd.isEmpty()) {
            try {
                udManager.addUserDefinedAttributeTypes(attributeTypesToAdd.values());
            }
            catch (EXNoPermission eXNoPermission) {
                logger.error("could not import custom property", (Throwable)eXNoPermission);
            }
            catch (EXNoLock eXNoLock) {
                logger.error("could not execute", (Throwable)eXNoLock);
            }
        }
    }

    private void importObjectTypeCategories(Collection<? extends EncodableObjectBase> objectTypeCategories, boolean updateMetaData, ImportState importState, ISubActivityProgressManager progressManager) {
        progressManager.setNumberOfSteps(objectTypeCategories.size());
        for (EncodableObjectBase encodableObjectBase : objectTypeCategories) {
            progressManager.startNextStep();
            if (!(encodableObjectBase instanceof EOObjectTypeCategory)) continue;
            EOObjectTypeCategory eoObjectTypeCategory = (EOObjectTypeCategory)encodableObjectBase;
            EOFileID newIconFileID = this.handleFileID(eoObjectTypeCategory.getIcon(), importState);
            if (newIconFileID != null) {
                eoObjectTypeCategory.setIcon(newIconFileID);
            }
            ObjectTypeCategory objectTypeCategory = ObjectTypeCategory.createObjectTypeCategory(eoObjectTypeCategory);
            objectTypeCategory.setProjectUID(this.projectAgent.getProjectUID());
            this.projectAgent.getObjectTypeCategoriesManager().addItem(objectTypeCategory, updateMetaData);
        }
    }

    private void importSections(EOList<? extends EncodableObjectBase> sections, boolean generateNewUIDs, ProjectFileAccess projectFileAccess, ImportState importState, ISubActivityProgressManager progressManager) throws ProjectFileAccess.ProjectFileAccessException, ImportFailedException {
        if (sections == null) {
            return;
        }
        progressManager.setNumberOfSteps(sections.size() * 2);
        IFrameSectionManager frameSectionManager = this.projectAgent.getFrameSectionManager();
        EOList sectionsToImport = new EOList(sections.size());
        for (EncodableObjectBase eo : sections) {
            progressManager.startNextStep();
            if (!(eo instanceof EOSection)) continue;
            EOSection eoSection = (EOSection)eo;
            eoSection.setProjectUID(this.projectAgent.getProjectUID());
            Section section = new Section(eoSection, this.projectAgent, IAttributeModificationManager.DUMMY);
            if (section.isRootSection()) {
                if (generateNewUIDs) {
                    importState.replacedSections.put(section.getUID(), frameSectionManager.getRootSection());
                    importState.replacedPermissionOperands.put(String.valueOf(section.getUID()) + section.getPermissionOperandType(), frameSectionManager.getRootSection());
                    continue;
                }
                ISection rootSection = frameSectionManager.getRootSection();
                LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
                frameSectionManager.requestDeleteSectionCascadingPermission(rootSection.getUID(), transactionController);
                Collection<IModificationProblem> problems = transactionController.execute();
                if (problems.size() == 0) {
                    try {
                        frameSectionManager.deleteData(transactionController);
                    }
                    catch (EXNoPermission e) {
                        logger.error("Tried to delete root section on section import missing needed permission, this shall not happen.", (Throwable)e);
                        throw new RuntimeException();
                    }
                    ArrayList<IAttribute> attributes = new ArrayList<IAttribute>(section.getAllAttributes());
                    Section newRootSection = new Section(section.getUID(), this.projectAgent.getProjectName(), "rootSection", attributes, this.projectAgent, IAttributeModificationManager.DUMMY);
                    frameSectionManager.addRootSection(newRootSection);
                    this.projectAgent.getFramePermissionManager().permissionOperandCreated(this.projectAgent.getFrameSectionManager().getRootSection());
                    try {
                        this.projectAgent.getFramePermissionManager().commit();
                    }
                    catch (Exception e) {
                        logger.error("Set default permissions on creating root section failed on import.", (Throwable)e);
                    }
                    continue;
                }
                throw new ImportFailedException("Could not import root section, because undeletable root section exists.");
            }
            sectionsToImport.add((EncodableObjectBase)eoSection);
        }
        SectionImportHelper sectionImportHelper = new SectionImportHelper((Collection<EOSection>)sectionsToImport);
        for (EOSection eoSection : sectionsToImport) {
            progressManager.startNextStep();
            this.importSection(eoSection, sectionImportHelper, generateNewUIDs, projectFileAccess, importState);
        }
    }

    private void importSection(EOSection eoSection, SectionImportHelper sectionImportHelper, boolean generateNewUIDs, ProjectFileAccess projectFileAccess, ImportState importState) throws ProjectFileAccess.ProjectFileAccessException {
        if (!sectionImportHelper.isSectionAlreadyImported(eoSection.getUID())) {
            String parentSectionUID = sectionImportHelper.getParentUIDFromEO(eoSection);
            EOSection parentSection = sectionImportHelper.getParentFromSectionsToImport(parentSectionUID);
            if (parentSection != null) {
                this.importSection(parentSection, sectionImportHelper, generateNewUIDs, projectFileAccess, importState);
            }
            ISection recentParentSection = this.getRecentParentSection(parentSectionUID, importState);
            String oldSectionUID = eoSection.getUID();
            EOSection eoSectionToImport = eoSection;
            if (generateNewUIDs) {
                FrameImportExportManager.removeMetaAttributes((EOFrameData)eoSection);
                eoSectionToImport = new EOSection((EOFrameData)eoSection);
                eoSectionToImport.setUID(UUIDGenerator.getUniqueID());
                eoSectionToImport.setProjectUID(this.projectAgent.getProjectUID());
                sectionImportHelper.setParentUIDForEO(recentParentSection.getUID(), eoSectionToImport);
            }
            this.handleFileAttributes(eoSectionToImport.getAttributes(), importState);
            IFrameSectionManager sectionManager = this.projectAgent.getFrameSectionManager();
            ISectionAddID addID = sectionManager.requestSectionImportPermission(eoSectionToImport, recentParentSection);
            if (addID.permissionGranted()) {
                try {
                    ISection importedSection = sectionManager.addSection(addID);
                    if (generateNewUIDs) {
                        importState.replacedPermissionOperands.put(String.valueOf(oldSectionUID) + importedSection.getPermissionOperandType(), importedSection);
                        importState.replacedSections.put(oldSectionUID, importedSection);
                        importState.replacedUIDsOfAllObjects.put(oldSectionUID, importedSection.getUID());
                    }
                    sectionImportHelper.addImportedSectionUID(oldSectionUID);
                }
                catch (EXNoPermission e) {
                    logger.error("Could not import section due to no permission.", (Throwable)e);
                }
            } else {
                logger.warn("Could not import section for the following reason: " + addID.getModificationProblem().getHumanReadableDescriptionOfCause());
            }
        }
    }

    private static Map<String, Collection<EOUniqueElementOccurrence>> prepareUniqueElementOccurrences(Collection<? extends EncodableObjectBase> allOccurrences) {
        HashMap<String, Collection<EOUniqueElementOccurrence>> preparedOccurrences = new HashMap<String, Collection<EOUniqueElementOccurrence>>();
        if (allOccurrences != null) {
            for (EncodableObjectBase encodableObjectBase : allOccurrences) {
                if (!(encodableObjectBase instanceof EOUniqueElementOccurrence)) continue;
                EOUniqueElementOccurrence occurrence = (EOUniqueElementOccurrence)encodableObjectBase;
                ArrayList<EOUniqueElementOccurrence> occurrencesOfPlan = (ArrayList<EOUniqueElementOccurrence>)preparedOccurrences.get(occurrence.getPlanUID());
                if (occurrencesOfPlan == null) {
                    occurrencesOfPlan = new ArrayList<EOUniqueElementOccurrence>();
                    preparedOccurrences.put(occurrence.getPlanUID(), occurrencesOfPlan);
                }
                occurrencesOfPlan.add(occurrence);
            }
        }
        return preparedOccurrences;
    }

    private void importPlans(Collection<? extends EncodableObjectBase> plans, Map<String, Collection<EOUniqueElementOccurrence>> uniqueElementOccurrences, boolean generateNewUIDs, ImportState importState, ISubActivityProgressManager progressManager) {
        if (plans == null) {
            return;
        }
        progressManager.setNumberOfSteps(plans.size());
        for (EncodableObjectBase encodableObjectBase : plans) {
            progressManager.startNextStep();
            if (!(encodableObjectBase instanceof EOPlan)) continue;
            EOPlan eoPlan = (EOPlan)encodableObjectBase;
            IAttributeModificationManager modManager = IAttributeModificationManager.DUMMY;
            if (generateNewUIDs) {
                eoPlan.setProjectUID(this.projectAgent.getUID());
                FrameImportExportManager.removeMetaAttributes((EOFrameData)eoPlan);
            }
            this.handleFileAttributes(eoPlan.getAttributes(), importState);
            Plan plan = new Plan((EOFrameData)eoPlan, modManager, this.projectAgent);
            ISection section = this.getRecentParentSection(plan.getSectionUID(), importState);
            if (section != null) {
                ArrayList<IAttribute> attributes = new ArrayList<IAttribute>(plan.getAllAttributes());
                String planUID = generateNewUIDs ? null : plan.getUID();
                File planFile = null;
                try {
                    planFile = this.projectAgent.getFilesManager().getFile(plan.getPlanFileID());
                }
                catch (Exception e) {
                    logger.warn("Exception while retrieving temp plan file during project import.", (Throwable)e);
                    continue;
                }
                try {
                    boolean planFileAlreadyStored = true;
                    IImportedPlan importedPlan = this.projectAgent.getFrameUniqueElementMgr().importPlan(section, planUID, plan.getPlantypeUID(), plan.getPlanName(), plan.getDescription(), plan.getCategoryID(), attributes, planFile, planFileAlreadyStored, IProgressDisplay.DUMMY);
                    String oldPlanUID = plan.getUID();
                    importState.replacedUIDsOfAllObjects.put(oldPlanUID, importedPlan.getPlan().getUID());
                    Collection<EOUniqueElementOccurrence> occurrencesOfPlan = uniqueElementOccurrences.get(oldPlanUID);
                    Collection<? extends IPlanAgentStructuredPlanElement> planElements = importedPlan.getPlanStructure();
                    HashMap<String, IPlanAgentStructuredPlanElement> planElementUIDs2planElement = new HashMap<String, IPlanAgentStructuredPlanElement>(2 * planElements.size());
                    for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : planElements) {
                        planElementUIDs2planElement.put(iPlanAgentStructuredPlanElement.getPlanElementUID(), iPlanAgentStructuredPlanElement);
                    }
                    if (occurrencesOfPlan != null) {
                        HashMap<IPlanAgentStructuredPlanElement, IUniqueElement> hashMap = new HashMap<IPlanAgentStructuredPlanElement, IUniqueElement>(2 * occurrencesOfPlan.size());
                        for (EOUniqueElementOccurrence occurrence : occurrencesOfPlan) {
                            IPlanAgentStructuredPlanElement planElement;
                            String originalUniqueElementUID;
                            String planElementUID = occurrence.getPlanElementUID();
                            String uniqueElementUID = originalUniqueElementUID = occurrence.getElementUID();
                            if (generateNewUIDs) {
                                uniqueElementUID = importState.replacedUniqueElementUIDs.get(originalUniqueElementUID);
                            }
                            if ((planElement = (IPlanAgentStructuredPlanElement)planElementUIDs2planElement.get(planElementUID)) != null) {
                                IUniqueElement uniqueElement = this.projectAgent.getFrameUniqueElementMgr().getUniqueElement(uniqueElementUID);
                                if (uniqueElement != null) {
                                    hashMap.put(planElement, uniqueElement);
                                    continue;
                                }
                                logger.warn("orphaned occurence ignored during import due to missing UE " + plan.getPlanName() + ", plan element " + planElementUID);
                                continue;
                            }
                            logger.warn("orphaned occurence ignored during import due to missing PE " + plan.getPlanName() + ", plan element " + planElementUID);
                        }
                        importedPlan.createUniqueElementOccurences(hashMap);
                    }
                }
                catch (PlanAgentManager.EXPlanAgentLaunchException e) {
                    logger.error("could not import plan " + plan.getPlanName(), (Throwable)e);
                }
                catch (EXWriteAccessDeniedException e) {
                    logger.error("could not import plan " + plan.getPlanName(), (Throwable)e);
                }
                catch (EXSetupPlanException e) {
                    FrameImportExportManager.logIgnoredData(importState.nonSupportedModuleIDs2CountOfNonImportedData, plan.getPlantypeUID(), 1);
                }
                catch (EXModificationProblem e) {
                    logger.error("Could not import plan. " + e.getModificationProblems().iterator().next().getHumanReadableDescriptionOfCause());
                }
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)planFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.warn("Could not delete plan file retrieved from file archive.", (Throwable)e);
                }
                continue;
            }
            logger.warn("Could not import plan. parent section not found");
        }
    }

    private void importModuleData(EOList<? extends EncodableObjectBase> moduleData, boolean generateNewUIDs, ImportState importState, ISubActivityProgressManager progressManager) throws ProjectFileAccess.ProjectFileAccessException {
        if (moduleData == null) {
            return;
        }
        List<ModuleInformation> modules = this.projectAgent.getModuleController().getAllModuleInformation();
        progressManager.setNumberOfSteps(moduleData.size());
        for (EncodableObjectBase eo : moduleData) {
            String moduleID;
            ISubActivityProgressManager subProgressManager = progressManager.startNextStep();
            if (!(eo instanceof EOList)) continue;
            EOList moduleDataItemList = (EOList)eo;
            boolean moduleDataItemListImported = false;
            for (ModuleInformation mi : modules) {
                IImportDataAgent agent = mi.getModuleFacade().getImportDataAgent();
                if (agent == null || !agent.supportsDataType(moduleDataItemList)) continue;
                this.deliverModuleImportDataToModule(agent, moduleDataItemList, generateNewUIDs, subProgressManager, importState);
                moduleDataItemListImported = true;
                break;
            }
            if (moduleDataItemListImported) continue;
            String moduleDataType = moduleDataItemList.getRole();
            int pos = moduleDataType.lastIndexOf(".");
            if (pos > 0 && pos < moduleDataType.length() - 1) {
                moduleID = moduleDataType.substring(0, pos);
                moduleDataType = moduleDataType.substring(pos + 1);
            } else {
                moduleID = moduleDataType;
            }
            int dataCount = moduleDataItemList.size();
            FrameImportExportManager.logIgnoredData(importState.nonSupportedModuleIDs2CountOfNonImportedData, moduleID, dataCount);
        }
    }

    private void deliverModuleImportDataToModule(IImportDataAgent importDataAgent, EOList<?> moduleDataItemList, boolean generateNewUIDs, ISubActivityProgressManager progressManager, final ImportState importState) throws ProjectFileAccess.ProjectFileAccessException {
        Map<?, ?> replacementMap = importDataAgent.importDataAsLocalModification(moduleDataItemList, generateNewUIDs, progressManager, new FileImporter(){

            @Override
            public void handleFileAttribute(EOAttribute eoAttribute) {
                FrameImportExportManager.this.handleFileAttribute(eoAttribute, importState);
            }
        });
        for (Map.Entry<?, ?> entry : replacementMap.entrySet()) {
            ICockpitProjectData newItem;
            ICockpitProjectData originalItem;
            if (entry.getKey() instanceof ICockpitProjectData && entry.getValue() instanceof ICockpitProjectData) {
                originalItem = (ICockpitProjectData)entry.getKey();
                newItem = (ICockpitProjectData)entry.getValue();
                importState.replacedUIDsOfAllObjects.put(originalItem.getUID(), newItem.getUID());
            }
            if (!(entry.getKey() instanceof IPermissionOperand) || !(entry.getValue() instanceof IPermissionOperand)) continue;
            originalItem = (IPermissionOperand)entry.getKey();
            newItem = (IPermissionOperand)entry.getValue();
            importState.replacedPermissionOperands.put(String.valueOf(originalItem.getPermissionOperandUID()) + originalItem.getPermissionOperandType(), (IPermissionOperand)newItem);
        }
    }

    private void importLinks(Collection<? extends EncodableObjectBase> links, ISubActivityProgressManager progressManager, ImportState importState) {
        if (links == null) {
            return;
        }
        progressManager.setNumberOfSteps(2);
        ISubActivityProgressManager subProgressManager = progressManager.startNextStep();
        subProgressManager.setNumberOfSteps(links.size());
        HashSet<String> ignoredLinkTypes = new HashSet<String>();
        IFrameLinkManager linkManager = this.projectAgent.getLinkManager();
        ArrayList<EOLink> linksToAdd = new ArrayList<EOLink>(links.size());
        for (EncodableObjectBase encodableObjectBase : links) {
            if (!(encodableObjectBase instanceof EOLink)) continue;
            subProgressManager.startNextStep();
            EOLink link = (EOLink)encodableObjectBase;
            ILinkType linkType = linkManager.getLinkType(link);
            if (linkType != null) {
                importState.replacedUIDsOfAllObjects.put(link.getProjectUID(), this.projectAgent.getUID());
                link.setProjectUID(this.projectAgent.getUID());
                FrameImportExportManager.adaptLink(link, importState.replacedUIDsOfAllObjects);
                linksToAdd.add(link);
                continue;
            }
            if (ignoredLinkTypes.contains(link.getLinkTypeID())) continue;
            logger.info("Ignored links of type \"" + link.getLinkTypeID() + "\" during client import.");
            ignoredLinkTypes.add(link.getLinkTypeID());
        }
        progressManager.startNextStep();
        ArrayList arrayList = new ArrayList(linksToAdd);
        Collection<EOLink> actuallyImportedLinks = linkManager.addLinks(linksToAdd);
        arrayList.removeAll(actuallyImportedLinks);
        for (EOLink notImportedLink : arrayList) {
            String moduleID = notImportedLink.getModuleID();
            String uid = notImportedLink.getUID();
            Integer counterPre = importState.nonSupportedModuleIDs2CountOfNonImportedLinks.get(moduleID);
            int counterPost = counterPre == null ? 1 : counterPre + 1;
            importState.nonSupportedModuleIDs2CountOfNonImportedLinks.put(moduleID, counterPost);
            logger.warn("Ignored link when importing: " + moduleID + ", " + uid);
        }
    }

    private static void adaptLink(EOLink link, Map<String, String> replacedElementUIDs) {
        String linkableObjectID;
        String moduleDataID = replacedElementUIDs.get(link.getModuleDataUID());
        if (moduleDataID != null) {
            link.setModuleDataUID(moduleDataID);
        }
        if ((linkableObjectID = replacedElementUIDs.get(link.getLinkableObjectUID())) != null) {
            link.setLinkableObjectUID(linkableObjectID);
        }
    }

    private void importMetadata(Collection<? extends EncodableObjectBase> metadata, boolean withProjectDescriptionLogoAndCopyright, ImportState importState) {
        HashSet<IAttributeTypeID> attributeTypeIDsNotToImport = new HashSet<IAttributeTypeID>();
        attributeTypeIDsNotToImport.add(ProjectAttributeTypeProvider.ATTRID_NAME);
        if (!withProjectDescriptionLogoAndCopyright) {
            attributeTypeIDsNotToImport.add(ProjectAttributeTypeProvider.ATTRID_DESCRIPTION);
            attributeTypeIDsNotToImport.add(ProjectAttributeTypeProvider.ATTRID_LOGO);
            attributeTypeIDsNotToImport.add(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT);
        }
        EOProject projectToImport = (EOProject)metadata.iterator().next();
        Project project = this.projectAgent.getProjectMetaDataManager().getProject();
        for (EOAttribute attributeToImport : projectToImport.getAttributes()) {
            EOAttributeTypeID eoAttributeTypeID = attributeToImport.getAttributeTypeUID();
            AttributeTypeID attributeTypeID = AttributeTypeID.getAttributeTypeID(eoAttributeTypeID.getEOAttributeTypeID());
            if (attributeTypeIDsNotToImport.contains(attributeTypeID)) continue;
            try {
                IAttribute attribute = project.getAttribute(attributeTypeID);
                IAttributeType attributeType = project.getAttributeType(attribute.getAttributeTypeID());
                this.handleFileAttribute(attributeToImport, importState);
                IAttributeTypeDataType dataType = attributeType.getDataType();
                Object newValue = dataType.getEOAsValue(attributeToImport.getValueAsEO());
                Attribute newAttribute = new Attribute(attribute.getAttributeTypeID(), newValue);
                project.setMetaDataAttributeOnImport(newAttribute);
            }
            catch (ExInvalidAttributeType e) {
                logger.error("Cannot import project metadata due to ExInvalidAttributeType.", (Throwable)e);
            }
        }
    }

    private void importStakeholders(Collection<? extends EncodableObjectBase> stakeholders, boolean generateNewUIDs, ImportState importState, ISubActivityProgressManager progressManager) {
        if (stakeholders == null) {
            return;
        }
        progressManager.setNumberOfSteps(stakeholders.size());
        IFrameStakeholderManager sManager = this.projectAgent.getFrameStakeholderManager();
        for (EncodableObjectBase encodableObjectBase : stakeholders) {
            progressManager.startNextStep();
            if (!(encodableObjectBase instanceof EOStakeholder)) continue;
            EOStakeholder eoStakeholder = (EOStakeholder)encodableObjectBase;
            String oldStakeholderUID = eoStakeholder.getUID();
            if (generateNewUIDs) {
                eoStakeholder.setProjectUID(this.projectAgent.getProjectUID());
                eoStakeholder.setUID(UUIDGenerator.getUniqueID());
                FrameImportExportManager.removeMetaAttributes((EOFrameData)eoStakeholder);
            }
            this.handleFileAttributes(eoStakeholder.getAttributes(), importState);
            IStakeholderAddID addID = sManager.requestStakeholderImportPermission(eoStakeholder);
            if (addID.permissionGranted()) {
                try {
                    IStakeholder importedStakeholder = sManager.addStakeholder(addID);
                    if (!generateNewUIDs) continue;
                    importState.replacedStakeholders.put(oldStakeholderUID, importedStakeholder);
                    importState.replacedUIDsOfAllObjects.put(oldStakeholderUID, importedStakeholder.getUID());
                }
                catch (EXNoPermission e) {
                    logger.error("Could not import stakeholder due to no permission.", (Throwable)e);
                }
                continue;
            }
            logger.error("Could not import stakeholder for the following reason: " + addID.getModificationProblem().getHumanReadableDescriptionOfCause());
        }
    }

    private void importStakeholderRoles(Collection<? extends EncodableObjectBase> roles, boolean generateNewUID, ImportState importState, ISubActivityProgressManager progressManager) {
        if (roles == null) {
            return;
        }
        progressManager.setNumberOfSteps(roles.size());
        IFrameStakeholderManager sManager = this.projectAgent.getFrameStakeholderManager();
        for (EncodableObjectBase encodableObjectBase : roles) {
            progressManager.startNextStep();
            if (!(encodableObjectBase instanceof EOStakeholderRole)) continue;
            EOStakeholderRole eoRole = (EOStakeholderRole)encodableObjectBase;
            String oldStakeholderRoleUID = eoRole.getUID();
            if (generateNewUID) {
                eoRole.setProjectUID(this.projectAgent.getProjectUID());
                eoRole.setUID(UUIDGenerator.getUniqueID());
                FrameImportExportManager.removeMetaAttributes((EOFrameData)eoRole);
            }
            this.handleFileAttributes(eoRole.getAttributes(), importState);
            IStakeholderRoleAddID addID = sManager.requestStakeholderRoleImportPermission(eoRole);
            if (addID.permissionGranted()) {
                try {
                    IStakeholderRole importedStakeholderRole = sManager.addRole(addID);
                    if (!generateNewUID) continue;
                    importState.replacedStakeholderRoles.put(oldStakeholderRoleUID, importedStakeholderRole);
                    importState.replacedUIDsOfAllObjects.put(oldStakeholderRoleUID, importedStakeholderRole.getUID());
                }
                catch (EXNoPermission e) {
                    logger.error("Could not import stakeholder role due to no permission.", (Throwable)e);
                }
                continue;
            }
            logger.error("Could not import stakeholder role for the following reason: " + addID.getModificationProblem().getHumanReadableDescriptionOfCause());
        }
    }

    private void importStakeholderRoleConnections(Collection<? extends EncodableObjectBase> connections, ImportState importState, ISubActivityProgressManager progressManager) {
        if (connections == null) {
            return;
        }
        progressManager.setNumberOfSteps(connections.size());
        IFrameStakeholderManager sManager = this.projectAgent.getFrameStakeholderManager();
        try {
            for (EncodableObjectBase encodableObjectBase : connections) {
                progressManager.startNextStep();
                if (!(encodableObjectBase instanceof IRoleAndStakeholder)) continue;
                IRoleAndStakeholder rs = (IRoleAndStakeholder)encodableObjectBase;
                IStakeholder stakeholder = this.getStakeholder(rs.getStakeholderUID(), importState);
                IStakeholderRole role = this.getStakeholderRole(rs.getRoleUID(), importState);
                String answer = null;
                if (stakeholder != null && role != null) {
                    IStakeholderRoleConnectionAddID addID = sManager.requestStakeholderRoleConnectionAddPermission(stakeholder, role);
                    if (addID.getModificationProblem() == null) {
                        sManager.addStakeholderRoleConnection(addID);
                    } else {
                        answer = addID.getModificationProblem().getHumanReadableDescriptionOfCause();
                    }
                } else {
                    answer = "stakeholder or role not found while importing connection";
                }
                if (answer == null) continue;
                logger.error(answer);
            }
        }
        catch (EXNoPermission eXNoPermission) {
            logger.error("error while importing stakeholder role connections", (Throwable)eXNoPermission);
        }
    }

    private void importFrameData(EOList<? extends EncodableObjectBase> frameDataLists, boolean generateNewUIDs, ImportState importState, ISubActivityProgressManager progressManager) {
        if (frameDataLists == null) {
            return;
        }
        progressManager.setNumberOfSteps(frameDataLists.size());
        for (EncodableObjectBase eo : frameDataLists) {
            progressManager.startNextStep();
            if (!(eo instanceof EOList)) continue;
            EOList frameDataList = (EOList)eo;
            EOList checkedFrameDataList = new EOList(frameDataList.size() * 2);
            ArrayList<String> oldUIDs = new ArrayList<String>(frameDataList.size() * 2);
            for (Object o : frameDataList) {
                if (!(o instanceof EOFrameData)) continue;
                EOFrameData eoFrameData = (EOFrameData)o;
                oldUIDs.add(eoFrameData.getUID());
                if (generateNewUIDs) {
                    eoFrameData.setUID(UUIDGenerator.getUniqueID());
                    eoFrameData.setProjectUID(this.projectAgent.getUID());
                    FrameImportExportManager.removeMetaAttributes(eoFrameData);
                }
                this.handleFileAttributes(eoFrameData.getAttributes(), importState);
                checkedFrameDataList.add((EncodableObjectBase)eoFrameData);
            }
            IFrameDataManager dataManager = this.projectAgent.getDataManager(frameDataList.getRole());
            List<IFrameDataRW> importedFrameData = dataManager.importDataFromEO((List<EOFrameData>)checkedFrameDataList);
            if (!generateNewUIDs) continue;
            FrameImportExportManager.writeMappings(importedFrameData, oldUIDs, importState);
        }
    }

    private static void writeMappings(List<IFrameDataRW> newData, List<String> oldUIDs, ImportState importState) {
        int i = 0;
        while (i < newData.size()) {
            IFrameDataRW frameData = newData.get(i);
            String oldUID = oldUIDs.get(i);
            importState.replacedUIDsOfAllObjects.put(oldUID, frameData.getUID());
            if (frameData instanceof IPermissionOperand) {
                IPermissionOperand permOperand = (IPermissionOperand)frameData;
                importState.replacedPermissionOperands.put(String.valueOf(oldUID) + permOperand.getPermissionOperandType(), (IPermissionOperand)frameData);
            }
            ++i;
        }
    }

    private ISection getRecentParentSection(String parentSectionUID, ImportState importState) {
        ISection recentParentSection = importState.replacedSections.containsKey(parentSectionUID) ? importState.replacedSections.get(parentSectionUID) : this.projectAgent.getFrameSectionManager().getSection(parentSectionUID);
        return recentParentSection;
    }

    private IStakeholder getStakeholder(String stakeholderUID, ImportState importState) {
        if (importState.replacedStakeholders.containsKey(stakeholderUID)) {
            return importState.replacedStakeholders.get(stakeholderUID);
        }
        return this.projectAgent.getFrameStakeholderManager().getStakeholderByUID(stakeholderUID);
    }

    private IStakeholderRole getStakeholderRole(String roleUID, ImportState importState) {
        if (importState.replacedStakeholderRoles.containsKey(roleUID)) {
            return importState.replacedStakeholderRoles.get(roleUID);
        }
        return this.projectAgent.getFrameStakeholderManager().getRoleByUID(roleUID);
    }

    private void handleFileAttributes(Collection<EOAttribute> attributes, ImportState importState) {
        for (EOAttribute eoAttribute : attributes) {
            this.handleFileAttribute(eoAttribute, importState);
        }
    }

    private void handleFileAttribute(EOAttribute eoAttribute, ImportState importState) {
        EOFileID eoFileID;
        EOFileID newEOFileID;
        EOEncodableObject eoValue = eoAttribute.getValueAsEO();
        if (eoValue instanceof EOFileID && (newEOFileID = this.handleFileID(eoFileID = (EOFileID)eoValue, importState)) != null) {
            eoAttribute.setValueAsEO((EOEncodableObject)newEOFileID);
        }
    }

    private EOFileID handleFileID(EOFileID eoFileID, ImportState importState) {
        FileID newFileID;
        FileID oldFileID = new FileID(eoFileID.getFileID());
        if (!oldFileID.equals(FileID.NO_FILE) && (newFileID = importState.replacedFileIDs.get(oldFileID)) != null) {
            this.projectAgent.getFilesManager().markFileAsBeeingReferenced(newFileID);
            EOFileID newEOFileID = new EOFileID(newFileID.getFileUID());
            return newEOFileID;
        }
        return null;
    }

    private static void removeMetaAttributes(EOFrameData eoFrameData) {
        Iterator itEOAttributes = eoFrameData.getAttributes().iterator();
        while (itEOAttributes.hasNext()) {
            EOAttribute eoAttribute = (EOAttribute)itEOAttributes.next();
            String attributeTypeIDUID = eoAttribute.getAttributeTypeUID().getEOAttributeTypeID();
            if (!attributeTypeIDUID.equals(AbstractAttributeTypesProvider.ATTRID_CREATOR.getUID()) && !attributeTypeIDUID.equals(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE.getUID()) && !attributeTypeIDUID.equals(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR.getUID()) && !attributeTypeIDUID.equals(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE.getUID())) continue;
            itEOAttributes.remove();
        }
    }

    public static interface FileImporter {
        public void handleFileAttribute(EOAttribute var1);
    }

    private static class ImportState {
        Collection<EOPermission> originalPermissions = new HashSet<EOPermission>();
        Collection<IPermissionOwner> originalUsersAndGroups = new HashSet<IPermissionOwner>();
        Map<FileID, FileID> replacedFileIDs = new HashMap<FileID, FileID>();
        Map<String, String> replacedUniqueElementUIDs = new HashMap<String, String>();
        Map<String, ISection> replacedSections = new HashMap<String, ISection>();
        Map<String, IStakeholder> replacedStakeholders = new HashMap<String, IStakeholder>();
        Map<String, IStakeholderRole> replacedStakeholderRoles = new HashMap<String, IStakeholderRole>();
        Map<String, IPermissionOperand> replacedPermissionOperands = new HashMap<String, IPermissionOperand>();
        Map<String, String> replacedUIDsOfAllObjects = new HashMap<String, String>();
        Map<String, Integer> nonSupportedModuleIDs2CountOfNonImportedData = new HashMap<String, Integer>();
        Map<String, Integer> nonSupportedModuleIDs2CountOfNonImportedLinks = new HashMap<String, Integer>();

        private ImportState() {
        }
    }
}

