/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.CyclicUERelationshipIdentifier;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class UniqueElementRelationshipTableData {
    private final HashMap<String, Set<String>> elementToDirectNextElements = new HashMap();
    private final HashMap<String, Set<String>> elementToDirectPreviousElements = new HashMap();
    private final HashSet<EOUniqueElementRelationship> relationships = new HashSet();
    private CyclicUERelationshipIdentifier cyclicUERelIdentifier;

    public void addData(EOUniqueElementRelationship ueRelationship) {
        String firstElementUID = ueRelationship.getUniqueElementUID1();
        String secondElementUID = ueRelationship.getUniqueElementUID2();
        Set<String> directNextElements = this.elementToDirectNextElements.get(firstElementUID);
        if (directNextElements == null) {
            directNextElements = new HashSet<String>();
            this.elementToDirectNextElements.put(firstElementUID, directNextElements);
        }
        directNextElements.add(secondElementUID);
        Set<String> directPreviousElements = this.elementToDirectPreviousElements.get(secondElementUID);
        if (directPreviousElements == null) {
            directPreviousElements = new HashSet<String>();
            this.elementToDirectPreviousElements.put(secondElementUID, directPreviousElements);
        }
        directPreviousElements.add(firstElementUID);
        this.relationships.add(ueRelationship);
    }

    public Set<String> getDirectNextElementUIDs(String elementUID) {
        Set<String> directNextElements = this.elementToDirectNextElements.get(elementUID);
        return directNextElements != null ? directNextElements : Collections.emptySet();
    }

    public Set<String> getDirectPreviousElementUIDs(String elementUID) {
        Set<String> directPreviousElements = this.elementToDirectPreviousElements.get(elementUID);
        return directPreviousElements != null ? directPreviousElements : Collections.emptySet();
    }

    public Set<String> getAllNextElementUIDs() {
        return Collections.unmodifiableSet(this.elementToDirectPreviousElements.keySet());
    }

    public Set<String> getAllPreviousElementUIDs() {
        return Collections.unmodifiableSet(this.elementToDirectNextElements.keySet());
    }

    public Set<EOUniqueElementRelationship> getRelationships() {
        return Collections.unmodifiableSet(this.relationships);
    }

    public boolean doesRelationshipExist(String predecessorElement, String successorElement) {
        Set<String> successorElements = this.elementToDirectNextElements.get(predecessorElement);
        return successorElements != null && successorElements.contains(successorElement);
    }

    public boolean isPartOfCycle(String elementUID) {
        this.lazilyCreateCyclicUERelationshipIdentifier();
        return this.cyclicUERelIdentifier.isInCycle(elementUID);
    }

    public CyclicUERelationshipIdentifier.Cycle getCycle(String elementUID) {
        this.lazilyCreateCyclicUERelationshipIdentifier();
        return this.cyclicUERelIdentifier.getCycle(elementUID);
    }

    public Set<CyclicUERelationshipIdentifier.Cycle> getRootCycles() {
        this.lazilyCreateCyclicUERelationshipIdentifier();
        return this.cyclicUERelIdentifier.getRootCycles();
    }

    public CyclicUERelationshipIdentifier.Cycle getCycle(Set<String> elements) {
        this.lazilyCreateCyclicUERelationshipIdentifier();
        return this.cyclicUERelIdentifier.getCycle(elements);
    }

    private void lazilyCreateCyclicUERelationshipIdentifier() {
        if (this.cyclicUERelIdentifier == null) {
            this.cyclicUERelIdentifier = new CyclicUERelationshipIdentifier(this);
        }
    }
}

