/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.stakeholders;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleRW;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRoleAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.EOStakeholderRole;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import java.util.Collection;

public class StakeholderRole
extends AbstractFrameData
implements IStakeholderRoleRW {
    private static final String ATTR_TAG_NAME = "NAME";
    private static final String ATTR_TAG_DESCRIPTION = "DESCRIPTION";

    public StakeholderRole(String uID, String name, Collection<IAttribute> attributes, IAttributeModificationManager modManager, IFrameProjectAgent projectAgent) {
        super(uID, projectAgent.getProjectUID(), "com.arcway.cockpit.stakeholderrole", attributes, modManager, projectAgent);
        Attribute nameAttr = new Attribute(StakeholderRoleAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
        this.simplySetAttribute(nameAttr);
    }

    public StakeholderRole(EOStakeholderRole eoStakeholderRole, IAttributeModificationManager modManager, IFrameProjectAgent projectAgent) {
        super((EOFrameData)eoStakeholderRole, "com.arcway.cockpit.stakeholderrole", modManager, projectAgent);
        String description;
        String name = eoStakeholderRole.getOldAttributeValue(ATTR_TAG_NAME);
        if (name != null) {
            Attribute attribute = new Attribute(StakeholderRoleAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
            this.simplySetAttribute(attribute);
        }
        if ((description = eoStakeholderRole.getOldAttributeValue(ATTR_TAG_DESCRIPTION)) != null) {
            Attribute attribute = new Attribute(StakeholderRoleAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null));
            this.simplySetAttribute(attribute);
        }
    }

    public String getName() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderRoleAttributeTypesProvider.ATTRID_NAME);
        return (String)attribute.getAttributeValue();
    }

    public String getDescription() {
        IAttribute attribute = this.simplyGetAttribute(StakeholderRoleAttributeTypesProvider.ATTRID_DESCRIPTION);
        return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
    }

    public String getPermissionOwnerID() {
        return this.getUID();
    }

    public int getPermissionOwnerType() {
        return 2;
    }

    public String getPermissionOwnerName() {
        return this.getName();
    }

    @Override
    public EOFrameData createEncodableObject() {
        EOStakeholderRole eoRole = new EOStakeholderRole(super.createEncodableObject());
        return eoRole;
    }
}

