/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameSectionValidator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.Section;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;
import java.util.Collections;

public class SectionAttributeModificationManager
implements IAttributeModificationManager {
    private final IFrameProjectAgent projectAgent;
    private Section section;
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return SectionAttributeModificationManager.this.section;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            ISection childSection = (ISection)childOperand;
            return SectionAttributeModificationManager.this.projectAgent.getFrameSectionManager().getParentSection(childSection);
        }
    };

    public SectionAttributeModificationManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public void setSection(Section section) {
        this.section = section;
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(this.section)) {
            IAttributeType attributeType = this.section.getAttributeType(newAttribute.getAttributeTypeID());
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree);
            transactionController.addLockToTest(this.section, "modify");
            transactionController.addLock(this.section, "modify");
        }
        if (newAttribute.getAttributeTypeID().equals(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID)) {
            ModificationProblem modProblem;
            String newParentUID = (String)newAttribute.getAttributeValue();
            ISection newParentSection = this.projectAgent.getFrameSectionManager().getSection(newParentUID);
            IParentOperandTree operandTreeNewParent = this.projectAgent.getFrameSectionManager().getOperandTree(newParentSection);
            for (IAttribute attribute : this.section.getAllAttributes()) {
                IAttributeType type = this.section.getAttributeType(attribute.getAttributeTypeID());
                if (!type.restrictedAccessOnCreation() || attribute.getAttributeValue().equals(type.getDataType().getDefaultValue())) continue;
                transactionController.addAttributeModificationPermission(type, operandTreeNewParent);
            }
            if (this.projectAgent.getFrameSectionManager().containsChildSection(newParentSection, this.section.getSectionName())) {
                modProblem = new ModificationProblem(Messages.getString("SectionManager.new_name_is_invalid"), Messages.getString("SectionManager.folder_with_same_name_under_new"));
                transactionController.addLockModificationProblem(modProblem);
            }
            if (this.projectAgent.getFrameSectionManager().isAncestor(newParentSection, this.section) || this.section.getUID().equals(newParentSection.getUID())) {
                modProblem = new ModificationProblem(Messages.getString("SectionManager.new_parent_folder_not_allowed"), Messages.getString("SectionManager.cannot_move_under_ancestor"));
                transactionController.addLockModificationProblem(modProblem);
            }
            if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(newParentSection)) {
                transactionController.addPermission("modifyFolders", null, operandTreeNewParent);
                transactionController.addLock(newParentSection, "add");
            }
            ISection oldParent = this.projectAgent.getFrameSectionManager().getParentSection(this.section);
            if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(oldParent)) {
                IParentOperandTree operandTreeOld = this.projectAgent.getFrameSectionManager().getOperandTree(oldParent);
                transactionController.addPermission("modifyFolders", null, operandTreeOld);
                transactionController.addLock(oldParent, "add");
            }
        }
        if (newAttribute.getAttributeTypeID().equals(SectionAttributeTypesProvider.ATTRID_NAME)) {
            String newName = (String)newAttribute.getAttributeValue();
            ISection parentSection = this.projectAgent.getFrameSectionManager().getParentSection(this.section);
            RenameSectionValidator validator = new RenameSectionValidator(this.projectAgent, parentSection, this.section);
            String msg = validator.isValid(newName);
            if (msg != null) {
                ModificationProblem modProblem = new ModificationProblem(msg, Messages.getString("SectionManager.new_name_is_invalid"));
                transactionController.addLockModificationProblem(modProblem);
            }
            if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(parentSection)) {
                String lockType = "uniqueName_com.arcway.cockpit.section_" + newName.toLowerCase();
                transactionController.addLockToTest(parentSection, lockType);
                transactionController.addLock(parentSection, lockType);
            }
        }
    }

    @Override
    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        ISection oldParent = this.projectAgent.getFrameSectionManager().getParentSection(this.section);
        if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(oldParent)) {
            this.checkObjectTypeCategoryModificationPermission(transactionController);
        }
        transactionController.addLockToTest(this.section, "modify");
        transactionController.addLock(this.section, "modify");
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        IFrameSectionManager sectionManager = this.projectAgent.getFrameSectionManager();
        if (!sectionManager.isLocallyAdded(this.section)) {
            IAttributeType attributeType = this.section.getAttributeType(newAttribute.getAttributeTypeID());
            if (!this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, this.operandTree, false)) {
                throw new EXNoPermission("no permission for modifying this attribute");
            }
        }
        if (newAttribute.getAttributeTypeID().equals(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID)) {
            ISection oldParentSection = sectionManager.getSection((String)oldAttributeValue);
            sectionManager.sectionMoved(this.section, oldParentSection);
        } else if (newAttribute.getAttributeTypeID().equals(SectionAttributeTypesProvider.ATTRID_NAME)) {
            String newName = (String)newAttribute.getAttributeValue();
            sectionManager.sectionNameUpdated(this.section, newName);
        } else {
            sectionManager.sectionUpdated(this.section);
        }
    }

    @Override
    @Deprecated
    public IModificationProblem checkLocks() {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(this.section)) {
            Throwable serverException = null;
            try {
                EOLock conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.section, "modify");
                if (conflictingLock != null) {
                    modProblem = new ModificationProblem(conflictingLock, Messages.getString("SectionAttributeModificationManager.cannot_modify_folder"));
                }
            }
            catch (ServerNotAvailableException e) {
                serverException = e;
            }
            catch (LoginCanceledException e) {
                serverException = e;
            }
            catch (EXServerException e) {
                serverException = e;
            }
            catch (UnknownServerException e) {
                serverException = e;
            }
            if (serverException != null) {
                modProblem = new ModificationProblem((Exception)serverException, Messages.getString("SectionAttributeModificationManager.cannot_modify_folder"));
            }
        }
        return modProblem;
    }

    public void checkGeneralModificationPermissions(IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(this.section)) {
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree, false);
            transactionController.addLockToTest(this.section, "modify");
        }
        if (attributeType.getAttributeTypeID().equals(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID)) {
            ISection oldParentSection = this.projectAgent.getFrameSectionManager().getParentSection(this.section);
            if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(oldParentSection)) {
                transactionController.addPermission("modifyFolders", null, this.projectAgent.getFrameSectionManager().getOperandTree(oldParentSection));
                transactionController.addLockToTest(oldParentSection, "add");
            }
        }
    }

    @Override
    public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.checkGeneralModificationPermissions(attributeType, transactionController);
        Collection<IModificationProblem> modProblems = transactionController.checkConditions(true, true);
        return modProblems;
    }

    @Override
    public void modifyCategoryID() throws EXNoPermission, EXNoLock {
        this.projectAgent.getFrameSectionManager().sectionUpdated(this.section);
    }

    @Override
    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        ISection oldParent = this.projectAgent.getFrameSectionManager().getParentSection(this.section);
        if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(oldParent)) {
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.checkObjectTypeCategoryModificationPermission(transactionController);
            return transactionController.checkConditions(false, true);
        }
        return Collections.emptyList();
    }

    private void checkObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addPermission("modifyFolders", null, this.operandTree);
    }
}

