/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOInteger;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.Date;

public class EODateFilterValue
extends EOEncodableObjectWithRole {
    private static final ILogger logger = Logger.getLogger(EODateFilterValue.class);
    public static final String XML_NAME = "frame.datatypes.datefiltervalue";
    private static final String DEFAULT_ROLE = "filterValue";
    private static final String ROLE_DATE_1 = "date1";
    private static final String ROLE_DATE_2 = "date2";
    private static final String ROLE_FILTER_METHOD = "filterMethod";
    public static final int FILTER_METHOD_BEFORE = 0;
    public static final int FILTER_METHOD_AFTER = 1;
    public static final int FILTER_METHOD_BETWEEN = 2;
    private Date date1;
    private Date date2;
    private int filterMethod;
    public static final EODateFilterValue STANDARD_FILTER_VALUE = new EODateFilterValue(new Date(), 0);

    private EODateFilterValue() {
        super(XML_NAME);
        this.setRole(DEFAULT_ROLE);
    }

    public EODateFilterValue(Date date1, Date date2) {
        this();
        assert (date1 != null) : "date1 must not be null";
        assert (date2 != null) : "date2 must not be null";
        this.date1 = date1;
        this.date2 = date2;
        this.filterMethod = 2;
    }

    public EODateFilterValue(Date date, int filterMethod) {
        this();
        assert (date != null) : "date must not be null";
        this.date1 = date;
        this.filterMethod = filterMethod;
    }

    public EODateFilterValue(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public Date getDate1() {
        return this.date1;
    }

    public void setDate1(Date date1) {
        this.date1 = date1;
    }

    public Date getDate2() {
        return this.date2;
    }

    public void setDate2(Date date2) {
        this.date2 = date2;
    }

    public int getFilterMethod() {
        return this.filterMethod;
    }

    public void setFilterMethod(int filterMethod) {
        this.filterMethod = filterMethod;
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        EOString string1 = new EOString(Long.toString(this.date1.getTime()), ROLE_DATE_1);
        string1.writeXMLBody(writeContext, depth);
        if (this.date2 != null) {
            EOString string2 = new EOString(Long.toString(this.date2.getTime()), ROLE_DATE_2);
            string2.writeXMLBody(writeContext, depth);
        }
        EOInteger filterMethodValue = new EOInteger(new Integer(this.filterMethod), ROLE_FILTER_METHOD);
        filterMethodValue.writeXMLBody(writeContext, depth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (!(newChild instanceof EOEncodableObjectWithRole)) return false;
        String role = ((EOEncodableObjectWithRole)newChild).getRole();
        try {
            try {
                if (role.equals(ROLE_DATE_1)) {
                    this.date1 = new Date(Long.parseLong(((EOString)newChild).getString()));
                    return true;
                }
                if (role.equals(ROLE_DATE_2)) {
                    this.date2 = new Date(Long.parseLong(((EOString)newChild).getString()));
                    return true;
                }
            }
            catch (NumberFormatException e) {
                logger.error("Unknown format", (Throwable)e);
            }
            if (!role.equals(ROLE_FILTER_METHOD)) return false;
            this.filterMethod = ((EOInteger)newChild).getInteger();
            return true;
        }
        catch (ClassCastException e) {
            logger.error("Unexpected class", (Throwable)e);
        }
        return false;
    }
}

