/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import java.util.ArrayList;
import java.util.Collection;

public class ModuleDataAttributeTypesProvider
implements IAttributeTypesProvider {
    private final IAttributeOwner moduleData;

    public ModuleDataAttributeTypesProvider(IAttributeOwner moduleData) {
        this.moduleData = moduleData;
    }

    @Override
    public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) {
        return this.moduleData.getAttributeType(attributeTypeID);
    }

    @Override
    public IAttributeType getAttributeTypeByHumanreadableID(String humanreadableID) {
        for (IAttributeType attributeType : this.getAttributeTypes()) {
            if (!attributeType.getHumanReadableID().equals(humanreadableID)) continue;
            return attributeType;
        }
        return null;
    }

    @Override
    public Collection<IAttributeType> getAttributeTypes() {
        ArrayList<IAttributeType> allTypes = new ArrayList<IAttributeType>();
        for (IAttribute attribute : this.moduleData.getAllAttributes()) {
            IAttributeType type = this.moduleData.getAttributeType(attribute.getAttributeTypeID());
            allTypes.add(type);
        }
        return allTypes;
    }

    @Override
    public void refreshAttributeTypesCache() {
    }

    @Override
    public IAttributeTypeID getNameAttributeTypeID() {
        return null;
    }
}

