/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportOutputtemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateFolderAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRoleAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import java.util.HashMap;
import java.util.Map;

public class FrameDataAttributeTypesProviderMgr {
    private final Map<String, IAttributeTypesProvider> attributeTypesProviders = new HashMap<String, IAttributeTypesProvider>();

    public FrameDataAttributeTypesProviderMgr(String projectUID) {
        this.attributeTypesProviders.put("frame.project", new ProjectAttributeTypeProvider(projectUID));
        this.attributeTypesProviders.put("com.arcway.cockpit.plan", new PlanAttributeTypeProvider(projectUID));
        this.attributeTypesProviders.put(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, new ReportOutputtemplateAttributeTypesProvider(projectUID));
        this.attributeTypesProviders.put(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, new ReportTemplateAttributeTypesProvider(projectUID));
        this.attributeTypesProviders.put(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, new ReportTemplateFolderAttributeTypesProvider(projectUID));
        this.attributeTypesProviders.put("com.arcway.cockpit.section", new SectionAttributeTypesProvider(projectUID));
        this.attributeTypesProviders.put("com.arcway.cockpit.stakeholder", new StakeholderAttributeTypesProvider(projectUID));
        this.attributeTypesProviders.put("com.arcway.cockpit.stakeholderrole", new StakeholderRoleAttributeTypesProvider(projectUID));
        this.attributeTypesProviders.put("com.arcway.cockpit.uniqueelement", new UniqueElementAttributeTypesProvider(projectUID));
    }

    public void refreshAttributeTypesCache() {
        for (IAttributeTypesProvider attributeTypeProv : this.attributeTypesProviders.values()) {
            attributeTypeProv.refreshAttributeTypesCache();
        }
    }

    public IAttributeTypesProvider getAttributeTypesProvider(String frameDataTypeID) {
        return this.attributeTypesProviders.get(frameDataTypeID);
    }
}

