/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.framedata;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import de.plans.lib.util.Alphabet;

public class AttributeTypeSortCriterium
implements IAttributeTypeSortCriterium {
    private final String sortString;
    private final Integer category;

    public AttributeTypeSortCriterium(int position, Integer category) {
        this.sortString = AttributeTypeSortCriterium.computeUsefulSortString(position);
        this.category = category;
    }

    public static String computeUsefulSortString(int position) {
        int base = Alphabet.alphabet.length;
        String string = "";
        int remainder = position;
        while (remainder >= base) {
            string = String.valueOf(Alphabet.getCharacter((int)(remainder % base))) + string;
            remainder /= base;
        }
        string = String.valueOf(Alphabet.getCharacter((int)remainder)) + string;
        return string;
    }

    public static String computeUsefulNextSortString(String existingSortString) {
        if (existingSortString == null) {
            return String.valueOf(Alphabet.getCharacter((int)0));
        }
        char[] letters = existingSortString.toCharArray();
        int index = letters.length - 1;
        while (index >= 0) {
            if (letters[index] != Alphabet.getCharacter((int)(Alphabet.alphabet.length - 1))) {
                letters[index] = Alphabet.getNextCharacter((char)letters[index]);
                return new String(letters);
            }
            letters[index] = Alphabet.getCharacter((int)0);
            --index;
        }
        char[] newLetters = new char[letters.length + 1];
        System.arraycopy(letters, 0, newLetters, 1, letters.length);
        newLetters[0] = Alphabet.getCharacter((int)1);
        return new String(newLetters);
    }

    public AttributeTypeSortCriterium(Integer category, String sortString) {
        this.sortString = sortString;
        this.category = category;
    }

    public Integer getCategory() {
        return this.category;
    }

    public String getSortString() {
        return this.sortString;
    }

    public int compareTo(IAttributeTypeSortCriterium sortCriterium) {
        return this.compareTo(sortCriterium.getCategory(), sortCriterium.getSortString());
    }

    public int compareTo(Integer category_, String sortString_) {
        if (this.getCategory().equals(category_)) {
            String ownSortString = this.getSortString();
            String otherSortString = sortString_;
            int lengthDiff = ownSortString.length() - otherSortString.length();
            if (lengthDiff != 0) {
                return lengthDiff;
            }
            return this.getSortString().compareTo(sortString_);
        }
        return this.getCategory() - category_;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof IAttributeTypeSortCriterium) {
                IAttributeTypeSortCriterium sortCriterium = (IAttributeTypeSortCriterium)obj;
                return sortCriterium.getCategory().equals(this.getCategory()) && sortCriterium.getSortString().equals(this.getSortString());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getCategory().hashCode() ^ this.getSortString().hashCode();
    }
}

