/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.lib.dataviews.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class ModuleActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IWorkbenchPart issuingPart;
    private String currentProjectUID = null;
    private ImageDescriptor oldDisabledImage = null;
    private ImageDescriptor oldEnabledImage = null;
    private boolean areImagesReplaced = false;
    private IAction theAction;

    public final void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.issuingPart = targetPart;
    }

    protected final IWorkbenchPart getIssuingPart() {
        if (this.issuingPart != null) {
            return this.issuingPart;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
    }

    protected final Shell getIssuingShell() {
        if (this.issuingPart != null) {
            return this.issuingPart.getSite().getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public final void init(IAction action) {
        this.init();
        this.setActionEnablementAndIcon(action, false);
        this.theAction = action;
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        String newProjectUID = ProjectSelectionAnalyser.extractProjectUID(selection);
        if (newProjectUID != null) {
            this.currentProjectUID = newProjectUID;
        }
        this.setActionEnablementAndIcon(action, this.determineEnabledStatus(selection));
    }

    public final void projectChanged(IAction action, String projectUID) {
        this.currentProjectUID = projectUID;
        this.setActionEnablementAndIcon(action, this.determineEnabledStatus(projectUID));
    }

    public final void projectChanged(String projectUID) {
        this.currentProjectUID = projectUID;
        this.setActionEnablementAndIcon(this.theAction, this.determineEnabledStatus((String)null));
    }

    public final <T> void modelRefreshed(IAction action, IPropertyChanges<T> changes, Class<T> clazz) {
        this.setActionEnablementAndIcon(action, this.determineEnabledStatus(changes, clazz));
    }

    private void setActionEnablementAndIcon(IAction action, boolean enablement) {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.currentProjectUID);
        if (projectAgent != null) {
            boolean hasLicense = true;
            IClientFunctionLicenseType2 licenseType = this.getRequiredLicenseType();
            if (licenseType != null) {
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense(licenseType);
                boolean bl = hasLicense = !licenseType.isDenial(license);
            }
            if (!hasLicense) {
                this.setNoLicenseLabel(action);
                action.setEnabled(false);
            } else {
                this.resetImages(action);
                action.setEnabled(enablement);
            }
        } else {
            this.resetImages(action);
            action.setEnabled(enablement);
        }
    }

    private void setNoLicenseLabel(IAction action) {
        if (!this.areImagesReplaced) {
            this.oldDisabledImage = action.getDisabledImageDescriptor();
            this.oldEnabledImage = action.getImageDescriptor();
            this.areImagesReplaced = true;
        }
        ImageDescriptor disabledImage = this.oldDisabledImage;
        ImageDescriptor enabledImage = this.oldEnabledImage;
        if (disabledImage == null && enabledImage != null) {
            disabledImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)1);
        }
        if (disabledImage != null) {
            DecoratedImageDescriptor decoratedImage = new DecoratedImageDescriptor(disabledImage);
            ImageDescriptor decorator = FramePlugin.getImageDescriptor("dataview", "license_restriction.gif");
            decoratedImage.addDecorator(decorator, 3);
            action.setDisabledImageDescriptor((ImageDescriptor)decoratedImage);
        } else {
            action.setDisabledImageDescriptor(FramePlugin.getImageDescriptor("dataview", "license_restriction_16x16.gif"));
        }
        if (enabledImage != null) {
            ImageDescriptor greyedImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)2);
            DecoratedImageDescriptor decoratedImage = new DecoratedImageDescriptor(greyedImage);
            ImageDescriptor decorator = FramePlugin.getImageDescriptor("dataview", "license_restriction.gif");
            decoratedImage.addDecorator(decorator, 3);
            action.setImageDescriptor((ImageDescriptor)decoratedImage);
        } else {
            action.setImageDescriptor(FramePlugin.getImageDescriptor("dataview", "license_restriction_16x16.gif"));
        }
    }

    private void resetImages(IAction action) {
        if (this.areImagesReplaced) {
            action.setDisabledImageDescriptor(this.oldDisabledImage);
            action.setImageDescriptor(this.oldEnabledImage);
            this.oldDisabledImage = null;
            this.oldEnabledImage = null;
            this.areImagesReplaced = false;
        }
    }

    protected void init() {
    }

    protected abstract boolean determineEnabledStatus(ISelection var1);

    protected abstract boolean determineEnabledStatus(String var1);

    protected abstract <T> boolean determineEnabledStatus(IPropertyChanges<T> var1, Class<T> var2);

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return null;
    }
}

