/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardDescription;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardProvider;
import com.arcway.cockpit.frame.client.global.gui.wizards.MainExportWizardSelectionPage;
import com.arcway.cockpit.frame.client.global.gui.wizards.WizardInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public class MainExportWizard
extends Wizard {
    private final Object selectedElement;
    private static final String EXPORT_WIZARD_ELEMENT_NAME = "WizardProvider";
    private static final String EXPORT_WIZARD_CLASS_ATTRIBUTE = "wizardProvider";
    private static List exportWizardProviders = null;
    private final Collection<Image> currentImages = new ArrayList<Image>();

    public MainExportWizard(Object selectedElement) {
        this.selectedElement = selectedElement;
    }

    public void init() {
        this.setWindowTitle(Messages.getString("MainExportWizard.Export_3"));
        this.setDefaultPageImageDescriptor(Icons.getImageDescriptorForBigExportLogo());
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        List exportWizardProviders = MainExportWizard.getExportWizardProviders();
        ArrayList<WizardInformation> exportWizards = new ArrayList<WizardInformation>();
        for (IWizardProvider provider : exportWizardProviders) {
            for (IWizardDescription iWizardDescription : provider.getWizardDescriptions(this.selectedElement)) {
                IWizardDescription wizardDescription = iWizardDescription;
                if (!wizardDescription.validForSelectedElement(this.selectedElement)) continue;
                Image image = wizardDescription.getImageDescriptor().createImage();
                WizardInformation wi = new WizardInformation(wizardDescription.getID(), wizardDescription.getName(), wizardDescription.getWizard(this.selectedElement), image, wizardDescription.getDescription(), wizardDescription.hasPermissionForSelectedElement(this.selectedElement), wizardDescription.getPermissionError());
                if (wi != null && wi.hasPermission()) {
                    exportWizards.add(wi);
                }
                this.currentImages.add(image);
            }
        }
        MainExportWizardSelectionPage mainExportWizardSelectionPage = new MainExportWizardSelectionPage(Messages.getString("MainExportWizard.Export_5"), exportWizards);
        this.addPage((IWizardPage)mainExportWizardSelectionPage);
    }

    public boolean performFinish() {
        return true;
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.currentImages) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        this.currentImages.clear();
    }

    public static List getExportWizardProviders() {
        if (exportWizardProviders == null) {
            ExtensionMgr emgr = ExtensionMgr.getDefault();
            exportWizardProviders = emgr.getExtension("exportwizards", EXPORT_WIZARD_ELEMENT_NAME, EXPORT_WIZARD_CLASS_ATTRIBUTE);
        }
        return exportWizardProviders;
    }

    public static boolean hasExportWizardProviders() {
        return !MainExportWizard.getExportWizardProviders().isEmpty();
    }
}

