/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.AbstractPropertyGeneral;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyReportTemplates;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyRolesAndStakeholders;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateFolderRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyGeneralReportFolder
extends AbstractPropertyGeneral {
    private static final ILogger logger = Logger.getLogger(PropertyGeneralReportFolder.class);
    private static final ICockpitDataType[] supportedDataTypes = new ICockpitDataType[]{FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER)};
    private IFrameDataRW frameData;
    private AttributeTypesComposite attributeTypesComposite;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;
    private Collection<IModificationProblem> initialCategoryModificationProblems;

    @Override
    public IModificationProblem init_internal(ICockpitProjectData element, boolean forCreation) {
        this.frameData = (IFrameDataRW)element;
        return null;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            ICockpitDataType[] iCockpitDataTypeArray = supportedDataTypes;
            int n = supportedDataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ICockpitDataType element = iCockpitDataTypeArray[n2];
                if (elements[0].getTypeID().equals(element.getCockpitDataTypeID())) {
                    this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(elements[0].getProjectUID());
                    if (!this.projectAgent.isOpened()) {
                        return false;
                    }
                    IFrameDataManager dataManager = this.projectAgent.getDataManager(elements[0].getTypeID());
                    IAttributeOwner parent = dataManager.getParent((IAttributeOwner)elements[0]);
                    return parent == null || !parent.equals(this.projectAgent.getProject());
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyGeneral.General_1");
    }

    @Override
    public Image getPropertyImage() {
        return FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER).getIcon();
    }

    @Override
    public Composite getPropertyPage_internal(Composite parent) {
        IPropertiesDialog dialog = this.getDialog();
        dialog.setTitle(this.getDataType().getDisplayName((ICockpitProjectData)this.frameData), this);
        dialog.setMessage(Messages.getString("PropertyGeneral.Shows_all_general_properties_of_this__2"), 0, this);
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        base.setLayout((Layout)new GridLayout(2, false));
        IWorkbenchHelpSystem helpSystem = dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        this.attributeTypesComposite = new AttributeTypesComposite(this.frameData, base, true, false, false, dialog, this);
        this.attributeTypesComposite.create();
        return base;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.attributeTypesComposite.isModified();
    }

    public Collection<IModificationProblem> requestCommit() {
        this.newAttributes = this.attributeTypesComposite.getNewAttributes();
        this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        for (IAttribute attribute : this.newAttributes) {
            this.frameData.requestAttributeModificationPermission(attribute, this.transactionController);
        }
        return this.transactionController.execute();
    }

    @Override
    public void rollbackCommitRequest() {
        this.transactionController.rollback();
    }

    @Override
    public void commitPropertyChanges1() {
        for (IAttribute attribute : this.newAttributes) {
            try {
                this.frameData.setAttribute(attribute);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        if (this.attributeTypesComposite != null) {
            this.attributeTypesComposite.dispose();
        }
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        if (this.attributeTypesComposite != null) {
            problems.addAll(this.attributeTypesComposite.getModificationProblems(true));
        }
        if (this.initialCategoryModificationProblems != null) {
            problems.addAll(this.initialCategoryModificationProblems);
        }
        return problems;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        if (element != null && (element instanceof ISection || element instanceof ISection)) {
            return ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance();
        }
        if (element != null && (element instanceof IStakeholder || element instanceof IStakeholderRole)) {
            return ClientFunctionLicenseTypeModifyRolesAndStakeholders.getInstance();
        }
        if (element != null && element instanceof IReportTemplateFolderRW) {
            return ClientFunctionLicenseTypeModifyReportTemplates.getInstance();
        }
        return null;
    }
}

