/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.gui.dialogs.FileSystemErrorMessageDialogue;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.java.locale.LocaleHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.IModificationProblem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyAdvancedProject
implements IPropertiesListEntry {
    private static final ILogger logger = Logger.getLogger(PropertyAdvancedProject.class);
    private static final int LOGO_WIDTH = 300;
    private static final int LOGO_HEIGHT = 100;
    private static final IStreamResource DEFAULT_LOGO = Icons.getImageFileResourceForBigArcwayLogo();
    private static final String DEFAULT_COPYRIGHT_KEY = "PropertyAdvancedProject.9";
    private IFrameProjectAgent projectAgent;
    private IPropertiesDialog dialog;
    private boolean workOnCockpitModel;
    private Composite base;
    private Label labelLogo;
    private Image logo;
    private Canvas logoCanvas;
    private Button selectLogoButton;
    private FileID logoFileID;
    private IStreamResource selectedLogoFile;
    private Label labelCopyRight;
    private Text copyrightText;
    private Combo cmbLanguage;
    private Locale selectedLanguage;
    private boolean logoChanged = false;
    private boolean copyrightChanged = false;
    private boolean languageChanged = false;
    private final Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;

    private static final String getDefaultCopyright(Locale locale) {
        return Messages.getString(DEFAULT_COPYRIGHT_KEY, locale);
    }

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.init_internal((IFrameProjectAgent)elements[0], true, newDialog);
        return null;
    }

    public void init(IPropertiesDialog propertiesDialog) {
        this.init_internal(null, false, propertiesDialog);
    }

    private void init_internal(IFrameProjectAgent p_projectAgent, boolean p_workOnCockpitModel, IPropertiesDialog p_dialog) {
        assert (!p_workOnCockpitModel || p_projectAgent != null);
        this.projectAgent = p_projectAgent;
        this.setDialog(p_dialog);
        this.workOnCockpitModel = p_workOnCockpitModel;
        this.base = null;
        this.labelLogo = null;
        this.logo = null;
        this.logoCanvas = null;
        this.selectLogoButton = null;
        assert (this.logoFileID == null);
        this.logoFileID = null;
        this.selectedLogoFile = null;
        this.labelCopyRight = null;
        this.copyrightText = null;
        this.cmbLanguage = null;
        this.selectedLanguage = Locale.getDefault();
        this.logoChanged = false;
        this.copyrightChanged = false;
        this.languageChanged = false;
        this.modificationProblems.clear();
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    public IStreamResource getLogoFile() {
        return this.selectedLogoFile;
    }

    public String getCopyrightNotice() {
        if (this.copyrightText != null) {
            return this.copyrightText.getText();
        }
        return null;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1 && elements[0] instanceof IFrameProjectAgent) {
            IFrameProjectAgent p = (IFrameProjectAgent)elements[0];
            return p.isOpened();
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyAdvancedProject.2");
    }

    @Override
    public Image getPropertyImage() {
        return null;
    }

    public void setCopyrightText(String newCopyright) {
        this.copyrightText.setText(newCopyright);
    }

    public void setDefaultCopyrightText(Locale language) {
        this.copyrightText.setText(PropertyAdvancedProject.getDefaultCopyright(language));
    }

    public void setLanguage(String newLanguage) {
        if (this.cmbLanguage != null) {
            int i = 0;
            while (i < this.cmbLanguage.getItemCount()) {
                Locale local = (Locale)this.cmbLanguage.getData(Integer.toString(i));
                if (local.getLanguage().equalsIgnoreCase(newLanguage)) {
                    this.cmbLanguage.select(i);
                    this.selectedLanguage = local;
                    this.languageChanged = true;
                }
                ++i;
            }
        }
    }

    public void setLogoFile(IStreamResource newLogo) {
        Image logoImage = PropertyAdvancedProject.getImageForStream(newLogo);
        try {
            if (this.workOnCockpitModel) {
                FileID newLogoFileID = this.projectAgent.getFilesManager().loadFileIntoTemporaryStorage(newLogo);
                if (this.workOnCockpitModel && this.logoChanged) {
                    this.projectAgent.getFilesManager().removeFileFromTemporaryStorage(this.logoFileID);
                }
                this.logoFileID = newLogoFileID;
            }
            this.selectedLogoFile = newLogo;
            this.logoChanged = true;
            if (this.logo != null) {
                this.logo.dispose();
            }
            this.logo = logoImage;
            this.logoCanvas.redraw();
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            FileSystemErrorMessageDialogue.openFileSystemError((Shell)this.logoCanvas.getShell());
        }
    }

    private static Image getImageForStream(IStreamResource stream) {
        ImageDescriptor imageDescriptor = ImageCache.getImageDescriptor((IStreamResource)stream);
        Image image = imageDescriptor.createImage();
        return image;
    }

    public void resetLogoFile() {
        this.setLogoFile(DEFAULT_LOGO);
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        Project project;
        String cn;
        IModificationProblem modProblem;
        this.modificationProblems.clear();
        this.logo = null;
        this.dialog.setTitle(Messages.getString("PropertyAdvancedProject.3"), this);
        this.dialog.setMessage(Messages.getString("PropertyAdvancedProject.4"), 0, this);
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        this.base = new OwnComposite(parent, 0);
        this.base.setLayout((Layout)new GridLayout());
        this.base.setLayoutData((Object)new GridData(768));
        boolean mayEdit = true;
        if (this.workOnCockpitModel && this.projectAgent != null && (modProblem = this.projectAgent.getProjectMetaDataManager().getProject().checkLocks()) != null) {
            this.modificationProblems.add(modProblem);
            mayEdit = false;
        }
        boolean mayEditLogo = true;
        boolean mayEditCopyright = true;
        boolean mayEditLanguage = true;
        if (this.workOnCockpitModel && this.projectAgent != null) {
            Project project2 = this.projectAgent.getProjectMetaDataManager().getProject();
            try {
                IAttributeType attributeLogo = project2.getAttributeType(ProjectAttributeTypeProvider.ATTRID_LOGO);
                IAttributeType attributeCopyright = project2.getAttributeType(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT);
                IAttributeType attributeLanguage = project2.getAttributeType(ProjectAttributeTypeProvider.ATTRID_LANGUAGE);
                mayEditLogo = this.checkAttributeModificationPermission(mayEdit, project2, attributeLogo);
                mayEditCopyright = this.checkAttributeModificationPermission(mayEdit, project2, attributeCopyright);
                mayEditLanguage = this.checkAttributeModificationPermission(mayEdit, project2, attributeLanguage);
            }
            catch (ExInvalidAttributeType e) {
                logger.error("attribute type not defined", (Throwable)e);
            }
        }
        Composite logoGroup = new Composite(this.base, 0);
        logoGroup.setLayoutData((Object)new GridData(768));
        logoGroup.setLayout((Layout)new GridLayout());
        this.labelLogo = new Label(logoGroup, 0);
        this.labelLogo.setText(Messages.getString("PropertyAdvancedProject.5"));
        if (this.projectAgent != null) {
            ImageDescriptor id = this.projectAgent.getProjectLogo();
            if (id != null) {
                this.logo = id.createImage();
            }
        } else {
            this.logo = PropertyAdvancedProject.getImageForStream(DEFAULT_LOGO);
        }
        GridData data = new GridData(4);
        data.heightHint = 100;
        data.widthHint = 300;
        data.horizontalSpan = 2;
        this.logoCanvas = new Canvas(logoGroup, 2048);
        this.logoCanvas.setLayoutData((Object)data);
        this.logoCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (PropertyAdvancedProject.this.logo != null) {
                    float divisorWidth = 1.0f;
                    float divisorHeight = 1.0f;
                    int width = ((PropertyAdvancedProject)PropertyAdvancedProject.this).logo.getImageData().width;
                    int height = ((PropertyAdvancedProject)PropertyAdvancedProject.this).logo.getImageData().height;
                    if (width > 300) {
                        divisorWidth = (float)width / 300.0f;
                    }
                    if (height > 100) {
                        divisorHeight = (float)height / 100.0f;
                    }
                    float divisor = Math.max(divisorHeight, divisorWidth);
                    int newWidth = Math.round((float)width / divisor);
                    int newHeight = Math.round((float)height / divisor);
                    gc.drawImage(PropertyAdvancedProject.this.logo, 0, 0, width, height, (300 - newWidth) / 2, (100 - newHeight) / 2, newWidth, newHeight);
                } else {
                    gc.drawLine(0, 0, 300, 100);
                    gc.drawLine(300, 0, 0, 100);
                }
            }
        });
        this.selectLogoButton = new Button(logoGroup, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        this.selectLogoButton.setLayoutData((Object)data);
        this.selectLogoButton.setEnabled(mayEditLogo);
        this.selectLogoButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyAdvancedProject.this.findLogo();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertyAdvancedProject.this.findLogo();
            }
        });
        this.selectLogoButton.setText(Messages.getString("PropertyAdvancedProject.6"));
        Composite copyrightBase = new Composite(this.base, 0);
        copyrightBase.setLayout((Layout)new GridLayout(1, false));
        copyrightBase.setLayoutData((Object)new GridData(1808));
        this.labelCopyRight = new Label(copyrightBase, 0);
        this.labelCopyRight.setText(Messages.getString("PropertyAdvancedProject.7"));
        this.copyrightText = new Text(copyrightBase, 2052);
        this.copyrightText.setLayoutData((Object)new GridData(768));
        this.copyrightText.setEnabled(mayEditCopyright);
        if (this.projectAgent != null && (cn = (project = this.projectAgent.getProjectMetaDataManager().getProject()).getCopyRight()) != null) {
            this.copyrightText.setText(cn);
        }
        this.copyrightText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertyAdvancedProject.this.copyrightChanged = true;
            }
        });
        if (this.projectAgent == null) {
            this.copyrightText.setText(PropertyAdvancedProject.getDefaultCopyright(Locale.getDefault()));
        }
        if (this.projectAgent != null) {
            Label label = new Label(copyrightBase, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setText(Messages.getString("PropertyAdvancedProject.language"));
            this.cmbLanguage = new Combo(copyrightBase, 0);
            this.cmbLanguage.setLayoutData((Object)new GridData(768));
            TreeSet<Locale> sortedLanguages = new TreeSet<Locale>(new Comparator<Locale>(){

                @Override
                public int compare(Locale arg0, Locale arg1) {
                    return LocaleHelper.getDisplayLanguage((Locale)arg0).compareToIgnoreCase(LocaleHelper.getDisplayLanguage((Locale)arg1));
                }
            });
            sortedLanguages.addAll(Arrays.asList(LocaleHelper.getAvailableLocales()));
            String defaultLanguage = Locale.getDefault().getLanguage();
            if (this.projectAgent != null) {
                defaultLanguage = this.projectAgent.getLanguage();
            }
            for (Locale locale : sortedLanguages) {
                this.cmbLanguage.add(LocaleHelper.getDisplayLanguage((Locale)locale));
                int index = this.cmbLanguage.getItemCount() - 1;
                if (locale.getLanguage().equals(defaultLanguage)) {
                    this.cmbLanguage.select(index);
                }
                String strIndex = Integer.toString(index);
                this.cmbLanguage.setData(strIndex, (Object)locale);
            }
            this.cmbLanguage.setEnabled(mayEditLanguage);
            this.cmbLanguage.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String strIndex = Integer.toString(PropertyAdvancedProject.this.cmbLanguage.getSelectionIndex());
                    Locale locale = (Locale)PropertyAdvancedProject.this.cmbLanguage.getData(strIndex);
                    PropertyAdvancedProject.this.selectedLanguage = locale;
                    PropertyAdvancedProject.this.languageChanged = true;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.base.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PropertyAdvancedProject.this.logo != null && !PropertyAdvancedProject.this.logo.isDisposed()) {
                    PropertyAdvancedProject.this.logo.dispose();
                }
            }
        });
        return this.base;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.logoChanged || this.copyrightChanged || this.languageChanged;
    }

    @Override
    public void commitPropertyChanges1() {
        if (this.workOnCockpitModel) {
            if (this.transactionController != null) {
                Project project = this.projectAgent.getProjectMetaDataManager().getProject();
                for (IAttribute attribute : this.newAttributes) {
                    try {
                        project.setAttribute(attribute);
                    }
                    catch (ExInvalidAttributeType e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (ExInvalidDataType e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (EXNoPermission e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (EXNoLock e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                }
            }
            if (this.logoChanged) {
                this.projectAgent.getFilesManager().removeFileFromTemporaryStorage(this.logoFileID);
                this.logoFileID = null;
                this.logoChanged = false;
            }
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        if (this.workOnCockpitModel) {
            String strIndex;
            Locale locale;
            int index;
            Project project = this.projectAgent.getProjectMetaDataManager().getProject();
            this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.newAttributes = new ArrayList<IAttribute>();
            String cn = this.copyrightText.getText();
            if (cn != null && this.copyrightChanged) {
                Attribute attribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT, cn);
                this.newAttributes.add(attribute);
            }
            if (this.logoFileID != null && this.logoChanged) {
                Attribute newLogoAttribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_LOGO, this.logoFileID);
                this.newAttributes.add(newLogoAttribute);
            }
            if ((index = this.cmbLanguage.getSelectionIndex()) > -1 && !(locale = (Locale)this.cmbLanguage.getData(strIndex = Integer.toString(index))).getLanguage().equals(this.projectAgent.getLanguage())) {
                Attribute attribute = new Attribute(ProjectAttributeTypeProvider.ATTRID_LANGUAGE, locale.getLanguage());
                this.newAttributes.add(attribute);
                boolean allSaved = this.projectAgent.saveAllEditors(this.base.getShell(), Messages.getString("PropertyAdvancedProject.save"), false, true, false);
                if (!allSaved) {
                    this.transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("Formeditors.cancelSaveing"), Messages.getString("PropertyAdvancedProject.canceled"), 4));
                }
            }
            for (IAttribute attribute : this.newAttributes) {
                project.requestAttributeModificationPermission(attribute, this.transactionController);
            }
            return this.transactionController.execute();
        }
        return Collections.emptySet();
    }

    public String getLanguage() {
        return this.selectedLanguage.getLanguage();
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.workOnCockpitModel) {
            if (this.transactionController != null) {
                this.transactionController.rollback();
            }
            this.transactionController = null;
            this.newAttributes = null;
        }
    }

    @Override
    public void cancelPropertyChanges1() {
        if (this.workOnCockpitModel) {
            String cn = this.projectAgent.getProjectMetaDataManager().getProject().getCopyRight();
            if (cn == null) {
                cn = "";
            }
            this.copyrightText.setText(cn);
            this.selectedLogoFile = null;
            if (this.logoChanged) {
                this.projectAgent.getFilesManager().removeFileFromTemporaryStorage(this.logoFileID);
            }
            this.logoChanged = false;
            this.logoFileID = null;
            this.copyrightChanged = false;
            this.languageChanged = false;
        }
    }

    @Override
    public void disposeResources() {
    }

    @Override
    public int getTypeOfPage() {
        return 20;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        return this.modificationProblems;
    }

    private boolean findLogo() {
        FileChooserDialog fileChooser = new FileChooserDialog(new String[]{"*.gif; *.jpg; *.png; *.ico; *.bmp"}, this.base.getShell());
        File chosenFile = fileChooser.openForLoad();
        if (chosenFile != null) {
            this.setLogoFile((IStreamResource)new FileResource(chosenFile));
            return true;
        }
        return false;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return null;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }

    private boolean checkAttributeModificationPermission(boolean mayEdit, Project project, IAttributeType attributeType) {
        boolean attributeModificationPermission;
        Collection<IModificationProblem> modProblems = project.checkGeneralAttributeModificationPermission(attributeType);
        if (!modProblems.isEmpty()) {
            this.modificationProblems.addAll(modProblems);
            attributeModificationPermission = false;
        } else {
            attributeModificationPermission = mayEdit;
        }
        return attributeModificationPermission;
    }

    private class OwnComposite
    extends Composite {
        private OwnComposite(Composite parent, int style) {
            super(parent, style);
        }

        public void setEnabled(boolean enabled) {
            if (PropertyAdvancedProject.this.selectLogoButton != null) {
                PropertyAdvancedProject.this.selectLogoButton.setEnabled(enabled);
            }
            if (PropertyAdvancedProject.this.labelLogo != null) {
                PropertyAdvancedProject.this.labelLogo.setEnabled(enabled);
            }
            if (PropertyAdvancedProject.this.labelCopyRight != null) {
                PropertyAdvancedProject.this.labelCopyRight.setEnabled(enabled);
            }
            if (PropertyAdvancedProject.this.copyrightText != null) {
                PropertyAdvancedProject.this.copyrightText.setEnabled(enabled);
            }
            if (PropertyAdvancedProject.this.cmbLanguage != null) {
                PropertyAdvancedProject.this.cmbLanguage.setEnabled(enabled);
            }
            super.setEnabled(enabled);
        }
    }
}

