/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.dialogs.stakeholder.AddStakeholderDialog;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderAddID;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHFileNewStakeholder
extends AbstractHandler {
    private static final ILogger logger = Logger.getLogger(CHFileNewStakeholder.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        AddStakeholderDialog dialog;
        int answer;
        ProjectAgent projectAgent;
        String projectUID;
        IStructuredSelection selection;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell != null && (selection = CommandHandlerHelper.getRelevantSelection(event)) != null && (projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection)) != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)) != null && projectAgent.isOpened() && (answer = (dialog = new AddStakeholderDialog(shell, projectAgent)).open()) == 0) {
            String name = dialog.getNewStakeholderName();
            ObjectTypeCategoryID categoryID = dialog.getObjectTypeCategoryID();
            Collection<IAttribute> attributes = dialog.getNewStakeholderAttributes();
            IStakeholderAddID addID = projectAgent.getFrameStakeholderManager().requestStakeholderAddPermission(name, categoryID, attributes);
            if (addID.permissionGranted()) {
                try {
                    projectAgent.getFrameStakeholderManager().addStakeholder(addID);
                }
                catch (EXNoPermission e) {
                    logger.error("could not execute", (Throwable)e);
                }
            } else {
                ModificationProblemsDialog problemsDialog = new ModificationProblemsDialog(Collections.singletonList(addID.getModificationProblem()), shell);
                problemsDialog.open();
            }
        }
        return null;
    }
}

