/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.menu.handlers;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.CreateSectionWizard;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHFileNewFolder
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection;
        Object o;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection != null && currentSelection instanceof IStructuredSelection && (o = (selection = (IStructuredSelection)currentSelection).getFirstElement()) != null) {
            if (o instanceof ProjectAgent) {
                ProjectAgent projectAgent = (ProjectAgent)o;
                ISection section = projectAgent.getSectionManager().getRootSection();
                this.createSection(projectAgent, section, activeShell);
            } else if (o instanceof ISection) {
                ISection section = (ISection)o;
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
                this.createSection(projectAgent, section, activeShell);
            }
        }
        return null;
    }

    private void createSection(ProjectAgent projectAgent, ISection parentSection, Shell shell) {
        IModificationProblem problem = projectAgent.getFrameSectionManager().checkSectionAdditionPermission(parentSection, true);
        if (problem == null) {
            CreateSectionWizard createSectionWizard = new CreateSectionWizard(projectAgent, parentSection);
            ArcwayWizardDialog wizardDialog = new ArcwayWizardDialog(shell, (IWizard)createSectionWizard);
            wizardDialog.open();
        } else {
            ArrayList<IModificationProblem> mpProblems = new ArrayList<IModificationProblem>();
            mpProblems.add(problem);
            String title = Messages.getString("CreateSectionAction.CannotCreateSection.Title");
            String message = NLS.bind((String)Messages.getString("CreateSectionAction.CannotCreateSection.Message"), (Object)parentSection.getSectionName());
            ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mpProblems, title, message, shell);
            mpDialog.open();
        }
    }
}

