/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.dialogs;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class SaveDirtyEditorsDialogUtil {
    public static void showSaveDirtyEditorsDialog(Shell parentShell, String dialogTitle, String dialogMessage, IFrameProjectAgent projectAgent, final Collection<IRepositoryObjectReference> dirtyObjectReferences) {
        IRepositoryInterfaceRO repositoryInterface = projectAgent.getRepositoryInterface();
        final IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
        final IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)repositoryInterface.getTypeManager());
        final PresentationContext presentationContext = new PresentationContext(new Locale(projectAgent.getLanguage()), new Date(), TimeZone.getDefault());
        final ArrayList dirtyObjectsLables = new ArrayList(dirtyObjectReferences.size());
        RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

            public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                for (IRepositoryObjectReference objectReference : dirtyObjectReferences) {
                    IRepositoryObjectType objectType = typeManager.getObjectType(objectReference.getObjectTypeID());
                    IRepositoryObject repositoryObject = snapshot.findRepositoryObject(objectType, objectReference.getObjectID());
                    IExpiringFrontendLabel frontendLabel = frontendTypeManager.getLabelForObject(repositoryObject, presentationContext);
                    dirtyObjectsLables.add(frontendLabel);
                }
            }
        });
        final Integer[] tableViewerInput = new Integer[dirtyObjectsLables.size()];
        int i = 0;
        while (i < tableViewerInput.length) {
            tableViewerInput[i] = i;
            ++i;
        }
        MessageDialog md = new MessageDialog(parentShell, dialogTitle, null, dialogMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected Control createCustomArea(Composite parent) {
                Table table = new Table(parent, 68352);
                GridData data = new GridData(1808);
                table.setLayoutData((Object)data);
                TableViewer tableViewer = new TableViewer(table);
                tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return (Object[])inputElement;
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                });
                tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(tableViewerInput){
                    private final Image[] allocatedColumnImages;
                    {
                        this.allocatedColumnImages = new Image[integerArray.length];
                    }

                    public String getColumnText(Object element, int columnIndex) {
                        if (element instanceof Integer) {
                            IExpiringFrontendLabel item = (IExpiringFrontendLabel)dirtyObjectsLables.get((Integer)element);
                            return item.getText();
                        }
                        return "" + element;
                    }

                    public Image getColumnImage(Object element, int columnIndex) {
                        if (element instanceof Integer) {
                            IExpiringFrontendLabel item;
                            IStreamResource icon16x16AsStreamResource;
                            int elementIndex = (Integer)element;
                            Image image = this.allocatedColumnImages[elementIndex];
                            if (image == null && (icon16x16AsStreamResource = (item = (IExpiringFrontendLabel)dirtyObjectsLables.get(elementIndex)).getIcon16x16()) != null) {
                                Display imageDevice = this.getShell().getDisplay();
                                try {
                                    InputStream inputStream = icon16x16AsStreamResource.toInputStream();
                                    image = new Image((Device)imageDevice, inputStream);
                                }
                                catch (SWTException e) {
                                    image = ImageDescriptor.getMissingImageDescriptor().createImage((Device)imageDevice);
                                }
                                catch (JvmExternalResourceInteractionException e) {
                                    image = ImageDescriptor.getMissingImageDescriptor().createImage((Device)imageDevice);
                                }
                                this.allocatedColumnImages[elementIndex] = image;
                            }
                            return image;
                        }
                        return null;
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public void dispose() {
                        Image[] imageArray = this.allocatedColumnImages;
                        int n = this.allocatedColumnImages.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Image image = imageArray[n2];
                            if (image != null) {
                                image.dispose();
                            }
                            ++n2;
                        }
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return false;
                    }

                    public void removeListener(ILabelProviderListener listener) {
                    }
                });
                tableViewer.setInput((Object)tableViewerInput);
                tableViewer.refresh();
                return table;
            }
        };
        md.open();
    }
}

