/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.errorreporting.gui;

import com.arcway.cockpit.errorreporting.data.AdditionalFileFetcher;
import com.arcway.cockpit.errorreporting.data.CockpitLogFetcher;
import com.arcway.cockpit.errorreporting.data.CockpitVariantDetector;
import com.arcway.cockpit.errorreporting.data.EclipseLogFetcher;
import com.arcway.cockpit.errorreporting.data.IDataFetcher;
import com.arcway.cockpit.errorreporting.data.LicensesFetcher;
import com.arcway.cockpit.errorreporting.gui.ErrorBriefDescriptionAndCustomerContactData;
import com.arcway.cockpit.errorreporting.gui.ErrorReportingHtmlFileWizardPage;
import com.arcway.cockpit.errorreporting.gui.ErrorReportingOverviewWizardPage;
import com.arcway.cockpit.errorreporting.gui.ErrorReportingQuestionsWizardPage;
import com.arcway.cockpit.errorreporting.gui.ErrorReportingSendEmailWizardPage;
import com.arcway.cockpit.errorreporting.gui.FileAttachmentsWizardPage;
import com.arcway.cockpit.errorreporting.gui.Messages;
import com.arcway.cockpit.errorreporting.pakager.Pakager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.fmca.client.PSCServices;
import de.plans.psc.client.PSCApplicationIdentifier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class ErrorReportingWizard
extends Wizard {
    private static final ILogger logger = Logger.getLogger(ErrorReportingWizard.class);
    private static final String CRLF = "\r\n";
    private static final String PAGENAME_OVERVIEW = "Overview";
    private static final String PAGENAME_QUESTIONS = "Questions";
    private static final String PAGENAME_ATTACHMENTS = "Attachments";
    private static final String PAGENAME_SEND_MAIL = "SendMail";
    private static final String LAST_PAGE_NAME = "SendMail";
    private final CockpitLogFetcher cockpitLogFetcher = new CockpitLogFetcher();
    private final LicensesFetcher licensesFetcher = new LicensesFetcher();
    private final EclipseLogFetcher eclipseLogFetcher = new EclipseLogFetcher();
    private final AdditionalFileFetcher additionalFileFetcher = new AdditionalFileFetcher();
    private final Collection<IDataFetcher> allsDataFetchers = new ArrayList<IDataFetcher>();
    private ErrorReportingHtmlFileWizardPage errorReportingWizardPageOverview;
    private ErrorReportingHtmlFileWizardPage errorReportingWizardPageQuestions;
    private FileAttachmentsWizardPage fileAttachmentsWizardPage;
    private ErrorReportingHtmlFileWizardPage errorReportingWizardPageSendEmail;
    private boolean lastPageVisited = false;

    public ErrorReportingWizard() {
        this.allsDataFetchers.add(this.cockpitLogFetcher);
        this.allsDataFetchers.add(this.eclipseLogFetcher);
        this.allsDataFetchers.add(this.licensesFetcher);
        this.allsDataFetchers.add(this.additionalFileFetcher);
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(Messages.getString("ErrorReportingWizard.WindowTitle"));
        this.errorReportingWizardPageOverview = new ErrorReportingOverviewWizardPage(PAGENAME_OVERVIEW);
        this.errorReportingWizardPageQuestions = new ErrorReportingQuestionsWizardPage(PAGENAME_QUESTIONS);
        this.fileAttachmentsWizardPage = new FileAttachmentsWizardPage(PAGENAME_ATTACHMENTS, this);
        this.errorReportingWizardPageSendEmail = new ErrorReportingSendEmailWizardPage("SendMail");
        this.addPage((IWizardPage)this.errorReportingWizardPageOverview);
        this.addPage((IWizardPage)this.errorReportingWizardPageQuestions);
        this.addPage((IWizardPage)this.fileAttachmentsWizardPage);
        this.addPage((IWizardPage)this.errorReportingWizardPageSendEmail);
    }

    public boolean performFinish() {
        return true;
    }

    private static String createSystemPropertySummary(String[] systemPropertyNames) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = systemPropertyNames;
        int n = systemPropertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (propertyName != null && propertyName.length() > 0) {
                sb.append(propertyName);
                sb.append(": ");
                try {
                    sb.append(System.getProperty(propertyName));
                }
                catch (Throwable th) {
                    sb.append("[Exception - ");
                    sb.append(th.getLocalizedMessage());
                    sb.append("]");
                }
            }
            sb.append(CRLF);
            ++n2;
        }
        return sb.toString();
    }

    public File createDiagnoseInformationPackage(File selectedFile) {
        assert (selectedFile != null);
        Pakager p = new Pakager();
        try {
            StringBuilder applicationAndVersion = new StringBuilder();
            try {
                PSCApplicationIdentifier applicationIdentifier = PSCServices.getServiceFacade().getApplicationIdentifier();
                applicationIdentifier.getClientVersion();
                applicationAndVersion.append(applicationIdentifier.getApplicationName());
                applicationAndVersion.append(" ");
                applicationAndVersion.append(applicationIdentifier.getClientVersion());
                applicationAndVersion.append(" ");
                applicationAndVersion.append(CockpitVariantDetector.convertDetectedCockpitVariant2ShortString(CockpitVariantDetector.detectCockpitVariant()));
                applicationAndVersion.append(" (Build: ");
                applicationAndVersion.append(applicationIdentifier.getClientBuild());
                applicationAndVersion.append(")");
                applicationAndVersion.append(CRLF);
                applicationAndVersion.append(CRLF);
            }
            catch (Exception e) {
                logger.error("Unable to detect Cockpit ApplicationAndVersion Information for inclusion in DiagnoseInformationPackage.", (Throwable)e);
            }
            String description = String.valueOf(applicationAndVersion.toString()) + ErrorReportingWizard.createSystemPropertySummary(new String[]{"eclipse.product", "com.arcway.cockpit.richclientapplication.webstart", "", "os.arch", "os.name", "", "user.name", "user.country", "user.dir", "", "java.runtime.version", "java.home", "java.io.tmpdir", "", "osgi.os", "osgi.arch", "osgi.nl", "osgi.nl.user", "", "osgi.install.area", "osgi.configuration.area", "osgi.instance.area"});
            ErrorBriefDescriptionAndCustomerContactData errorBriefDescriptionAndCustomerContactData = new ErrorBriefDescriptionAndCustomerContactData(description, ErrorReportingWizard.createSystemPropertySummary(new String[]{"user.name"}), "");
            return p.createErrorReportPackage(selectedFile, this.allsDataFetchers, errorBriefDescriptionAndCustomerContactData);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("unhandled catch block", (Throwable)e);
            throw new Error(e);
        }
        catch (IOException e) {
            logger.error("unhandled catch block", (Throwable)e);
            throw new Error(e);
        }
    }

    public boolean canFinish() {
        if ("SendMail".equals(this.getContainer().getCurrentPage().getName())) {
            this.lastPageVisited = true;
        }
        return this.lastPageVisited;
    }
}

