/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.core.project.datafacade;

import com.arcway.cockpit.documentmodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExCategory;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ImExDocumentContainer
extends AbstractImExModuleData {
    private final String uID;
    private final String displayName;
    private final String keywords;
    private final String status;
    private final List<ImExResourceLocator> resourceLocators = new ArrayList<ImExResourceLocator>();
    private final DataFacade dataFacade;
    Locale locale;

    public ImExDocumentContainer(DocumentContainer documentContainer, DataFacade dataFacade, IModelController modelController, Locale locale) {
        super((AbstractModuleData)documentContainer, modelController, locale);
        this.dataFacade = dataFacade;
        this.locale = locale;
        this.uID = documentContainer.getUID();
        this.displayName = documentContainer.getName().getDisplayStringRepresentation();
        this.keywords = documentContainer.getKeywords().getDisplayStringRepresentation();
        this.status = documentContainer.getState().getDisplayStringRepresentation(locale);
        this.resourceLocators.addAll(dataFacade.getResourceLocators(documentContainer, locale));
    }

    public String getUID() {
        return this.uID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getStatus() {
        return this.status;
    }

    public List<ImExResourceLocator> getResourceLocators() {
        return this.resourceLocators;
    }

    public ImExCategory getCategory() {
        return this.dataFacade.getCategory((DocumentContainer)this.getModuleData(), this.locale);
    }
}

