/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.documentmodule.docgen.provider.interfaces.IResourceLocator;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataDocGenProxy;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class ResourceLocatorDocGenProxy
extends AbstractModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
IResourceLocator {
    private static final ILogger logger = Logger.getLogger(ResourceLocatorDocGenProxy.class);
    private ImExResourceLocator resourceLocator = null;
    private final Locale locale;

    public ResourceLocatorDocGenProxy(ImExResourceLocator resourceLocator, DataFacade dataFacade, IGraphicsAndFilesHelper graphicsAndFilesHelper, Locale locale) {
        super((AbstractImExModuleData)resourceLocator, graphicsAndFilesHelper, locale);
        this.resourceLocator = resourceLocator;
        this.locale = locale;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.resourceLocator.getUID();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.resourceLocator.getURL());
    }

    public String getTypeID() {
        return "dcm.resourceLocator";
    }

    public String getTypeName() {
        return ResourceLocator.getTypeName((Locale)this.locale);
    }

    @Override
    public String getURL() {
        return HTMLEncoder.encode((String)this.resourceLocator.getURL());
    }

    protected static List<? extends IResourceLocator> transformResourceLocatorList(List resourceLocators, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale) {
        ArrayList<ResourceLocatorDocGenProxy> locators = new ArrayList<ResourceLocatorDocGenProxy>(resourceLocators.size());
        Iterator locatorIter = resourceLocators.iterator();
        while (locatorIter.hasNext()) {
            locators.add(new ResourceLocatorDocGenProxy((ImExResourceLocator)locatorIter.next(), dataFacade, graphicsProvider, locale));
        }
        return locators;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.resourceLocator;
    }

    public String getCommitVersion() {
        int commitCount = this.resourceLocator.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    @Override
    public boolean isFileLink() {
        return this.resourceLocator.isFileLink();
    }

    @Override
    public boolean isWebLink() {
        return this.resourceLocator.isWebLink();
    }
}

