/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.docgen.provider;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExCategory;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExDocumentContainer;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.description.DocumentContainerDescription;
import com.arcway.cockpit.documentmodule.docgen.provider.DocumentContainerSetDocGenProxy;
import com.arcway.cockpit.documentmodule.docgen.provider.ResourceLocatorDocGenProxy;
import com.arcway.cockpit.documentmodule.docgen.provider.interfaces.IDocumentContainer;
import com.arcway.cockpit.documentmodule.docgen.provider.interfaces.IDocumentContainerSet;
import com.arcway.cockpit.documentmodule.docgen.provider.interfaces.IResourceLocator;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataDocGenProxy;
import com.arcway.lib.java.Equals;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DocumentContainerDocGenProxy
extends AbstractModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
IDocumentContainer {
    private DataFacade dataFacade = null;
    private IGraphicsAndFilesHelper graphicsAndFilesHelper = null;
    private ImExDocumentContainer container = null;
    private Collection<AbstractFilter> filters = null;
    private final Locale locale;

    public DocumentContainerDocGenProxy(ImExDocumentContainer container, DataFacade dataFacade, IGraphicsAndFilesHelper graphicsProvider, Collection<AbstractFilter> filters, Locale locale) {
        super((AbstractImExModuleData)container, graphicsProvider, locale);
        this.container = container;
        this.dataFacade = dataFacade;
        this.graphicsAndFilesHelper = graphicsProvider;
        this.filters = filters;
        this.locale = locale;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.container.getUID();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.container.getDisplayName());
    }

    public String getTypeID() {
        return "dcm.documentContainer";
    }

    public String getTypeName() {
        return new DocumentContainerDescription().getTypeName(this.locale);
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.container.getDisplayName());
    }

    @Override
    public String getKeywords() {
        return HTMLEncoder.encode((String)this.container.getKeywords());
    }

    @Override
    public String getStatus() {
        return HTMLEncoder.encode((String)this.container.getStatus());
    }

    @Override
    public boolean containsResourceLocators() {
        boolean result = false;
        List docs = this.container.getResourceLocators();
        result = docs.size() > 0;
        return result;
    }

    @Override
    public List<? extends IResourceLocator> getResourceLocators() {
        List<ImExResourceLocator> locatorList = this.getResourceLocators_Internal();
        return ResourceLocatorDocGenProxy.transformResourceLocatorList(locatorList, this.graphicsAndFilesHelper, this.dataFacade, this.filters, this.locale);
    }

    private List<? extends IResourceLocator> getFileOrWebLinks(boolean fileLinks) {
        List<? extends IResourceLocator> ressources = this.getResourceLocators();
        ArrayList<IResourceLocator> allFileLinks = new ArrayList<IResourceLocator>(ressources.size());
        for (IResourceLocator iResourceLocator : ressources) {
            if ((!fileLinks || !iResourceLocator.isFileLink()) && (fileLinks || !iResourceLocator.isWebLink())) continue;
            allFileLinks.add(iResourceLocator);
        }
        return allFileLinks;
    }

    @Override
    public List<? extends IResourceLocator> getWebLinks() {
        return this.getFileOrWebLinks(false);
    }

    @Override
    public List<? extends IResourceLocator> getFileLinks() {
        return this.getFileOrWebLinks(true);
    }

    @Override
    public List<? extends IResourceLocator> getWebLinksWithCategory(String categoryID) {
        List<? extends IResourceLocator> webLinks = this.getWebLinks();
        return DocumentContainerDocGenProxy.filterByCategoryIDAsResourceLocator(webLinks, categoryID);
    }

    @Override
    public List<? extends IResourceLocator> getFileLinksWithCategory(String categoryID) {
        return DocumentContainerDocGenProxy.filterByCategoryIDAsResourceLocator(this.getFileLinks(), categoryID);
    }

    @Override
    public List<? extends IResourceLocator> getWebLinksWithDefaultCategory() {
        return this.getWebLinksWithCategory(null);
    }

    @Override
    public List<? extends IResourceLocator> getFileLinksWithDefaultCategory() {
        return this.getFileLinksWithCategory(null);
    }

    private List<ImExResourceLocator> getResourceLocators_Internal() {
        return new ArrayList<ImExResourceLocator>(this.container.getResourceLocators());
    }

    @Deprecated
    public String getCategory() {
        ImExCategory category = this.container.getCategory();
        if (category != null) {
            return HTMLEncoder.encode((String)category.getDisplayName());
        }
        return "";
    }

    @Override
    public String getDocumentContainerSet() {
        ImExCategory category = this.container.getCategory();
        if (category != null) {
            return HTMLEncoder.encode((String)category.getDisplayName());
        }
        return "";
    }

    @Override
    public IDocumentContainerSet getDocumentContainerSetInterface() {
        ImExCategory imExDocumentContainerSet = this.container.getCategory();
        if (imExDocumentContainerSet != null) {
            List<? extends IDocumentContainerSet> documentContainerSetProxyList = DocumentContainerSetDocGenProxy.transformDocumentContainerSetList(Collections.singletonList(imExDocumentContainerSet), this.dataFacade, this.filters, this.getGraphicsAndFilesHelper(), this.locale);
            return documentContainerSetProxyList.get(0);
        }
        return null;
    }

    protected static List<? extends IDocumentContainer> transformDocumentContainerList(List<ImExDocumentContainer> documentContainers, DataFacade dataFacade, Collection<AbstractFilter> filters, IGraphicsAndFilesHelper graphicsProvider, Locale locale) {
        ArrayList<DocumentContainerDocGenProxy> result = new ArrayList<DocumentContainerDocGenProxy>(documentContainers.size());
        for (ImExDocumentContainer containerData : documentContainers) {
            DocumentContainerDocGenProxy reqSetDesc = new DocumentContainerDocGenProxy(containerData, dataFacade, graphicsProvider, filters, locale);
            result.add(reqSetDesc);
        }
        return result;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.container;
    }

    public String getCommitVersion() {
        int commitCount = this.container.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    private static final List<IResourceLocator> filterByCategoryIDAsResourceLocator(List<? extends IResourceLocator> toFilter, String categoryID) {
        if (toFilter == null) {
            return null;
        }
        ArrayList<IResourceLocator> filtered = new ArrayList<IResourceLocator>(toFilter.size());
        for (IResourceLocator iResourceLocator : toFilter) {
            if (!Equals.equals((Object)iResourceLocator.getCategoryID(), (Object)categoryID)) continue;
            filtered.add(iResourceLocator);
        }
        return filtered;
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("name")) {
            record.set("name", (Object)this.getName());
        }
        return record;
    }
}

