/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.provider.utils;

import com.arcway.cockpit.docgen.graphicsandfiles.GraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.Record;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.DTValue;
import com.arcway.lib.codec.data.EXDataAssemblingFailed;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IList_;
import java.util.List;
import java.util.Locale;

public class DTRecord
implements IStructuredDataType {
    public static final String FLAG_PREFIX = "flag" + IKey.KEY_SPERARTOR;
    public static final String PROPERTY_PREFIX = "property" + IKey.KEY_SPERARTOR;
    public static final String CHILD_PREFIX = "child" + IKey.KEY_SPERARTOR;
    private final GraphicsAndFilesHelper graphicsAndFilesHelper;
    private final Locale locale;
    private final DTValue dataTypeValue = new DTValue(this);

    public DTRecord(GraphicsAndFilesHelper graphicsAndFilesHelper, Locale locale) {
        this.graphicsAndFilesHelper = graphicsAndFilesHelper;
        this.locale = locale;
    }

    public Class<? extends IDataType> getStructureType() {
        return IStructuredDataType.class;
    }

    public IDataType getConcreteDataType() {
        return this;
    }

    public boolean isNull(Object data) {
        return data == null;
    }

    public Object createNullDataElement() throws EXDataCreationFailed {
        return null;
    }

    public IList_<IKey> getFlagAndPropertyAndChildRoles(Object data) {
        IRecord record = (IRecord)data;
        List<String> keySet = record.getKeySet();
        ArrayList_ keysWithSupportedValues = new ArrayList_(keySet.size());
        for (String key : keySet) {
            if (record.isTrue(key)) {
                keysWithSupportedValues.add((Object)Key.getCanonicalKeyInstance((String)(String.valueOf(FLAG_PREFIX) + key)));
                continue;
            }
            List<Object> values = record.getAll(key);
            boolean containsValuesOfSupportedDataTypes = DTValue.containsValuesOfSupportedDataTypes(values);
            if (!containsValuesOfSupportedDataTypes) continue;
            if (record.isProperty(key)) {
                keysWithSupportedValues.add((Object)Key.getCanonicalKeyInstance((String)(String.valueOf(PROPERTY_PREFIX) + key)));
                continue;
            }
            keysWithSupportedValues.add((Object)Key.getCanonicalKeyInstance((String)(String.valueOf(CHILD_PREFIX) + key)));
        }
        return keysWithSupportedValues;
    }

    public SubDataType getSubDataType(IKey role) {
        SubDataType subDataType;
        String keyWithPrefix = role.toCanonicalString();
        if (keyWithPrefix.startsWith(FLAG_PREFIX)) {
            subDataType = SubDataType.IS_FLAG;
        } else if (keyWithPrefix.startsWith(PROPERTY_PREFIX)) {
            subDataType = SubDataType.IS_PROPERTY;
        } else if (keyWithPrefix.startsWith(CHILD_PREFIX)) {
            subDataType = SubDataType.IS_CHILD;
        } else {
            throw new IllegalArgumentException();
        }
        return subDataType;
    }

    public boolean isSet(Object data, IKey role) {
        IRecord record = (IRecord)data;
        String keyWithPrefix = role.toCanonicalString();
        if (!keyWithPrefix.startsWith(FLAG_PREFIX)) {
            throw new IllegalArgumentException();
        }
        String key = keyWithPrefix.substring(FLAG_PREFIX.length());
        boolean isSet = record.isTrue(key);
        return isSet;
    }

    public IDataType getDataTypeOfPropertyOrChildren(Object data, IKey role) {
        return this.dataTypeValue;
    }

    public Object getProperty(Object data, IKey role) {
        Object value;
        IRecord record = (IRecord)data;
        String keyWithPrefix = role.toCanonicalString();
        if (!keyWithPrefix.startsWith(PROPERTY_PREFIX)) {
            throw new IllegalArgumentException();
        }
        String key = keyWithPrefix.substring(PROPERTY_PREFIX.length());
        Object property = value = record.get(key);
        return property;
    }

    public IList_<? extends Object> getChildren(Object data, IKey role) {
        IRecord record = (IRecord)data;
        String keyWithPrefix = role.toCanonicalString();
        if (!keyWithPrefix.startsWith(CHILD_PREFIX)) {
            throw new IllegalArgumentException();
        }
        String key = keyWithPrefix.substring(CHILD_PREFIX.length());
        List<Object> values = record.getAll(key);
        IList_<? extends Object> children = DTValue.getValuesOfSupportedDataTypes(values);
        return children;
    }

    public IStructuredDataFactory createDataFactory() {
        return new IStructuredDataFactory(){
            private final IRecord record;
            {
                this.record = new Record(DTRecord.this.graphicsAndFilesHelper, DTRecord.this.locale);
            }

            public void setFlag(IKey role) {
                String keyWithPrefix = role.toCanonicalString();
                if (!keyWithPrefix.startsWith(FLAG_PREFIX)) {
                    throw new IllegalArgumentException();
                }
                String key = keyWithPrefix.substring(FLAG_PREFIX.length());
                this.record.set(key);
            }

            public IDataType getDataTypeOfPropertyOrChildren(IKey role) {
                return DTRecord.this.dataTypeValue;
            }

            public void addPropertyOrChild(IKey role, Object propertyOrChild) throws EXDataAssemblingFailed {
                String keyWithPrefix = role.toCanonicalString();
                if (keyWithPrefix.startsWith(PROPERTY_PREFIX)) {
                    String key = keyWithPrefix.substring(PROPERTY_PREFIX.length());
                    this.record.set(key, propertyOrChild);
                } else if (keyWithPrefix.startsWith(CHILD_PREFIX)) {
                    String key = keyWithPrefix.substring(CHILD_PREFIX.length());
                    this.record.add(key, propertyOrChild);
                } else {
                    throw new IllegalArgumentException();
                }
            }

            public boolean isErroneousFlagOrPropertyOrChildToIgnore(IKey role, EXDataLoadingException exception) {
                return false;
            }

            public Object createDataElement() throws EXDataCreationFailed {
                return this.record;
            }
        };
    }
}

