/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word.docbook2word;

import com.arcway.cockpit.docgen.writer.word.docbook2word.BreakType;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.frame.client.project.docgenerator.IReportJobParameter;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BreakTypeParameter
implements IReportJobParameter {
    public static final String BREAK_PREFIX = "PageBreakBefore.";
    private final Map<String, BreakType> role2BreakType = new HashMap<String, BreakType>();

    public static BreakType getBreakType(ProcessingContext processingContext, String role) {
        BreakType breakType = BreakType.noBreak;
        ReportJob reportJob = processingContext.getReportJob();
        List generatorSpecificParameters = reportJob.getGeneratorSpecificParameters();
        for (IReportJobParameter reportJobParameter : generatorSpecificParameters) {
            if (!(reportJobParameter instanceof BreakTypeParameter)) continue;
            BreakTypeParameter breakTypeParameter = (BreakTypeParameter)reportJobParameter;
            breakType = breakTypeParameter.getBreakTypeForRole(role);
        }
        return breakType;
    }

    public BreakTypeParameter(Map<String, String> customDocumentProperites) {
        for (Map.Entry<String, String> customDocumentPropertiesEntry : customDocumentProperites.entrySet()) {
            BreakType breakType;
            String propertyKey = customDocumentPropertiesEntry.getKey();
            String propertyValue = customDocumentPropertiesEntry.getValue();
            String role = BreakTypeParameter.getRole(propertyKey);
            if (role == null || (breakType = BreakTypeParameter.getBreakTypeForBreakTypeName(propertyValue)) == BreakType.noBreak) continue;
            this.role2BreakType.put(role, breakType);
        }
    }

    private static String getRole(String propertyKey) {
        String role = propertyKey.startsWith(BREAK_PREFIX) ? propertyKey.substring(BREAK_PREFIX.length()) : null;
        return role;
    }

    private static BreakType getBreakTypeForBreakTypeName(String breakTypeName) {
        BreakType breakType = breakTypeName.equals("PageBreak_None") ? BreakType.noBreak : (breakTypeName.equals("PageBreak_OddPage") ? BreakType.sectionBreakToOddPage : (breakTypeName.equals("PageBreak_EvenPage") ? BreakType.sectionBreakToEvenPage : (breakTypeName.equals("PageBreak_NextPage") ? BreakType.sectionBreakToNextPage : (breakTypeName.equals("SimplePageBreak_NextPage") ? BreakType.pageBreak : BreakType.noBreak))));
        return breakType;
    }

    public BreakType getBreakTypeForRole(String role) {
        BreakType breakType = this.role2BreakType.get(role);
        if (breakType == null) {
            breakType = BreakType.noBreak;
        }
        return breakType;
    }
}

