/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.word;

import au.com.swz.swttocom.swt.ResourceManager;
import com.arcway.cockpit.docgen.core.VelocityReportJob;
import com.arcway.cockpit.docgen.graphicsandfiles.PlanImageSizeHint;
import com.arcway.cockpit.docgen.writer.ReportGenerationCanceledException;
import com.arcway.cockpit.docgen.writer.docbook.AbstractDocBookDocumentationWriter;
import com.arcway.cockpit.docgen.writer.docbook.model.DocBookEOFactory;
import com.arcway.cockpit.docgen.writer.docbook.model.EOBook;
import com.arcway.cockpit.docgen.writer.word.ClientFunctionLicenseTypeReportsWord;
import com.arcway.cockpit.docgen.writer.word.Messages;
import com.arcway.cockpit.docgen.writer.word.docbook2word.DocumentWriter;
import com.arcway.cockpit.docgen.writer.word.docbook2word.ProcessingContext;
import com.arcway.cockpit.docgen.writer.word.preferences.WordReportsPreferences;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.eclipse.ole.word.Application;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.Documents;
import com.arcway.lib.eclipse.ole.word.Fields;
import com.arcway.lib.eclipse.ole.word.Frame;
import com.arcway.lib.eclipse.ole.word.Frames;
import com.arcway.lib.eclipse.ole.word.HeaderFooter;
import com.arcway.lib.eclipse.ole.word.HeadersFooters;
import com.arcway.lib.eclipse.ole.word.Options;
import com.arcway.lib.eclipse.ole.word.Paragraphs;
import com.arcway.lib.eclipse.ole.word.Range;
import com.arcway.lib.eclipse.ole.word.Section;
import com.arcway.lib.eclipse.ole.word.Sections;
import com.arcway.lib.eclipse.ole.word.Shape;
import com.arcway.lib.eclipse.ole.word.Shapes;
import com.arcway.lib.eclipse.ole.word.StoryRanges;
import com.arcway.lib.eclipse.ole.word.TextFrame;
import com.arcway.lib.eclipse.ole.word._Application;
import com.arcway.lib.eclipse.ole.word.util.MSWordVersionAndSettingsHelper;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EXEncoderException;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class WordDocumentationWriter
extends AbstractDocBookDocumentationWriter {
    private static final ILogger logger = Logger.getLogger(WordDocumentationWriter.class);
    public static final String FORMAT_ID = "WORD_DOCUMENT";
    private static final int IMAGE_RESOLUTION = 300;
    private static final int PREFERRED_IMAGE_SIZE = 160;

    public WordDocumentationWriter() {
        super(true, true);
    }

    public String getID() {
        return FORMAT_ID;
    }

    public String getDisplayName() {
        return Messages.getString("WordDocumentationWriter.word");
    }

    public String getDescription() {
        return Messages.getString("WordDocumentationWriter.description");
    }

    public String getRequiredOutputTemplateTypeID() {
        return FORMAT_ID;
    }

    public String getOutputFormat(IReportTemplate reportTemplate) {
        return FORMAT_ID;
    }

    public PlanImageSizeHint getPreferredImageSize() {
        return PlanImageSizeHint.getSizeHintInMM((Dimension)new Dimension(160.0, 160.0), (double)300.0);
    }

    public String getPreferredImageType() {
        return WordReportsPreferences.getImageFormat();
    }

    public String getSnippetForFileInRawReportFormat(String fileName, String displayName, String format, double width_mm, double height_mm) {
        try {
            return this.getDocBookSnippetForEmbeddedMediaObject(fileName, displayName, format, width_mm, height_mm, false);
        }
        catch (EXEncoderException e) {
            throw new RuntimeException("Unable to create DocBookSnippetForExternalFileLink.", e);
        }
    }

    protected void postProcessWithProgress(VelocityReportJob reportJob, IWorkbenchPage workbenchPage, IProgressMonitor progressMonitor) throws ReportGenerationException, ReportGenerationCanceledException {
        this.generateDocumentViaMSWord(0, null, reportJob, progressMonitor);
    }

    protected final void generateDocumentViaMSWord(int saveFormatID, String errorMessageIfSaveFormatUnavailable, VelocityReportJob reportJob, IProgressMonitor progressMonitor) throws ReportGenerationException, ReportGenerationCanceledException {
        if (progressMonitor != null) {
            progressMonitor.subTask(Messages.getString("WordDocumentationWriter.1"));
        }
        File targetFile = null;
        Document newWordDocument = null;
        File outputTemplateFile = null;
        Options wordOptions = null;
        boolean checkSpellingOption = false;
        boolean checkGrammarOption = false;
        boolean checkGrammarWithSpelling = false;
        Display display = null;
        _Application wordApplication = null;
        ResourceManager resourceManager = null;
        boolean otherDocsOpen = false;
        boolean skipWordGeneration = true;
        ProcessingContext processingContext = null;
        try {
            try {
                Documents docs;
                DocBookEOFactory factory = new DocBookEOFactory();
                EOBook docBook = factory.load(reportJob.getRawReportFile().getAbsolutePath());
                targetFile = new File(reportJob.getBaseReportJob().getReportFilename());
                outputTemplateFile = reportJob.getBaseReportJob().getOutputTemplateFile();
                if (Display.getCurrent() == null) {
                    display = new Display();
                }
                resourceManager = new ResourceManager();
                try {
                    wordApplication = Application.create((int)6, (ResourceManager)resourceManager, (boolean)true);
                }
                catch (SWTException aNEE) {
                    throw new ReportGenerationException(com.arcway.lib.eclipse.ole.word.util.Messages.getString((String)"WordFacade.WordNotInstalled_Title"), com.arcway.lib.eclipse.ole.word.util.Messages.getString((String)"WordFacade.WordNotInstalled_Message"), (Throwable)aNEE);
                }
                wordApplication.set_Visible(logger.isDebugEnabled(150));
                wordApplication.set_ScreenUpdating(logger.isDebugEnabled(150));
                if (logger.isDebugEnabled()) {
                    logger.debug("createDocument() - Microsoft Word application has been opened");
                }
                wordOptions = wordApplication.get_Options();
                checkSpellingOption = wordOptions.get_CheckSpellingAsYouType();
                checkGrammarOption = wordOptions.get_CheckGrammarAsYouType();
                checkGrammarWithSpelling = wordOptions.get_CheckGrammarWithSpelling();
                if (checkSpellingOption) {
                    wordOptions.set_CheckSpellingAsYouType(false);
                }
                if (checkGrammarOption) {
                    wordOptions.set_CheckGrammarAsYouType(false);
                }
                if (checkGrammarWithSpelling) {
                    wordOptions.set_CheckGrammarWithSpelling(false);
                }
                if ((docs = wordApplication.get_Documents()).get_Count() > 1) {
                    otherDocsOpen = true;
                    if (logger.isInfoEnabled()) {
                        logger.info("createDocument() - Other document are already opened");
                    }
                }
                if (WordDocumentationWriter.documentStillOpen(targetFile.getAbsolutePath(), docs)) {
                    Shell shell;
                    if (logger.isInfoEnabled()) {
                        logger.info("createDocument() - Destination document is still open");
                    }
                    skipWordGeneration = !MessageDialog.openConfirm((Shell)(shell = Display.getCurrent().getActiveShell()), (String)Messages.getString("WordDocumentationWriter.2"), (String)Messages.getString("WordDocumentationWriter.3"));
                } else {
                    skipWordGeneration = false;
                }
                if (!skipWordGeneration) {
                    if (!(outputTemplateFile.isFile() && outputTemplateFile.exists() && outputTemplateFile.canRead())) {
                        newWordDocument = docs.Add();
                        logger.warn("createDocument() - Template file doesn't exist or couldn't be read. MS Word standard template is used! : templateFile=" + outputTemplateFile, null);
                    } else {
                        newWordDocument = docs.Add((Object)outputTemplateFile.getAbsolutePath());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("createDocument() - New Document has been created");
                    }
                    processingContext = new ProcessingContext(reportJob.getBaseReportJob().getPresentationContext(), reportJob.getBaseReportJob().getReportLocale(), reportJob.getBaseReportJob());
                    Map<String, String> customDocumentProperites = DocumentWriter.getInstance().writeWordDocument(docBook, newWordDocument, reportJob.getGraphicsAndFilesStore(), progressMonitor, processingContext, reportJob.getBaseReportJob());
                    processingContext.performPostProcessingTasks();
                    newWordDocument.Repaginate();
                    String marginaliaFormat = customDocumentProperites.get("Marginalia.FormatName");
                    WordDocumentationWriter.updateAllFields(newWordDocument);
                    WordDocumentationWriter.updateMarginals(newWordDocument, marginaliaFormat);
                    reportJob.getBaseReportJob().registerReportResultFiles(Collections.singletonList(targetFile));
                    int saveFormatIDWordDocument = MSWordVersionAndSettingsHelper.getInstalledVersionOfMSWord() < 12 || MSWordVersionAndSettingsHelper.getDefaultSaveFormatIs2003() ? 0 : 16;
                    if (saveFormatID == 0) {
                        try {
                            newWordDocument.SaveAs((Object)targetFile.getAbsolutePath(), (Object)saveFormatIDWordDocument);
                        }
                        catch (SWTException swtE) {
                            logger.error("MS Word - SaveAs failed: " + targetFile.toString() + " -> " + targetFile.getAbsolutePath() + " / " + saveFormatID);
                            throw swtE;
                        }
                    }
                    try {
                        newWordDocument.SaveAs((Object)targetFile.getAbsolutePath(), (Object)saveFormatIDWordDocument);
                        newWordDocument.SaveAs((Object)targetFile.getAbsolutePath(), (Object)saveFormatID);
                    }
                    catch (SWTException swtE) {
                        logger.error("MS Word - SaveAs failed: " + targetFile.toString() + " -> " + targetFile.getAbsolutePath() + " / " + saveFormatID);
                        throw new ReportGenerationException(Messages.getString("WordDocumentationWriter.SaveFormatUnavailable_Title"), errorMessageIfSaveFormatUnavailable, (Throwable)swtE);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("createDocument() - Document has been saved : documentationFile=" + targetFile);
                    }
                }
                docs.dispose();
            }
            catch (ReportGenerationCanceledException rgcE) {
                throw rgcE;
            }
            catch (ReportGenerationException rgE) {
                throw rgE;
            }
            catch (Exception e) {
                throw new ReportGenerationException(Messages.getString("WordDocumentationWriter.WordGenerationFailed_Title"), Messages.getString("WordDocumentationWriter.WordGenerationFailed_Message"), (Throwable)e);
            }
        }
        finally {
            if (targetFile != null && newWordDocument != null && !skipWordGeneration) {
                try {
                    newWordDocument.Close((Object)0);
                    if (logger.isDebugEnabled()) {
                        logger.debug("createDocument() - Document has been closed : documentationFile=" + targetFile);
                    }
                }
                catch (Exception e) {
                    logger.error("createDocument() - Error closing document", (Throwable)e);
                }
            }
            if (progressMonitor != null) {
                progressMonitor.subTask(Messages.getString("WordDocumentationWriter.4"));
            }
            try {
                if (wordOptions != null && checkSpellingOption) {
                    wordOptions.set_CheckSpellingAsYouType(true);
                }
                if (wordOptions != null && checkGrammarOption) {
                    wordOptions.set_CheckGrammarAsYouType(true);
                }
                if (wordOptions != null && checkGrammarWithSpelling) {
                    wordOptions.set_CheckGrammarWithSpelling(true);
                }
            }
            catch (Exception e) {
                logger.error("createDocument() - Error restoring spelling and grammar check settings", (Throwable)e);
            }
            if (wordApplication != null && !otherDocsOpen) {
                try {
                    wordApplication.Quit();
                    if (logger.isDebugEnabled()) {
                        logger.debug("createDocument() - Application has been closed");
                    }
                }
                catch (Exception e) {
                    logger.error("createDocument() - Error quitting Word application", (Throwable)e);
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("createDocument() - Word is open because other documents were already opened before generation");
            }
            try {
                if (resourceManager != null) {
                    resourceManager.shutdown();
                }
            }
            catch (Exception e) {
                logger.error("createDocument() - Error uninitialising OLE", (Throwable)e);
            }
            try {
                if (display != null) {
                    display.dispose();
                }
            }
            catch (Exception e) {
                logger.error("createDocument() - Error disposing display", (Throwable)e);
            }
            try {
                if (outputTemplateFile != null) {
                    FileHelper.deleteExistingFileOrDirectory((File)outputTemplateFile);
                }
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.warn("Could not delete Word output template file.", (Throwable)e);
            }
            if (processingContext != null) {
                processingContext.performCleanUpTasks();
            }
        }
    }

    private static boolean documentStillOpen(String fileName, Documents docs) {
        boolean result = false;
        int docCount = docs.get_Count();
        int i = 0;
        while (i < docCount) {
            Document doc = docs.Item((Object)(i + 1));
            String docName = doc.get_Name();
            String docPath = doc.get_Path();
            String docFile = String.valueOf(docPath) + File.separator + docName;
            if (fileName.equals(docFile)) {
                result = true;
            }
            doc.dispose();
            ++i;
        }
        return result;
    }

    protected void postprocessingInterrupted(VelocityReportJob reportJob) {
        this.cleanUpReportFile(reportJob);
    }

    public IClientFunctionLicenseType getNeededLicenseType() {
        return ClientFunctionLicenseTypeReportsWord.getInstance();
    }

    private static void updateMarginals(Document activeDocument, String marginaliaFormat) {
        if (marginaliaFormat != null) {
            Frames frames = activeDocument.get_Frames();
            Enumeration frameElements = frames.elements();
            while (frameElements.hasMoreElements()) {
                Frame frame = (Frame)frameElements.nextElement();
                Range range = frame.get_Range();
                Variant style = range.get_Style();
                String styleString = style.getString();
                if (marginaliaFormat.equals(styleString)) {
                    Variant information = range.get_Information(3);
                    int infInt = information.getInt();
                    int grad = (infInt + 1) % 2;
                    Paragraphs paragraphs = range.get_Paragraphs();
                    paragraphs.set_Alignment(grad * 2);
                    paragraphs.dispose();
                    information.dispose();
                }
                style.dispose();
                range.dispose();
            }
            frames.dispose();
        }
    }

    private static void updateAllFields(Document activeDocument) {
        WordDocumentationWriter.updateFieldsInHeadersAndFooters(activeDocument);
        WordDocumentationWriter.updateFieldsInWholeDocumentBesideHeaderAndFooterTextfields(activeDocument);
    }

    private static void updateFieldsInWholeDocumentBesideHeaderAndFooterTextfields(Document oDoc) {
        StoryRanges oDocStoryRanges = oDoc.get_StoryRanges();
        Enumeration oDocStoryRangesElements = oDocStoryRanges.elements();
        while (oDocStoryRangesElements.hasMoreElements()) {
            Range rngDoc = (Range)oDocStoryRangesElements.nextElement();
            WordDocumentationWriter.updateFieldsInRangeAndNextStoryRanges(rngDoc);
        }
        oDocStoryRanges.dispose();
    }

    private static void updateFieldsInRangeAndNextStoryRanges(Range rngDoc) {
        WordDocumentationWriter.updateFields(rngDoc);
        Range nextStoryRange = rngDoc.get_NextStoryRange();
        rngDoc.dispose();
        while (nextStoryRange != null) {
            Range currentRngDoc = nextStoryRange;
            WordDocumentationWriter.updateFields(currentRngDoc);
            nextStoryRange = currentRngDoc.get_NextStoryRange();
            currentRngDoc.dispose();
        }
    }

    private static void updateFieldsInHeadersAndFooters(Document oDoc) {
        Sections oDocSections = oDoc.get_Sections();
        Enumeration oDocSectionsElements = oDocSections.elements();
        while (oDocSectionsElements.hasMoreElements()) {
            Section docSec = (Section)oDocSectionsElements.nextElement();
            HeadersFooters docSecHeaders = docSec.get_Headers();
            WordDocumentationWriter.updateFields(docSecHeaders);
            docSecHeaders.dispose();
            HeadersFooters docSecDooters = docSec.get_Footers();
            WordDocumentationWriter.updateFields(docSecDooters);
            docSecDooters.dispose();
        }
        oDocSections.dispose();
    }

    private static void updateFields(HeadersFooters docSecHeaders) {
        Enumeration docSecHeadersElements = docSecHeaders.elements();
        while (docSecHeadersElements.hasMoreElements()) {
            HeaderFooter oHF = (HeaderFooter)docSecHeadersElements.nextElement();
            Shapes oHFShapes = oHF.get_Shapes();
            WordDocumentationWriter.updateFields(oHFShapes);
            oHFShapes.dispose();
        }
    }

    private static void updateFields(Shapes oHFShapes) {
        Enumeration oHFShapesElements = oHFShapes.elements();
        while (oHFShapesElements.hasMoreElements()) {
            Shape shp = (Shape)oHFShapesElements.nextElement();
            TextFrame textFrame = shp.get_TextFrame();
            WordDocumentationWriter.updateFields(textFrame);
            textFrame.dispose();
        }
    }

    private static void updateFields(TextFrame textFrame) {
        int hasText = textFrame.get_HasText();
        if (hasText != 0) {
            Range textRange = textFrame.get_TextRange();
            WordDocumentationWriter.updateFields(textRange);
            textRange.dispose();
        }
    }

    private static void updateFields(Range range) {
        Fields fields = range.get_Fields();
        fields.Update();
        fields.dispose();
    }
}

