/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.wordML.dom;

import com.arcway.cockpit.docgen.writer.wordML.dom.CRLFLineBreaksXmlFileWriter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class WordMLReader
implements IRunnableWithProgress {
    private static final ILogger logger = Logger.getLogger(WordMLReader.class);
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private Document document;
    private final Locale projectLocale;
    private final DocumentBuilderFactory factory;
    private final File file;
    private boolean initialized = false;

    public WordMLReader(File file, Locale projectLocale) {
        this.projectLocale = projectLocale;
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setIgnoringComments(true);
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(false);
        this.file = file;
        try {
            this.readWordMLFile();
        }
        catch (ParserConfigurationException e) {
            logger.error("Could not read WordML template file.", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error("Could not read WordML template file.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Could not read WordML template file.", (Throwable)e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getWordRootElement() {
        return this.document.getDocumentElement();
    }

    public Locale getProjectLocale() {
        return this.projectLocale;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Import Word ML File", 2);
        try {
            try {
                this.readWordMLFile();
                monitor.worked(1);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void write() {
        try {
            Closeable serialisationOutputTarget;
            StreamResult result;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(this.document);
            if (CRLFLineBreaksXmlFileWriter.isCRLFPatchingNecessary()) {
                CRLFLineBreaksXmlFileWriter crlfLineBreaksXmlFileWriter = new CRLFLineBreaksXmlFileWriter(this.file, "UTF-8");
                result = new StreamResult(crlfLineBreaksXmlFileWriter);
                serialisationOutputTarget = crlfLineBreaksXmlFileWriter;
            } else {
                FileOutputStream stream = new FileOutputStream(this.file);
                result = new StreamResult(stream);
                serialisationOutputTarget = stream;
            }
            transformer.transform(source, result);
            if (serialisationOutputTarget instanceof Flushable) {
                try {
                    ((Flushable)((Object)serialisationOutputTarget)).flush();
                }
                catch (IOException ioE) {
                    logger.error("Problem while flush()'ing WordML output stream.", (Throwable)ioE);
                }
            }
            try {
                serialisationOutputTarget.close();
            }
            catch (IOException ioE) {
                logger.error("Problem while close()'ing WordML output stream.", (Throwable)ioE);
            }
        }
        catch (TransformerConfigurationException tce) {
            logger.error("Could not write WordML report: Transformer Factory error", (Throwable)tce);
        }
        catch (TransformerException te) {
            logger.error("Could not write WordML report: Transformation error", (Throwable)te);
        }
        catch (FileNotFoundException fnfE) {
            logger.error("Could not write WordML report: Transformation error: Could not open target file", (Throwable)fnfE);
        }
        catch (UnsupportedEncodingException uee) {
            logger.error("Could not write WordML report: Required character encoding not supported", (Throwable)uee);
        }
    }

    private void readWordMLFile() throws ParserConfigurationException, SAXException, IOException {
        if (this.initialized) {
            return;
        }
        this.document = null;
        DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
        this.document = documentBuilder.parse(this.file);
        this.initialized = true;
    }

    public Collection<Node> findElementChildren(Node parent) {
        TreeWalker walker = ((DocumentTraversal)((Object)this.document)).createTreeWalker(parent, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node n) {
                if (n.getNodeType() == 1) {
                    return 1;
                }
                return 2;
            }
        }, true);
        HashSet<Node> children = new HashSet<Node>();
        Node child = walker.firstChild();
        while (child != null) {
            children.add(child);
            child = walker.nextSibling();
        }
        return children;
    }

    public Collection<Node> findElementChildren(Node parent, final String name) {
        TreeWalker walker = ((DocumentTraversal)((Object)this.document)).createTreeWalker(parent, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node n) {
                if (n.getNodeType() == 1 && n.getNodeName().equals(name)) {
                    return 1;
                }
                return 2;
            }
        }, true);
        HashSet<Node> children = new HashSet<Node>();
        Node child = walker.firstChild();
        while (child != null) {
            children.add(child);
            child = walker.nextSibling();
        }
        return children;
    }

    public Element findFirstElement(Node parent, final String name) {
        TreeWalker walker = ((DocumentTraversal)((Object)this.document)).createTreeWalker(parent, 1, new NodeFilter(){

            @Override
            public short acceptNode(Node n) {
                if (n.getNodeType() == 1 && (name == null || n.getNodeName().equals(name))) {
                    return 1;
                }
                return 2;
            }
        }, true);
        return (Element)walker.firstChild();
    }

    public Collection<Node> getChildren(String[] elementNamePath, Element root) {
        Collection<Node> children = this.findElementChildren(root, elementNamePath[0]);
        if (elementNamePath.length == 1) {
            return children;
        }
        ArrayList<Node> leafChildren = new ArrayList<Node>();
        if (children.size() > 0) {
            String[] newPath = new String[elementNamePath.length - 1];
            System.arraycopy(elementNamePath, 1, newPath, 0, newPath.length);
            for (Node child : children) {
                leafChildren.addAll(this.getChildren(newPath, (Element)child));
            }
        }
        return leafChildren;
    }

    public static class ReaderNotInitializedException
    extends RuntimeException {
        public ReaderNotInitializedException() {
            super("The method readRifFile must be called prior all accessing methods");
        }
    }
}

