/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.docgen.writer.odt.docbook2odt;

import com.arcway.cockpit.docgen.writer.docbook.model.EOImageData;
import com.arcway.cockpit.docgen.writer.docbook.model.EOImageObject;
import com.arcway.cockpit.docgen.writer.odt.docbook2odt.DocBook2ODTGenerationContext;
import com.arcway.cockpit.docgen.writer.odt.dom.IImageObjectParent;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.graphics.image.ResolutionFetcher;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public class ImageObjectWriter {
    private static final ILogger logger = Logger.getLogger(ImageObjectWriter.class);
    private static ImageObjectWriter writer;

    public static ImageObjectWriter getInstance() {
        if (writer == null) {
            writer = new ImageObjectWriter();
        }
        return writer;
    }

    private ImageObjectWriter() {
    }

    public void write(EOImageObject imageObject, IImageObjectParent parent, DocBook2ODTGenerationContext context) throws JvmExternalResourceInteractionException {
        File imageFile;
        assert (imageObject != null) : "image object is null";
        EOImageData imageData = imageObject.getImageData();
        String imageFilename = imageData.getFileReference();
        double imageHeight = imageData.getDepth();
        double imageWidth = imageData.getWidth();
        String imageFormat = imageData.getFormat();
        if (imageFormat != null && (imageFile = context.getGraphicsAndFilesStore().getGraphicOrFileObjectFile(imageFilename)) != null) {
            String imageFileNameWithPath = imageFile.getAbsolutePath();
            float heightInPoints = 0.0f;
            float widthInPoints = 0.0f;
            if (imageHeight == 0.0 && imageWidth == 0.0) {
                ImageData data;
                ImageDescriptor desc = null;
                try {
                    desc = ImageDescriptor.createFromURL((URL)new File(imageFileNameWithPath).toURL());
                }
                catch (MalformedURLException e) {
                    logger.error((Throwable)e);
                }
                if (desc != null && (data = desc.getImageData()) != null && data.width > 0 && data.height > 0) {
                    double dpiY;
                    double dpiX;
                    try {
                        Point pixelsPerMeter = ResolutionFetcher.fetchResolutionInPixelsPerMeter((int)data.type, (File)imageFile);
                        dpiX = pixelsPerMeter.x * 0.0254;
                        dpiY = pixelsPerMeter.y * 0.0254;
                    }
                    catch (Exception e) {
                        dpiX = 96.0;
                        dpiY = 96.0;
                    }
                    float widthInPointsTemp = (float)(72.0 / dpiX * (double)data.width);
                    float heightInPointsTemp = (float)(72.0 / dpiY * (double)data.height);
                    float widthRatio = widthInPointsTemp / (float)context.getMaxRectWidthInPt();
                    float heightRatio = heightInPointsTemp / (float)context.getMaxRectHeightInPt();
                    if (widthRatio > heightRatio && widthRatio > 1.0f) {
                        float difference = widthInPointsTemp - (float)context.getMaxRectWidthInPt();
                        heightInPoints = heightInPointsTemp - heightInPointsTemp * (difference / widthInPointsTemp);
                        widthInPoints = context.getMaxRectWidthInPt();
                    } else if (heightRatio > widthRatio && heightRatio > 1.0f) {
                        float difference = heightInPointsTemp - (float)context.getMaxRectHeightInPt();
                        widthInPoints = widthInPointsTemp - widthInPointsTemp * (difference / heightInPointsTemp);
                        heightInPoints = context.getMaxRectHeightInPt();
                    } else {
                        widthInPoints = widthInPointsTemp;
                        heightInPoints = heightInPointsTemp;
                    }
                }
            }
            if (widthInPoints == 0.0f && heightInPoints == 0.0f) {
                heightInPoints = (float)(imageHeight / 25.4 * 72.0);
                widthInPoints = (float)(imageWidth / 25.4 * 72.0);
            }
            boolean duplicate = context.checkWhetherImageIsAlreadyEmbeddedAndAddItToListOfEmbeddedImagesIfNot(imageFileNameWithPath);
            String uniqueID = UUIDGenerator.getUniqueID().toUpperCase();
            String normalizedImageFileName = String.valueOf(uniqueID) + "." + FileHelper.getFileExtension((File)imageFile);
            String SubDirName_Pictures = "Pictures";
            if (!duplicate) {
                File odx__Pictures = new File(context.getOdxDirectory(), "Pictures");
                FileHelper.ensureDirectoryExistance((File)odx__Pictures);
                File odx__Pictures__filename = new File(odx__Pictures, normalizedImageFileName);
                DataCopyHelper.copyFile((File)imageFile, (File)odx__Pictures__filename);
            }
            int imageCounter = context.getNextFreeImageIndex();
            String odfImageFileName = "Pictures/" + normalizedImageFileName;
            context.getOdfManifestManager().registerNewFile(odfImageFileName);
            parent.addImageObject(imageFilename, imageFormat, widthInPoints, heightInPoints, duplicate, imageCounter, odfImageFileName);
            if (logger.isDebugEnabled()) {
                logger.debug("write() - Graphic file inserted  : filename=" + imageFileNameWithPath + ", height=" + heightInPoints + ", width=" + widthInPoints);
            }
        }
    }
}

