/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.cockpitlib.client.filter.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableListFilterItem
extends AbstractFilterItem {
    private static final String FILTER_INFO_SEPARATOR = ", ";
    private String name = null;
    private final List<String> texts = new ArrayList<String>();
    private final List<String> values = new ArrayList<String>();
    protected AbstractTextValuesFilter filter = null;
    private final List<TableItem> tableItems = new ArrayList<TableItem>();
    private List<String> passValues;

    public TableListFilterItem(String name, AbstractTextValuesFilter filter) {
        super(name, filter);
        this.name = name;
        this.filter = filter;
        this.passValues = new ArrayList<String>(filter.getPassValues());
    }

    public void addFilterValue(String text, String value) {
        this.texts.add(text);
        this.values.add(value);
    }

    public void setFilterValues(List<String> filterValues) {
        this.texts.clear();
        this.values.clear();
        for (String value : filterValues) {
            this.addFilterValue(value, value);
        }
    }

    public void clearFilterValues() {
        this.texts.clear();
        this.values.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFilterInfo() {
        if (this.isNoFilterValuesSet()) {
            return null;
        }
        StringBuffer filterInfo = new StringBuffer();
        for (TableItem item : this.tableItems) {
            if (!item.getChecked()) continue;
            if (filterInfo.length() > 0) {
                filterInfo.append(FILTER_INFO_SEPARATOR);
            }
            filterInfo.append(item.getText());
        }
        return filterInfo.toString();
    }

    @Override
    public void refresh() {
        for (TableItem item : this.tableItems) {
            this.updateValueCheckState(item);
        }
    }

    @Override
    public Control createContent(Composite parent) {
        Table table = new Table(parent, 2592);
        GridLayout tableLayout = new GridLayout(1, false);
        tableLayout.verticalSpacing = 2;
        tableLayout.horizontalSpacing = 2;
        table.setLayout((Layout)tableLayout);
        GridData tableGD = new GridData(1808);
        table.setLayoutData((Object)tableGD);
        int i = 0;
        while (i < this.texts.size()) {
            TableItem tableItem = new TableItem(table, 0);
            String text = this.texts.get(i);
            String value = this.values.get(i);
            if (text == null) {
                text = "";
            }
            tableItem.setText(text);
            tableItem.setData((Object)value);
            this.updateValueCheckState(tableItem);
            this.tableItems.add(tableItem);
            ++i;
        }
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableListFilterItem.this.updateFilter();
                TableListFilterItem.this.fireValueChanged();
            }
        });
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableListFilterItem.this.tableItems.clear();
            }
        });
        return table;
    }

    @Override
    public boolean isNoFilterValuesSet() {
        for (TableItem item : this.tableItems) {
            if (!item.getChecked()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllFilterValuesSet() {
        for (TableItem item : this.tableItems) {
            if (item.getChecked()) continue;
            return false;
        }
        return true;
    }

    protected void updateFilter() {
        boolean activateFilter = false;
        this.passValues.clear();
        for (TableItem item : this.tableItems) {
            if (!item.getChecked()) continue;
            String value = (String)item.getData();
            this.passValues.add(value);
            activateFilter = true;
        }
        this.setSelected(activateFilter);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    @Override
    public void doConfirmSelection() {
        this.filter.setPassValues(this.passValues);
    }

    @Override
    public void resetFilterValueToFilterState() {
        this.passValues.clear();
        this.passValues.addAll(this.filter.getPassValues());
    }

    public void updateValueCheckState(TableItem item) {
        String value = (String)item.getData();
        item.setChecked(this.passValues.contains(value));
    }

    protected List<String> getTexts() {
        return this.texts;
    }

    protected List<String> getValues() {
        return this.values;
    }

    @Override
    public void filterHasChanged() {
        this.passValues = this.filter.getPassValues();
    }
}

