/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTURL;
import com.arcway.lib.java.To;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.IARCWAYPlatformNameSpace;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.net.MalformedURLException;
import java.net.URL;

public class RDTURL
extends AbstractRepositoryDataType
implements IARCWAYPlatformNameSpace {
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("url"));
    private static RDTURL singleton;
    private final Comparator comparator = new Comparator();

    public static String urlToExternalForm(URL url) {
        String externalForm = url == null ? null : url.toExternalForm();
        return externalForm;
    }

    public static URL externalFormToURL(String externalForm) throws EXMalformedURL {
        URL url;
        try {
            url = externalForm == null ? null : new URL(externalForm);
        }
        catch (MalformedURLException e) {
            throw new EXMalformedURL(e);
        }
        return url;
    }

    public static RDTURL getInstance() {
        if (singleton == null) {
            singleton = new RDTURL();
        }
        return singleton;
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public Class<? extends IRepositoryDataTypeParameters> getRepositoryDataTypeParemtersType() {
        return Parameters.class;
    }

    public boolean isSetAlways(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isSetAlways();
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        return this.createData(null);
    }

    public IRepositoryData createData(URL value) {
        return new Data(value);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    public URL dataToValue(IRepositoryData data) {
        Data typedData = (Data)data;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            Data typedMinuent = (Data)minuent;
            Data typedSubtrahent = (Data)subtrahent;
            String stringMinuent = typedMinuent.getCanonicalString();
            String stringSubtrahent = typedSubtrahent.getCanonicalString();
            int sgn = stringMinuent.compareTo(stringSubtrahent);
            return sgn;
        }
    }

    private class Data
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final URL value;

        private Data(URL value) {
            this.value = value;
        }

        private void checkData(Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet {
            if (parameters.isSetAlways() && this.value == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
        }

        @Override
        protected String createCanonicalString() {
            String compareString = this.value == null ? null : this.value.toExternalForm();
            return StringUtil.createCanonicalStringConcatenation((String)compareString);
        }

        public URL getValue() {
            return this.value;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTURL.this;
        }

        public String toString() {
            String string = this.value == null ? To.makeNotNull((Object)this.value).toString() : this.value.toExternalForm();
            return "\"" + string + "\" (RDTURL)";
        }
    }

    private class DataType
    extends DTURL {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        protected URL convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            return RDTURL.this.dataToValue(repositoryData);
        }

        protected Object convertTypedDataToData(URL typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                repositoryData = RDTURL.this.createData(typedData);
                if (!this.withPortableLoading) {
                    RDTURL.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public static class EXMalformedURL
    extends EXValueInvalid {
        public EXMalformedURL(MalformedURLException e) {
            super(e);
        }
    }

    public static final class Parameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY = new Parameters(false);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS = new Parameters(true);
        private final boolean isSetAlways;

        public Parameters(boolean isSetAlways) {
            this.isSetAlways = isSetAlways;
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTURL.getInstance();
        }
    }
}

