/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.lib.high.registration.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.lib.DTLocale;
import com.arcway.lib.java.To;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataEqualComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataHasher;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataOrderComparator;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.lib.high.declaration.type.IARCWAYPlatformNameSpace;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeID;
import com.arcway.repository.lib.high.registration.data.RepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;
import java.util.Locale;

public class RDTLocale
extends AbstractRepositoryDataType
implements IARCWAYPlatformNameSpace {
    public static final RepositoryDataTypeID DATA_TYPE_ID = new RepositoryDataTypeID(ARCWAY_PLATFORM_NAMESPACE, new KeySegment("locale"));
    private static RDTLocale singleton;
    private final Comparator comparator = new Comparator();

    public static RDTLocale getInstance() {
        if (singleton == null) {
            singleton = new RDTLocale();
        }
        return singleton;
    }

    private RDTLocale() {
    }

    @Override
    public IRepositoryDataTypeID getRepositoryDataTypeID() {
        return DATA_TYPE_ID;
    }

    @Override
    public Class<? extends IRepositoryDataTypeParameters> getRepositoryDataTypeParemtersType() {
        return Parameters.class;
    }

    public boolean isSetAlways(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isSetAlways();
    }

    public boolean isWithCountryAndVariant(IRepositoryDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isWithCountryAndVariant();
    }

    @Override
    public IRepositoryData createDefaultValue(IRepositoryDataTypeParameters parameters) {
        return this.createData(null);
    }

    public IRepositoryData createData(Locale value) {
        return new Data(value);
    }

    @Override
    public void snapData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) {
    }

    @Override
    public void snapAndCheckData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    @Override
    public void checkData(IRepositoryData repositoryData, IRepositoryDataTypeParameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXValueInvalid {
        Data typedData = (Data)repositoryData;
        Parameters typedParameters = (Parameters)parameters;
        typedData.checkData(typedParameters);
    }

    public Locale dataToValue(IRepositoryData data) {
        Data typedData = (Data)data;
        assert (typedData.getDataType() == this);
        return typedData.getValue();
    }

    @Override
    public IRepositoryDataEqualComparator getEqualComparator() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataHasher getHasher() {
        return this.comparator;
    }

    @Override
    public IRepositoryDataOrderComparator getOrderComparator() {
        return this.comparator;
    }

    @Override
    public IDataType createDataTypeOfRepositoryData(IRepositoryDataTypeParameters dataTypeParameters, boolean withPortableLoading) {
        return new DataType(dataTypeParameters, withPortableLoading);
    }

    private class Comparator
    extends AbstractRepositoryDataType.AbstractHasher
    implements IRepositoryDataOrderComparator {
        private Comparator() {
        }

        @Override
        public int getSgn(IRepositoryData minuent, IRepositoryData subtrahent, IRepositoryDataTypeParameters parameters) {
            Data typedMinuent = (Data)minuent;
            Data typedSubtrahent = (Data)subtrahent;
            String stringMinuent = typedMinuent.getCanonicalString();
            String stringSubtrahent = typedSubtrahent.getCanonicalString();
            int sgn = stringMinuent.compareTo(stringSubtrahent);
            return sgn;
        }
    }

    private class Data
    extends AbstractRepositoryDataType.AbstractHashableData {
        private final Locale value;

        private Data(Locale value) {
            this.value = value;
        }

        private void checkData(Parameters parameters) throws AbstractRepositoryDataType.EXValueNotSet, EXLocaleValueInvalid {
            if (parameters.isSetAlways() && this.value == null) {
                throw new AbstractRepositoryDataType.EXValueNotSet();
            }
            if (this.value != null) {
                boolean isWithCountryOrVariant;
                boolean bl = isWithCountryOrVariant = !parameters.isWithCountryAndVariant() && (this.value.getCountry().length() > 0 || this.value.getVariant().length() > 0);
                if (isWithCountryOrVariant) {
                    throw new EXLocaleValueInvalid(isWithCountryOrVariant);
                }
            }
        }

        @Override
        protected String createCanonicalString() {
            String compareString = this.value == null ? null : StringUtil.createCanonicalStringConcatenation((String[])new String[]{this.value.getLanguage(), this.value.getCountry(), this.value.getVariant()});
            return StringUtil.createCanonicalStringConcatenation(compareString);
        }

        public Locale getValue() {
            return this.value;
        }

        @Override
        public IRepositoryDataType getDataType() {
            return RDTLocale.this;
        }

        public String toString() {
            return "\"" + To.makeNotNull((Object)this.value) + "\" (RDTLocale)";
        }
    }

    private class DataType
    extends DTLocale {
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final boolean withPortableLoading;

        private DataType(IRepositoryDataTypeParameters repositoryDataTypeParameters, boolean withPortableLoading) {
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.withPortableLoading = withPortableLoading;
        }

        protected Locale convertDataToTypedData(Object data) {
            IRepositoryData repositoryData = (IRepositoryData)data;
            return RDTLocale.this.dataToValue(repositoryData);
        }

        protected Object convertTypedDataToData(Locale typedData) throws EXDataCreationFailed {
            IRepositoryData repositoryData;
            try {
                repositoryData = RDTLocale.this.createData(typedData);
                if (!this.withPortableLoading) {
                    RDTLocale.this.snapAndCheckData(repositoryData, this.repositoryDataTypeParameters);
                }
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            catch (EXValueInvalid e) {
                throw new EXDataCreationFailed((Exception)e);
            }
            return repositoryData;
        }
    }

    public class EXLocaleValueInvalid
    extends EXValueInvalid {
        private final boolean isWithCountryOrVariant;

        public EXLocaleValueInvalid(boolean isWithCountryOrVariant) {
            this.isWithCountryOrVariant = isWithCountryOrVariant;
        }

        public boolean isWithCountryOrVariant() {
            return this.isWithCountryOrVariant;
        }

        @Override
        public String getMessage() {
            return new StringBuffer().append("Is Without Country Or Variant: ").append(this.isWithCountryOrVariant).toString();
        }
    }

    public static final class Parameters
    extends RepositoryDataTypeParameters {
        public static final boolean IS_SET__POTENTIALLY = false;
        public static final boolean IS_SET__ALWAYS = true;
        public static final boolean IS_WITHOUT_COUNTRY_AND_VARIANT = false;
        public static final boolean IS_WITH_COUNTRY_AND_VARIANT = true;
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__LANUGAGE = new Parameters(false, false);
        public static final Parameters PARAMETERS__IS_SET_POTENTIALLY__LANGUAGE_COUNTRY_VARIANT = new Parameters(false, true);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__LANUGAGE = new Parameters(true, false);
        public static final Parameters PARAMETERS__IS_SET_ALWAYS__LANGUAGE_COUNTRY_VARIANT = new Parameters(true, true);
        private final boolean isSetAlways;
        private final boolean isWithCountryAndVariant;

        public Parameters(boolean isSetAlways, boolean isWithCountryAndVariant) {
            this.isSetAlways = isSetAlways;
            this.isWithCountryAndVariant = isWithCountryAndVariant;
        }

        public boolean isSetAlways() {
            return this.isSetAlways;
        }

        public boolean isWithCountryAndVariant() {
            return this.isWithCountryAndVariant;
        }
    }

    public static class RepositoryDataTypeRegistration
    implements IRepositoryDataTypeRegistration {
        @Override
        public IRepositoryDataType getRepositoryDataType() {
            return RDTLocale.getInstance();
        }
    }
}

