/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.prefixidformat;

import com.arcway.lib.stringtools.StringUtil;

public class PrefixIDFormat {
    public static final int INHERITED_PREFIX = 0;
    public static final int STANDARD_PREFIX = 1;
    public static final int INDIVIDUAL_PREFIX = 2;
    private static final int MIN_MODE_CONST = 0;
    private static final int MAX_MODE_CONST = 2;
    private final int constructionMode;
    private final String prefixString;
    private final int numberOfDigits;
    private final String compareString;
    private final int hashCodeOfCompareString;

    public PrefixIDFormat(int constructionMode, String prefixString, int numberOfDigits) {
        if (constructionMode < 0 || constructionMode > 2) {
            throw new IllegalArgumentException();
        }
        if (constructionMode != 0) {
            if (numberOfDigits <= 0) {
                throw new IllegalArgumentException();
            }
            if (constructionMode == 2 && prefixString == null) {
                throw new IllegalArgumentException();
            }
        }
        this.constructionMode = constructionMode;
        this.prefixString = prefixString;
        this.numberOfDigits = numberOfDigits;
        this.compareString = StringUtil.createCanonicalStringConcatenation((String[])new String[]{Integer.toString(constructionMode), Integer.toString(numberOfDigits), prefixString});
        this.hashCodeOfCompareString = this.compareString.hashCode();
    }

    public static PrefixIDFormat createInheritedIDPrefix() {
        return new PrefixIDFormat(0, null, 3);
    }

    public static PrefixIDFormat createStandardIDPrefix(int numberOfDigits) {
        return new PrefixIDFormat(1, null, numberOfDigits);
    }

    public static PrefixIDFormat createIndividualPrefix(String prefixString, int numberOfDigits) {
        return new PrefixIDFormat(2, prefixString, numberOfDigits);
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public int getNumberOfDigits() {
        return this.numberOfDigits;
    }

    public String getPrefixString() {
        return this.prefixString != null ? this.prefixString : "";
    }

    public String getCompareString() {
        return this.compareString;
    }

    public int getHashCodeOfCompareString() {
        return this.hashCodeOfCompareString;
    }

    public String toString() {
        if (this.constructionMode == 0) {
            return "Inherited Mode";
        }
        if (this.constructionMode == 1) {
            return "Standard Mode (with " + this.numberOfDigits + " Digits)";
        }
        return "Individual Mode (with Prefix \"" + this.prefixString + "\" and " + this.numberOfDigits + " Digits)";
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrefixIDFormat) {
            PrefixIDFormat prefixIDFormat2 = (PrefixIDFormat)obj;
            if (this.getConstructionMode() == prefixIDFormat2.getConstructionMode()) {
                if (this.getConstructionMode() == 0) {
                    return true;
                }
                if (this.getNumberOfDigits() == prefixIDFormat2.getNumberOfDigits() && this.getPrefixString().equals(prefixIDFormat2.getPrefixString())) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.constructionMode;
        if (this.constructionMode != 0) {
            hash ^= this.numberOfDigits;
            if (this.constructionMode == 2) {
                hash ^= this.prefixString.hashCode();
            }
        }
        return hash;
    }
}

