/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.prototype;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.repository.implementation.prototype.Concurrency;
import com.arcway.repository.implementation.prototype.IOperationFactory;
import com.arcway.repository.implementation.prototype.IProcessor;
import com.arcway.repository.implementation.prototype.IProcessorOperation;
import com.arcway.repository.implementation.prototype.Sequence;
import com.arcway.repository.implementation.prototype.WeightedOperation;

public abstract class AbstractProcessor
implements IProcessor {
    private static final int WEIGHT_PER_ELEMENT = 1;

    @Override
    public final void executeSequence(Sequence weightedOperations) {
        this.executeSequence((IIterator_<WeightedOperation>)weightedOperations.getWeightedOperations().iterator(), weightedOperations.getTotalWeight());
    }

    @Override
    public final void executeConcurrency(Concurrency weightedOperations) {
        this.executeConcurrency((IIterator_<WeightedOperation>)weightedOperations.getWeightedOperations().iterator(), weightedOperations.getTotalWeight());
    }

    @Override
    public void executeForEachAsSequence(IList_<Object> objects, IOperationFactory operationFactory) {
        this.executeSequence(new ForEachIterator((ICollection_)objects, operationFactory), objects.size() * 1);
    }

    @Override
    public void executeForEachAsConcurrency(ICollection_<Object> objects, IOperationFactory operationFactory) {
        this.executeConcurrency(new ForEachIterator(objects, operationFactory), objects.size() * 1);
    }

    protected final void execute(IProcessorOperation operation) {
        operation.executeCalledByProcessor();
    }

    protected abstract void executeSequence(IIterator_<WeightedOperation> var1, int var2);

    protected abstract void executeConcurrency(IIterator_<WeightedOperation> var1, int var2);

    private class ForEachIterator
    implements IIterator_<WeightedOperation> {
        private final IIterator_<Object> objectIterator;
        private final IOperationFactory operationFactory;

        private ForEachIterator(ICollection_<Object> objects, IOperationFactory operationFactory) {
            this.objectIterator = objects.iterator();
            this.operationFactory = operationFactory;
        }

        public boolean hasNext() {
            return this.objectIterator.hasNext();
        }

        public WeightedOperation nextWeightedOperation() {
            Object objectToProcess = this.objectIterator.next();
            IProcessorOperation operation = this.operationFactory.getOperationFor(objectToProcess);
            WeightedOperation weightedOperation = new WeightedOperation(operation, 1);
            return weightedOperation;
        }

        public Object nextObject() {
            return this.nextWeightedOperation();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public WeightedOperation next() {
            return this.nextWeightedOperation();
        }
    }
}

