/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.implementation.globalrepository;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.repository.implementation.implementation.RepositoryImplementationManager;
import com.arcway.repository.implementation.implementation.globalrepository.RepositoryGlobalRepositoryWorkstationHandler;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotCreateImplementation;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadModule;
import com.arcway.repository.interFace.chassis.exceptions.EXCouldNotLoadModuleManager;
import com.arcway.repository.interFace.chassis.exceptions.EXUnknownImplementationType;
import com.arcway.repository.interFace.implementation.AbstractRepositoryImplementationDescription;
import com.arcway.repository.interFace.implementation.datalayer.IRepositoryDataLayerROModuleManager;
import com.arcway.repository.interFace.implementation.datalayer.RepositoryDataLayerRODescription;
import com.arcway.repository.interFace.implementation.globalrepository.IRepositoryGlobalRepositoryRO;
import com.arcway.repository.interFace.implementation.transmission.IRepositoryGlobalRepositoryTransmitter;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerListener;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;

public class RepositoryGlobalRepository
implements IRepositoryGlobalRepositoryRO {
    private static final ListenerKey LISTENER_KEY = new ListenerKey();
    private final IRepositoryTypeManagerListener typeManagerListener = new IRepositoryTypeManagerListener(){

        public void dispose() {
            RepositoryGlobalRepository.this.shutdown();
        }
    };
    private final RepositoryTypeManager typeManager;
    private final RepositoryImplementationManager globalDataLayerImplementationManager;
    private final ISetRW_<RepositoryGlobalRepositoryWorkstationHandler> workstationHandlers = new HashSet_(IHasher_.EQUALS_HASHER);

    public RepositoryGlobalRepository(RepositoryTypeManager typeManager, RepositoryDataLayerRODescription globalDataLayerDescription) throws EXCouldNotCreateImplementation {
        Assert.checkArgumentBeeingNotNull((Object)typeManager);
        Assert.checkArgumentBeeingNotNull((Object)globalDataLayerDescription);
        this.typeManager = typeManager;
        try {
            this.globalDataLayerImplementationManager = new RepositoryImplementationManager((IRepositoryTypeManagerRO)typeManager, (AbstractRepositoryImplementationDescription)globalDataLayerDescription);
            Assert.checkObjectArgumentToBeInstanceOf((Object)this.globalDataLayerImplementationManager.getModuleManager(), IRepositoryDataLayerROModuleManager.class);
        }
        catch (EXCouldNotLoadModuleManager e) {
            throw new EXCouldNotCreateImplementation((AbstractRepositoryImplementationDescription)globalDataLayerDescription, (Throwable)e);
        }
        catch (EXCouldNotLoadModule e) {
            throw new EXCouldNotCreateImplementation((AbstractRepositoryImplementationDescription)globalDataLayerDescription, (Throwable)e);
        }
        catch (EXUnknownImplementationType e) {
            throw new EXCouldNotCreateImplementation((AbstractRepositoryImplementationDescription)globalDataLayerDescription, (Throwable)e);
        }
        typeManager.getListenerManager().addListener(LISTENER_KEY, (IDisposeListener)this.typeManagerListener);
    }

    public IRepositoryDataLayerROModuleManager getGlobalDataLayerROModuleManager() {
        return (IRepositoryDataLayerROModuleManager)this.globalDataLayerImplementationManager.getModuleManager();
    }

    public void setupRepositoryWorkstationRO(IRepositoryGlobalRepositoryTransmitter globalRepositoryTransmitter) {
        new RepositoryGlobalRepositoryWorkstationHandler(this, globalRepositoryTransmitter);
    }

    public void registerWorkstationHandler(RepositoryGlobalRepositoryWorkstationHandler workstationHandler) {
        Assert.checkArgumentBeeingNotNull((Object)workstationHandler);
        RepositoryGlobalRepositoryWorkstationHandler registeredWorkstationHandler = (RepositoryGlobalRepositoryWorkstationHandler)this.workstationHandlers.replace((Object)workstationHandler);
        Assert.checkArgument((registeredWorkstationHandler == null ? 1 : 0) != 0);
    }

    public void unregisterWorkstationHandler(RepositoryGlobalRepositoryWorkstationHandler workstationHandler) {
        Assert.checkArgumentBeeingNotNull((Object)workstationHandler);
        RepositoryGlobalRepositoryWorkstationHandler unregisteredWorkstationHandler = (RepositoryGlobalRepositoryWorkstationHandler)this.workstationHandlers.remove((Object)workstationHandler);
        Assert.checkArgument((unregisteredWorkstationHandler == workstationHandler ? 1 : 0) != 0);
    }

    public void checkWorkstationHandlerToBeSetup(RepositoryGlobalRepositoryWorkstationHandler workstationHandler) {
        Assert.checkArgumentBeeingNotNull((Object)workstationHandler);
        RepositoryGlobalRepositoryWorkstationHandler registeredWorkstationHandler = (RepositoryGlobalRepositoryWorkstationHandler)this.workstationHandlers.get((Object)workstationHandler);
        Assert.checkState((registeredWorkstationHandler == workstationHandler ? 1 : 0) != 0);
    }

    public void shutdown() {
        for (RepositoryGlobalRepositoryWorkstationHandler currentWorkstationHandler : this.workstationHandlers) {
            currentWorkstationHandler.shutdownWorkstation();
        }
        this.typeManager.getListenerManager().removeListener(LISTENER_KEY);
        this.globalDataLayerImplementationManager.shutdown();
    }
}

