/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planview.view.PVPlanViewPart;

public class PVFrameViewPart
extends PVPlanViewPart {
    private Rectangle frameRectangle;
    private static final Color BLACK = new Color();
    private LineStyle lineStyle = LineStyle.SOLID;
    private double lineWidth = 1.0;
    private Color lineColor = BLACK;

    public PVFrameViewPart(Rectangle rectangle, double lineWidth) {
        this.frameRectangle = rectangle;
        this.lineWidth = lineWidth;
    }

    @Override
    public void drawFigure(Device device) {
        Points points = new Points();
        points.add(this.frameRectangle.upperLeft);
        points.add(new Point(this.frameRectangle.lowerRight.x, this.frameRectangle.upperLeft.y));
        points.add(this.frameRectangle.lowerRight);
        points.add(new Point(this.frameRectangle.upperLeft.x, this.frameRectangle.lowerRight.y));
        Corners corners = new Corners(points, 0.0);
        device.polygon(corners, this.lineWidth, this.lineColor, this.lineStyle);
    }

    @Override
    public Rectangle getOuterBoundsWithoutChildren() {
        Rectangle bounds = this.frameRectangle;
        double l = this.lineWidth / 2.0;
        bounds = bounds.expand(l, l, l, l);
        return bounds;
    }

    @Override
    public boolean isInside(Point p, double tolerance) {
        Rectangle tolerantBounds = this.getOuterBoundsWithoutChildren().expand(tolerance, tolerance, tolerance, tolerance);
        return tolerantBounds.isInside(p);
    }

    public void setRectangle(Rectangle rectangle) {
        assert (rectangle != null) : "Rectangle must not be null";
        this.frameRectangle = rectangle;
    }

    public Rectangle getFrameRectangle() {
        return this.frameRectangle;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setFrameRectangle(Rectangle rectangle) {
        assert (rectangle != null) : "rectangle must not be null";
        this.frameRectangle = rectangle;
    }

    public void setLineColor(Color color) {
        assert (color != null) : "color must not be null";
        this.lineColor = color;
    }

    public void setLineStyle(LineStyle style) {
        assert (style != null) : "style must not be null";
        this.lineStyle = style;
    }

    public void setLineWidth(double lineWidth) {
        assert (lineWidth < 0.0) : "lineWidth must be >= 0";
        this.lineWidth = lineWidth;
    }
}

