/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.transactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TAMovePoints
extends Transaction {
    private final Map<IPMPointRW, GeoVector> pointMovements;

    public TAMovePoints(IPMPlanRW plan, Map<IPMPointRW, GeoVector> pointMovements, ActionParameters actionParameters) {
        super(plan, actionParameters);
        assert (plan != null) : "plan object is null";
        assert (pointMovements != null) : "pointMovements object is null";
        this.pointMovements = pointMovements;
    }

    @Override
    public ActionIterator getActionIterator() {
        PredeterminedActionIterator moveActionIterator = new PredeterminedActionIterator(this.pointMovements.size());
        Set<Map.Entry<IPMPointRW, GeoVector>> pointMovementsSet = this.pointMovements.entrySet();
        for (Map.Entry<IPMPointRW, GeoVector> entry : pointMovementsSet) {
            ACMovePoint movePointAction = ActionFactory.createACMovePoint(this.getActionContext(), entry.getKey(), entry.getValue(), false);
            moveActionIterator.addAction(movePointAction);
        }
        return moveActionIterator;
    }

    @Override
    protected Collection<? extends IPMPlanModelObjectRW> getPrimarilyChangedPlanModelObjects() {
        HashSet<IPMPointListRW> movedPointLists = new HashSet<IPMPointListRW>(this.pointMovements.size() * 2);
        for (IPMPointRW pointToMove : this.pointMovements.keySet()) {
            movedPointLists.add(pointToMove.getPointListRW());
        }
        return movedPointLists;
    }

    public String toString() {
        return "TAMovePoints ()";
    }
}

