/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.reactions;

import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACRemove1Point;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.DelayingActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.ArrayList;
import java.util.List;

public class RACongruentPointRemover
implements IRAChangeGeometryFigure {
    @Override
    public ActionIterator createReactionsFigureGeometryChanged(final IPMFigureRW figure, List<PositionAndPoint> oldGeometry, final ActionContext actionContext) {
        return new DelayingActionIterator(){

            @Override
            protected ActionIterator createActionIterator() {
                return RACongruentPointRemover.this.createReactionsFigureGeometryChangedDelayed(figure, actionContext);
            }
        };
    }

    private ActionIterator createReactionsFigureGeometryChangedDelayed(IPMFigureRW figure, ActionContext actionContext) {
        ActionIterator reactionIterator;
        boolean isBendable = figure.getPlanElementRW().isBendableRW(figure);
        if (isBendable && actionContext.getActionParameters().getRoutingContext().isBendingActive()) {
            IPMPointListRW pointList = figure.getPointListRW();
            boolean isPlaneFigure = pointList.getPointCount() == pointList.getLineCount();
            int currentNumberOfPoints = pointList.getPointCount();
            int minimumNumberOfPoints = isPlaneFigure ? 3 : 2;
            ArrayList<IAnchoringDestinationContributor> remainingPointsAndLines = new ArrayList<IAnchoringDestinationContributor>();
            int i = 0;
            while (i < pointList.getPointCount()) {
                boolean isLastPoint;
                remainingPointsAndLines.add(pointList.getPointRW(i));
                boolean bl = isLastPoint = i == pointList.getPointCount() - 1;
                if (!isLastPoint || isPlaneFigure) {
                    remainingPointsAndLines.add(pointList.getLineRW(i));
                }
                ++i;
            }
            int indexOfLastPointToHandle = isPlaneFigure ? remainingPointsAndLines.size() - 2 : remainingPointsAndLines.size() - 3;
            PredeterminedActionIterator removingReactionIterator = new PredeterminedActionIterator();
            int currentPointIndex = 0;
            while (currentPointIndex <= indexOfLastPointToHandle) {
                int removablePoints = currentNumberOfPoints - minimumNumberOfPoints;
                IPMPointRW point1 = (IPMPointRW)remainingPointsAndLines.get(currentPointIndex);
                IPMLineRW line1To2 = (IPMLineRW)remainingPointsAndLines.get(currentPointIndex + 1);
                IPMPointRW point2 = (IPMPointRW)remainingPointsAndLines.get((currentPointIndex + 2) % remainingPointsAndLines.size());
                boolean pointsAreCongruent = point1.getPosition().equalsPoint(point2.getPosition());
                boolean point1IsStartPoint = !isPlaneFigure && currentPointIndex == 0;
                boolean point2IsEndPoint = !isPlaneFigure && currentPointIndex + 2 == remainingPointsAndLines.size() - 1;
                IPMLineRW line0To1 = point1IsStartPoint ? null : (IPMLineRW)remainingPointsAndLines.get((currentPointIndex + remainingPointsAndLines.size() - 1) % remainingPointsAndLines.size());
                IPMLineRW line2To3 = point2IsEndPoint ? null : (IPMLineRW)remainingPointsAndLines.get((currentPointIndex + 3) % remainingPointsAndLines.size());
                if (pointsAreCongruent) {
                    boolean prevAndSuccLinesAreForcedWithEqualLineForce = line0To1 != null && line2To3 != null ? line0To1.getForce() != 1 && line0To1.getForce() == line2To3.getForce() : false;
                    boolean deleteTwoPoints = prevAndSuccLinesAreForcedWithEqualLineForce;
                    if (deleteTwoPoints && removablePoints >= 2) {
                        removingReactionIterator.addAction(new ACRemove1Point(actionContext, point1, line1To2));
                        removingReactionIterator.addAction(new ACRemove1Point(actionContext, point2, line2To3));
                        remainingPointsAndLines.remove(point1);
                        remainingPointsAndLines.remove(line1To2);
                        remainingPointsAndLines.remove(point2);
                        remainingPointsAndLines.remove(line2To3);
                        currentNumberOfPoints -= 2;
                        indexOfLastPointToHandle -= 4;
                        if (currentPointIndex == 0) continue;
                        currentPointIndex -= 2;
                        continue;
                    }
                    if (!deleteTwoPoints && removablePoints >= 1) {
                        if (point1IsStartPoint) {
                            removingReactionIterator.addAction(new ACRemove1Point(actionContext, point2, line1To2));
                            remainingPointsAndLines.remove(line1To2);
                            remainingPointsAndLines.remove(point2);
                        } else {
                            removingReactionIterator.addAction(new ACRemove1Point(actionContext, point1, line1To2));
                            remainingPointsAndLines.remove(currentPointIndex);
                            remainingPointsAndLines.remove(currentPointIndex);
                            if (currentPointIndex != 0) {
                                currentPointIndex -= 2;
                            }
                        }
                        --currentNumberOfPoints;
                        indexOfLastPointToHandle -= 2;
                        continue;
                    }
                    currentPointIndex += 2;
                    continue;
                }
                currentPointIndex += 2;
            }
            reactionIterator = removingReactionIterator;
        } else {
            reactionIterator = ActionIterator.EMPTY_ACTION_ITERATOR;
        }
        return reactionIterator;
    }
}

