/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.planagent.planmodel.persistent.EOLine;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.EOPoint;
import com.arcway.planagent.planmodel.persistent.IEOFactory;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class EOPointList
extends EOPlanModelObject {
    public static final String XML_NAME = "pointlist";
    private final ArrayList<EOPoint> points = new ArrayList();
    private final ArrayList<EOLine> lines = new ArrayList();

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(XML_NAME, new Factory());
    }

    public EOPointList() {
        super(XML_NAME);
    }

    public EOPointList(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected EOPlanModelObject getFlatCopy(EOPlanModelObject parent) {
        EOPointList newObject = new EOPointList();
        newObject.setAttributesFromEO(this);
        return newObject;
    }

    protected final void setAttributesFromEO(EOPointList sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO(sourceEO);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        return super.setAttributeFromXML(name, value);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOPoint) {
            this.points.add((EOPoint)newChild);
            this.childHooked((EOPoint)newChild);
        } else if (newChild instanceof EOLine) {
            this.lines.add((EOLine)newChild);
            this.childHooked((EOLine)newChild);
        } else {
            success = super.addChildFromXML(newChild);
        }
        return success;
    }

    @Override
    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        super.getAllChildren(allChildrenReceiver);
        int pointCount = this.points.size();
        int lineCount = this.lines.size();
        int count = Math.max(pointCount, lineCount);
        int i = 0;
        while (i < count) {
            if (i < pointCount) {
                allChildrenReceiver.add(this.points.get(i));
            }
            if (i < lineCount) {
                allChildrenReceiver.add(this.lines.get(i));
            }
            ++i;
        }
    }

    public int getPointCount() {
        return this.points.size();
    }

    public EOPoint getPoint(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.points.size()) : "i >= getPointCount()";
        return this.points.get(i);
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public EOLine getLine(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.lines.size()) : "i >= getLineCount()";
        return this.lines.get(i);
    }

    public void addPoint(EOPoint point, int i) {
        assert (point != null) : "point is null";
        assert (i >= 0) : "i<0";
        assert (i <= this.points.size()) : "i > getPointCount()";
        this.points.add(i, point);
        this.childHooked(point);
    }

    public void addPoint(EOPoint point) {
        assert (point != null) : "point is null";
        this.points.add(point);
        this.childHooked(point);
    }

    public void removePoint(EOPoint point) {
        assert (point != null) : "point is null";
        assert (this.points.indexOf((Object)point) != -1) : "point is not related to this point list";
        this.points.remove((Object)point);
        this.childUnhooked(point);
    }

    public void removePoint(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.points.size()) : "i >= getPointCount()";
        EOPoint point = this.points.remove(i);
        this.childUnhooked(point);
    }

    public void addLine(EOLine line, int i) {
        assert (line != null) : "line is null";
        assert (i >= 0) : "i<0";
        assert (i <= this.lines.size()) : "i > getLineCount()";
        this.lines.add(i, line);
        this.childHooked(line);
    }

    public void addLine(EOLine line) {
        assert (line != null) : "line is null";
        this.lines.add(line);
        this.childHooked(line);
    }

    public void removeLine(EOLine line) {
        assert (line != null) : "line is null";
        assert (this.lines.indexOf((Object)line) != -1) : "line is not related to this point list";
        this.lines.remove((Object)line);
        this.childUnhooked(line);
    }

    public void removeLine(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.lines.size()) : "i >= getLineCount()";
        EOLine line = this.lines.remove(i);
        this.childUnhooked(line);
    }

    static class Factory
    implements IEOFactory {
        Factory() {
        }

        @Override
        public EncodableObjectBase create(XMLContext xmlContext) {
            return new EOPointList(xmlContext);
        }
    }
}

