/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPoint;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.IEOFactory;
import com.arcway.planagent.planmodel.persistent.PlanModelObjectFactoryDispatcher;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.List;

public final class EOPoint
extends EOPlanModelObject {
    public static final double DEFAULT_CORNERRADIUS = 0.0;
    public static final boolean DEFAULT_CORNERRADIUSINFINITY = false;
    public static final boolean DEFAULT_CORNERRADIUSINHERITED = true;
    public static final String XML_NAME = "point";
    private static final String ATTR_TAG_X = "x";
    private static final String ATTR_TAG_Y = "y";
    private static final String ATTR_TAG_CORNERRADIUS = "cornerradius";
    private static final String ATTR_VALUE_CORNERRADIUSINHERITED = "inherited";
    private static final String ATTR_VALUE_CORNERRADIUSINFINITY = "infinity";
    private double x;
    private double y;
    private double cornerRadius = 0.0;
    private boolean cornerRadiusInfinity = false;
    private boolean cornerRadiusInherited = true;
    private EOAnchoringPoint anchoring = null;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(XML_NAME, new Factory());
    }

    public EOPoint() {
        super(XML_NAME);
    }

    public EOPoint(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected EOPlanModelObject getFlatCopy(EOPlanModelObject parent) {
        EOPoint newObject = new EOPoint();
        newObject.setAttributesFromEO(this);
        return newObject;
    }

    protected final void setAttributesFromEO(EOPoint sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO(sourceEO);
        this.x = sourceEO.x;
        this.y = sourceEO.y;
        this.cornerRadius = sourceEO.cornerRadius;
        this.cornerRadiusInfinity = sourceEO.cornerRadiusInfinity;
        this.cornerRadiusInherited = sourceEO.cornerRadiusInherited;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        this.appendAttrToXML(writeContext, ATTR_TAG_X, this.x);
        this.appendAttrToXML(writeContext, ATTR_TAG_Y, this.y);
        if (!this.cornerRadiusInherited) {
            if (this.cornerRadiusInfinity) {
                this.appendAttrToXML(writeContext, ATTR_TAG_CORNERRADIUS, ATTR_VALUE_CORNERRADIUSINFINITY);
            } else {
                this.appendAttrToXML(writeContext, ATTR_TAG_CORNERRADIUS, this.cornerRadius);
            }
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_X)) {
            this.x = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_Y)) {
            this.y = this.toDouble(value);
        } else if (name.equals(ATTR_TAG_CORNERRADIUS)) {
            if (ATTR_VALUE_CORNERRADIUSINHERITED.equals(value)) {
                this.cornerRadiusInherited = true;
            } else if (ATTR_VALUE_CORNERRADIUSINFINITY.equals(value)) {
                this.cornerRadiusInherited = false;
                this.cornerRadiusInfinity = true;
            } else {
                this.cornerRadiusInherited = false;
                this.cornerRadiusInfinity = false;
                this.cornerRadius = this.toDouble(value);
            }
        } else {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    @Override
    protected void getAllChildren(List<EOPlanModelObject> allChildrenReceiver) {
        super.getAllChildren(allChildrenReceiver);
        if (this.anchoring != null) {
            allChildrenReceiver.add(this.anchoring);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = true;
        if (newChild instanceof EOAnchoringPoint) {
            this.anchoring = (EOAnchoringPoint)newChild;
            this.childHooked(this.anchoring);
        } else {
            success = super.addChildFromXML(newChild);
        }
        return success;
    }

    public Point getPosition() {
        Object point = this.cornerRadiusInherited ? new Point(this.x, this.y) : (this.cornerRadiusInfinity ? new Corner(this.x, this.y) : new Corner(this.x, this.y, this.cornerRadius));
        return point;
    }

    public boolean getCornerRadiusInherited() {
        return this.cornerRadiusInherited;
    }

    public boolean getCornerRadiusInfinity() {
        return this.cornerRadiusInfinity;
    }

    public double getCornerRadius() {
        return this.cornerRadius;
    }

    public EOAnchoringPoint getAnchoring() {
        return this.anchoring;
    }

    public void setPosition(Point position) {
        assert (position != null) : "position is null";
        this.x = position.x;
        this.y = position.y;
    }

    public void setCornerRadiusInherited() {
        this.cornerRadiusInherited = true;
    }

    public void setCornerRadiusInfinity() {
        this.cornerRadiusInherited = false;
        this.cornerRadiusInfinity = true;
    }

    public void setCornerRadius(double cornerRadius) {
        assert (cornerRadius >= -1.0E-10);
        this.cornerRadiusInherited = false;
        this.cornerRadiusInfinity = false;
        this.cornerRadius = cornerRadius;
    }

    public void setAnchoring(EOAnchoringPoint anchoring) {
        if (this.anchoring != null) {
            this.childUnhooked(this.anchoring);
        }
        this.anchoring = anchoring;
        if (this.anchoring != null) {
            this.childHooked(this.anchoring);
        }
    }

    static class Factory
    implements IEOFactory {
        Factory() {
        }

        @Override
        public EncodableObjectBase create(XMLContext xmlContext) {
            return new EOPoint(xmlContext);
        }
    }
}

