/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.FMCAPlanModelPlugin;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.IPlanFactory;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import de.plans.lib.eclipse.PlugInClassExtensionFactory;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import org.eclipse.core.runtime.CoreException;

public class PlanFactoryDispatcher {
    private static final String PROPERTY_NAME_FACTORY_CLASS = "factory-class";
    private static final String PROPERTY_NAME_PLAN_TYPE = "id";
    private static final String MODULE_EXTENSION_POINT_ID = "plantype";
    private static PlanFactoryDispatcher singletonInstance;
    private final PlugInClassExtensionFactory factoryFactory = new PlugInClassExtensionFactory(true, FMCAPlanModelPlugin.getPluginID(), "plantype", "id", "factory-class");

    private PlanFactoryDispatcher() throws PlugInClassExtensionFactoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlanFactoryDispatcher getInstance() throws PlugInClassExtensionFactoryException {
        Class<PlanFactoryDispatcher> clazz = PlanFactoryDispatcher.class;
        synchronized (PlanFactoryDispatcher.class) {
            if (singletonInstance == null) {
                singletonInstance = new PlanFactoryDispatcher();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    protected PMPlan create(PlanModelMgr planModelMgr, String type) throws EXPlanModelObjectFactoryException, CoreException, PlugInClassExtensionFactoryException {
        assert (planModelMgr != null) : "PlanModelMgr must not be null";
        assert (type != null) : "Plan Type is null";
        try {
            IPlanFactory factory = (IPlanFactory)this.factoryFactory.create(type);
            return factory.create(planModelMgr);
        }
        catch (ClassCastException e) {
            throw new EXPlanModelObjectFactoryException("Factory for type " + type + " has unexpected type", e);
        }
    }

    protected PMPlan create(PlanModelMgr planModelMgr, EOPlan eo) throws EXPlanModelObjectFactoryException, CoreException, PlugInClassExtensionFactoryException {
        assert (planModelMgr != null) : "PlanModelMgr must not be null";
        assert (eo != null) : "EOGraphicalSupplement must not be null";
        String type = eo.getType();
        assert (type != null) : "Plan Type is null";
        IPlanFactory factory = (IPlanFactory)this.factoryFactory.create(type);
        return factory.create(planModelMgr, eo);
    }
}

