/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectCrosslinkException;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectLinker;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPoint;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPoint;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPointToLine;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.List;

public class PMAnchoringPointToLine
extends PMAnchoringPoint
implements IPMAnchoringPointToLineRO,
IPMAnchoringPointToLineRW {
    private PMLine targetLine = null;
    private final EOAnchoringPointToLine persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOAnchoringPointToLine.class, new AnchoringPointToLineFactory());
    }

    protected PMAnchoringPointToLine(PlanModelMgr planModelMgr, EOAnchoringPointToLine eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOAnchoringPointToLine getPersistentAnchoringPointToLine() {
        return this.persistent;
    }

    @Override
    protected EOAnchoringPoint getPersistentAnchoringPoint() {
        return this.getPersistentAnchoringPointToLine();
    }

    protected PMAnchoringPointToLine(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOAnchoringPointToLine();
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) throws EXPlanModelObjectCrosslinkException {
        PMLine line = (PMLine)LoadPlanModelObjectLinker.getObjectByUIDAndCheckType(objectList, this.getPersistentAnchoringPointToLine().getLineUid(), PMLine.class, "line");
        line.linkCrossLinkToPointToLineAnchoring(this);
        this.targetLine = line;
    }

    @Override
    protected List<PMLine> getCrosslinked() {
        List crosslinked = super.getCrosslinked();
        crosslinked.add(this.targetLine);
        return crosslinked;
    }

    public PMLine getTargetLine() {
        return this.targetLine;
    }

    @Override
    public IPMLineRO getTargetLineRO() {
        return this.getTargetLine();
    }

    @Override
    public IPMLineRW getTargetLineRW() {
        return this.getTargetLine();
    }

    public void setTargetLine(PMLine line) {
        this.setTargetLine((Object)line);
    }

    @Override
    public void setTargetLine(IPMLineRW line) {
        this.setTargetLine((Object)line);
    }

    private void setTargetLine(Object line) {
        assert (line == null || line instanceof PMLine) : "line is not instance of PMPoint";
        this.targetLine = (PMLine)line;
        if (line == null) {
            this.getPersistentAnchoringPointToLine().setLineUid(null);
        } else {
            this.getPersistentAnchoringPointToLine().setLineUid(this.targetLine.getPersistentLine().getUid());
        }
    }

    protected PMAnchoringPointToLine(PlanModelMgr planModelMgr, PMPoint point, PMLine targetLine) {
        super(planModelMgr);
        this.persistent = new EOAnchoringPointToLine();
        this.constructPMAnchoring(point);
        this.setTargetLine(targetLine);
    }

    @Override
    protected void removeLinks() {
        super.removeLinks();
        this.setTargetLine(null);
    }

    @Override
    public void delete() {
        super.delete();
        if (this.getTargetLine() != null) {
            this.getTargetLine().setAnchoring(null);
            this.setTargetLine(null);
        }
    }

    @Override
    public IAnchoringDestination getAnchoringDestination() {
        return this.getAnchoringDestinationLine();
    }

    @Override
    public IAnchoringDestinationLine getAnchoringDestinationLine() {
        return this.getTargetLine();
    }

    @Override
    public boolean isDesirable() {
        return this.getPoint().getPlanElement().getPlan().getAnchoringDecider().isDesirableAnchoring(this.getAnchoringSource(), this.getAnchoringDestination());
    }

    @Override
    public boolean isValid() {
        if (this.getPoint() == null || this.getPoint().getAnchoring() != this) {
            return false;
        }
        return this.getTargetLine() != null && this.getTargetLine().getAnchoringIndex(this) >= 0;
    }

    static class AnchoringPointToLineFactory
    extends PMAnchoringPoint.AnchoringPointFactory {
        AnchoringPointToLineFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMAnchoringPointToLine(planModelMgr, (EOAnchoringPointToLine)eo);
        }

        @Override
        public List getChildren(EncodableObjectBase eo) {
            return super.getChildren(eo);
        }
    }
}

