/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.appearance;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearance;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;

public class LineMarkerAppearance
implements ILineMarkerAppearance {
    private LineMarker lineMarker = DEFAULT_LINEMARKER;
    private double lineMarkerSize = 0.75;
    private int lineMarkerColorRed = 0;
    private int lineMarkerColorGreen = 0;
    private int lineMarkerColorBlue = 0;
    private boolean lineMarkerColorTransparent = false;
    private int lineMarkerFillColorRed = 255;
    private int lineMarkerFillColorGreen = 255;
    private int lineMarkerFillColorBlue = 255;
    private int lineMarkerFillColorAlpha = 255;

    public static void copy(ILineMarkerAppearanceRO source, ILineMarkerAppearance target) {
        target.setLineMarkerStyle(source.getLineMarkerStyle());
        target.setLineMarkerSize(source.getLineMarkerSize());
        target.setLineMarkerColor(source.getLineMarkerColor());
        target.setLineMarkerFillColor(source.getLineMarkerFillColor());
    }

    public LineMarkerAppearance() {
    }

    public LineMarkerAppearance(ILineMarkerAppearanceRO source) {
        this.setAppearanceFrom(source);
    }

    @Override
    public double getLineMarkerSize() {
        return this.lineMarkerSize;
    }

    @Override
    public Color getLineMarkerColor() {
        if (this.lineMarkerColorTransparent) {
            return new Color(Color.TRANSPARENT);
        }
        return new Color(this.lineMarkerColorRed, this.lineMarkerColorGreen, this.lineMarkerColorBlue);
    }

    @Override
    public FillColor getLineMarkerFillColor() {
        return new FillColor(this.lineMarkerFillColorRed, this.lineMarkerFillColorGreen, this.lineMarkerFillColorBlue, this.lineMarkerFillColorAlpha);
    }

    @Override
    public void setLineMarkerSize(double lineMarkerSize) {
        this.lineMarkerSize = lineMarkerSize;
    }

    @Override
    public void setLineMarkerColor(Color color) {
        assert (color != null);
        this.lineMarkerColorRed = color.r;
        this.lineMarkerColorGreen = color.g;
        this.lineMarkerColorBlue = color.b;
        this.lineMarkerColorTransparent = color.transparent;
    }

    @Override
    public void setLineMarkerFillColor(FillColor color) {
        assert (color != null);
        this.lineMarkerFillColorRed = color.foregroundColor.r;
        this.lineMarkerFillColorGreen = color.foregroundColor.g;
        this.lineMarkerFillColorBlue = color.foregroundColor.b;
        this.lineMarkerFillColorAlpha = color.foregroundAlpha;
    }

    @Override
    public void setLineMarkerStyle(LineMarker lineMarkerStyle) {
        assert (lineMarkerStyle != null);
        this.lineMarker = lineMarkerStyle;
    }

    @Override
    public LineMarker getLineMarkerStyle() {
        return this.lineMarker;
    }

    @Override
    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof ILineMarkerAppearanceRO)) {
            return;
        }
        ILineMarkerAppearanceRO marker = (ILineMarkerAppearanceRO)appearance;
        this.setLineMarkerColor(marker.getLineMarkerColor());
        this.setLineMarkerFillColor(marker.getLineMarkerFillColor());
        this.setLineMarkerSize(marker.getLineMarkerSize());
        this.setLineMarkerStyle(marker.getLineMarkerStyle());
    }

    @Override
    public IAppearanceRO getAppearanceAsCopy() {
        return new LineMarkerAppearance(this);
    }
}

