/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringLineToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToAnchorRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMContainmentRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACAddContainedPlanElement;
import com.arcway.planagent.planmodel.actions.ACCreateAnchorOffSet;
import com.arcway.planagent.planmodel.actions.ACCreateAnchorRelativePosition;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoring;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringLineToLine;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPointToAnchor;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPointToFigure;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPointToLine;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPointToPoint;
import com.arcway.planagent.planmodel.actions.ACMove2Points1Line;
import com.arcway.planagent.planmodel.actions.ACMove3Points2Lines;
import com.arcway.planagent.planmodel.actions.ACMoveLine;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.ACNOP;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoring;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoringLineToLine;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoringPointToAnchor;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoringPointToFigure;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoringPointToLine;
import com.arcway.planagent.planmodel.actions.ACRemoveAnchoringPointToPoint;
import com.arcway.planagent.planmodel.actions.ACRemoveContainment;
import com.arcway.planagent.planmodel.actions.ACRemoveEndPoint;
import com.arcway.planagent.planmodel.actions.ACSetPositionAnchorOffSet;
import com.arcway.planagent.planmodel.actions.ACSetPositionAnchorRelativePosition;
import com.arcway.planagent.planmodel.actions.ACSetPositionAnchorRelativePositionAndOffSet;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.nesting.INestable;
import java.util.HashSet;

public class ActionFactory {
    private static final ILogger logger = Logger.getLogger(ActionFactory.class);

    public static Action createACCreateAnchoring(ActionContext context, IAnchoringSource source, IAnchoringDestination destination) {
        ACCreateAnchoring action = null;
        if (source instanceof IPMPointRW) {
            IPMPointRW sourcePoint = (IPMPointRW)source;
            if (destination instanceof IPMFigureRW) {
                action = new ACCreateAnchoringPointToFigure(context, sourcePoint, (IPMFigureRW)destination);
            } else if (destination instanceof IPMAnchorRW) {
                action = new ACCreateAnchoringPointToAnchor(context, sourcePoint, (IPMAnchorRW)destination);
            } else if (destination instanceof IPMLineRW) {
                action = new ACCreateAnchoringPointToLine(context, sourcePoint, (IPMLineRW)destination);
            } else if (destination instanceof IPMPointRW) {
                action = new ACCreateAnchoringPointToPoint(context, sourcePoint, (IPMPointRW)destination);
            }
        } else if (source instanceof IPMLineRW) {
            IPMLineRW sourceLine = (IPMLineRW)source;
            if (destination instanceof IPMLineRW) {
                action = new ACCreateAnchoringLineToLine(context, sourceLine, (IPMLineRW)destination);
            }
        }
        if (action == null) {
            logger.error("PlanModel - Action Factory: Anchoring type not found.");
        }
        return action;
    }

    public static Action createACRemoveAnchoring(ActionContext context, IAnchoring anchoring) {
        ACRemoveAnchoring action = null;
        if (anchoring instanceof IPMAnchoringPointToFigureRW) {
            action = new ACRemoveAnchoringPointToFigure(context, (IPMAnchoringPointToFigureRW)anchoring);
        } else if (anchoring instanceof IPMAnchoringPointToAnchorRW) {
            action = new ACRemoveAnchoringPointToAnchor(context, (IPMAnchoringPointToAnchorRW)anchoring);
        } else if (anchoring instanceof IPMAnchoringPointToLineRW) {
            action = new ACRemoveAnchoringPointToLine(context, (IPMAnchoringPointToLineRW)anchoring);
        } else if (anchoring instanceof IPMAnchoringPointToPointRW) {
            action = new ACRemoveAnchoringPointToPoint(context, (IPMAnchoringPointToPointRW)anchoring);
        } else if (anchoring instanceof IPMAnchoringLineToLineRW) {
            action = new ACRemoveAnchoringLineToLine(context, (IPMAnchoringLineToLineRW)anchoring);
        } else {
            logger.error("PlanModel - Action Factory: Anchoring type not found.");
        }
        return action;
    }

    private static boolean hasAnchoringPointToPointOrAnchor(IPMLineRW line) {
        return ActionFactory.hasAnchoringToPointOrAnchor(line.getPoint1stRW()) || ActionFactory.hasAnchoringToPointOrAnchor(line.getPoint2ndRW());
    }

    public static Action createACRemoveContainment(ActionContext context, INestable container, INestable contained) {
        ACRemoveContainment action = null;
        if (container instanceof IPMPlanElementRW && contained instanceof IPMPlanElementRW) {
            IPMContainmentRW containment = null;
            IPMPlanElementRW containerPlanElement = (IPMPlanElementRW)container;
            IPMPlanElementRW containedPlanElement = (IPMPlanElementRW)contained;
            int containments = containerPlanElement.getContainmentAsContainerCount();
            int i = 0;
            while (containment == null && i < containments) {
                IPMContainmentRW currentContainment = containerPlanElement.getContainmentAsContainerRW(i);
                if (currentContainment.getContainedPlanElementRW() == containedPlanElement) {
                    containment = currentContainment;
                }
                ++i;
            }
            if (containment != null) {
                action = new ACRemoveContainment(context, containment);
            }
        }
        if (action == null) {
            logger.error("PlanModel - Action Factory: Containment not found.");
        }
        return action;
    }

    public static Action createACCreateContainment(ActionContext context, INestable container, INestable contained) {
        ACAddContainedPlanElement action = null;
        if (container instanceof IPMPlanElementRW && contained instanceof IPMPlanElementRW) {
            action = new ACAddContainedPlanElement(context, (IPMPlanElementRW)contained, (IPMPlanElementRW)container);
        } else {
            logger.error("PlanModel - Action Factory: Anchoring type not found.");
        }
        return action;
    }

    public static ACMovePoint createACMovePoint(ActionContext context, IAnchoringSourcePoint sourcePoint, GeoVector dist, boolean removeSourceAnchorings) {
        GeoVector distance = dist;
        ACMovePoint action = null;
        if (sourcePoint instanceof IPMPointRW) {
            IPMLineRW line2nd;
            IPMPointRW point = (IPMPointRW)sourcePoint;
            IPMLineRW line1st = point.getLine1stRW();
            if (line1st != null) {
                distance = ActionFactory.forceDistance(distance, line1st, line1st.getPoint1stRW());
            }
            if ((line2nd = point.getLine2ndRW()) != null) {
                distance = ActionFactory.forceDistance(distance, line2nd, line2nd.getPoint2ndRW());
            }
            HashSet<IPMPointRW> pointsToMove = new HashSet<IPMPointRW>(3);
            if (!Geo.equals((double)distance.x, (double)0.0)) {
                pointsToMove.add(point);
                if (line1st != null && line1st.getForce() == 3) {
                    pointsToMove.add(line1st.getPoint1stRW());
                }
                if (line2nd != null && line2nd.getForce() == 3) {
                    pointsToMove.add(line2nd.getPoint2ndRW());
                }
            }
            if (!Geo.equals((double)distance.y, (double)0.0)) {
                pointsToMove.add(point);
                if (line1st != null && line1st.getForce() == 2) {
                    pointsToMove.add(line1st.getPoint1stRW());
                }
                if (line2nd != null && line2nd.getForce() == 2) {
                    pointsToMove.add(line2nd.getPoint2ndRW());
                }
            }
            action = pointsToMove.size() == 3 ? new ACMove3Points2Lines(context, point, distance, removeSourceAnchorings) : (pointsToMove.size() == 2 ? new ACMove2Points1Line(context, point, distance, removeSourceAnchorings) : new ACMovePoint(context, point, distance, removeSourceAnchorings));
        }
        assert (action != null) : "no action chosen, should not be possible";
        return action;
    }

    private static GeoVector forceDistance(GeoVector distance, IPMLineRW relatedLine, IPMPointRW neighbourPoint) {
        GeoVector newDistance = ActionFactory.hasAnchoringToPointOrAnchor(neighbourPoint) ? (relatedLine.getForce() == 2 ? new GeoVector(distance.x, 0.0) : (relatedLine.getForce() == 3 ? new GeoVector(0.0, distance.y) : distance)) : distance;
        return newDistance;
    }

    private static boolean hasAnchoringToPointOrAnchor(IPMPointRW point) {
        IPMAnchoringPointRW anchoring = point.getAnchoringRW();
        boolean hasAnchoring = anchoring != null ? anchoring instanceof IPMAnchoringPointToPointRW || anchoring instanceof IPMAnchoringPointToAnchorRW : false;
        return hasAnchoring;
    }

    public static Action createACMoveLine(ActionContext actionContext, IPMLineRW line, GeoVector distance, boolean removeSourceAnchorings) {
        Action action = null;
        action = ActionFactory.hasAnchoringPointToPointOrAnchor(line) ? new ACNOP(line, actionContext) : new ACMoveLine(actionContext, line, distance, removeSourceAnchorings);
        return action;
    }

    public static Action createACCreateAnchor(ActionContext context, IPMLineRW line, double relativePosition) {
        return new ACCreateAnchorRelativePosition(context, line, relativePosition);
    }

    public static Action createACCreateAnchor(ActionContext context, IPMLineRW line, GeoVector offSet) {
        return new ACCreateAnchorOffSet(context, line, offSet);
    }

    public static Action createACSetPositionAnchor(ActionContext context, IPMAnchorRW anchor, double relativePosition) {
        return new ACSetPositionAnchorRelativePosition(context, anchor, relativePosition);
    }

    public static Action createACSetPositionAnchor(ActionContext context, IPMAnchorRW anchor, GeoVector offSet) {
        return new ACSetPositionAnchorOffSet(context, anchor, offSet);
    }

    public static Action createACSetPositionAnchor(ActionContext context, IPMAnchorRW anchor, double relativePosition, GeoVector offSet) {
        return new ACSetPositionAnchorRelativePositionAndOffSet(context, anchor, relativePosition, offSet);
    }

    public static Action createACRemovePoint(ActionContext context, IPMPointRW point) {
        assert (context != null) : "ref to context is null";
        assert (point != null) : "ref to point is null";
        assert (point.getLine1stRW() != null || point.getLine2ndRW() != null) : "point without lines can not be removed";
        ACRemoveEndPoint action = null;
        if (point.getLine1stRW() == null && point.getLine2ndRW() != null || point.getLine1stRW() != null && point.getLine1stRW() == null) {
            action = new ACRemoveEndPoint(context, point);
        } else if (point.getLine1stRW().getForce() != 1) {
            point.getLine2ndRW().getForce();
        }
        assert (action != null) : "no action chosen, should not be possible";
        return action;
    }
}

