/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMContainmentRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACRemoveContainment
extends Action {
    private final IPMContainmentRW containment;
    private IPMPlanElementRW containedPlanElement;
    private IPMPlanElementRW containingPlanElement;
    private int containedIndex;
    private int containingIndex;

    public ACRemoveContainment(ActionContext actionContext, IPMContainmentRW containment) {
        super(actionContext);
        assert (containment != null) : "ref to containment is null";
        this.containment = containment;
    }

    @Override
    protected void initializeState() {
        this.containedPlanElement = this.containment.getContainedPlanElementRW();
        this.containedIndex = this.containedPlanElement.getContainmentAsContainedIndex(this.containment);
        this.containingPlanElement = this.containment.getContainingPlanElementRW();
        this.containingIndex = this.containingPlanElement.getContainmentAsContainerIndex(this.containment);
    }

    @Override
    protected void setStateToPost() {
        assert (this.containedIndex == this.containedPlanElement.getContainmentAsContainedIndex(this.containment)) : "the containment is not at the expected index";
        this.containedPlanElement.removeContainmentsAsContained(this.containedIndex);
        assert (this.containingIndex == this.containingPlanElement.getContainmentAsContainerIndex(this.containment)) : "the containment is not at the expected index";
        this.containingPlanElement.removeContainmentsAsContainer(this.containingIndex);
    }

    @Override
    protected void setStateToPre() {
        this.containedPlanElement.addContainmentsAsContained(this.containment, this.containedIndex);
        this.containingPlanElement.addContainmentsAsContainer(this.containment, this.containingIndex);
    }

    @Override
    public boolean isDupe(Action a) {
        ACRemoveContainment dupeA;
        boolean isDupe = false;
        if (a instanceof ACRemoveContainment && (dupeA = (ACRemoveContainment)a).getContainment() == this.getContainment()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.containment, 3));
        return changes;
    }

    public Collection getEntriesForCompressedReactionList() {
        return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionRemoveContainmentAgent().getEntryForCompressedList(this.getRemovedContainment(), this.getActionContext()));
    }

    public IPMContainmentRW getRemovedContainment() {
        return this.containment;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.containment.getContainedPlanElementRW().getPlanRW();
    }

    public IPMContainmentRW getContainment() {
        return this.containment;
    }

    public String toString() {
        return "ACRemoveContainment (containment " + this.containment + ")";
    }
}

