/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.gui.reactions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.actions.ACMoveLine;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import java.util.List;

public class RAResizeGUIGroupNameSupplement
extends AbstractResizeSupplementRouter {
    private IPMGraphicalSupplementRW nameSupplement = null;

    public RAResizeGUIGroupNameSupplement(IPMGraphicalSupplementRW nameSupplement) {
        this.nameSupplement = nameSupplement;
    }

    protected ActionIterator calculateReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        IPMPointListRW points = this.nameSupplement.getPointListRW();
        assert (points.getPointCount() == 4 && points.getLineCount() == 4) : "exactly 4 points and lines expected";
        int firstVerticalLineIndex = 0;
        IPMLineRW firstVerticalLine = points.getLineRW(firstVerticalLineIndex);
        if (firstVerticalLine.getForce() != 3) {
            firstVerticalLine = points.getLineRW(++firstVerticalLineIndex);
        }
        assert (firstVerticalLine.getForce() == 3) : "no first vertical line found";
        IPMLineRW secondVerticalLine = points.getLineRW(firstVerticalLineIndex + 2);
        assert (secondVerticalLine.getForce() == 3) : "no second vertical line found";
        Rectangle bounds = figure.getPointListRW().getPoints().getBounds();
        GeoVector moveFirstVertical = new GeoVector(bounds.upperLeft.x - firstVerticalLine.getPoint1stRW().getPosition().x + 2.5, 0.0);
        GeoVector moveSecondVertical = new GeoVector(bounds.lowerRight.x - secondVerticalLine.getPoint1stRW().getPosition().x, 0.0);
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        if (!moveFirstVertical.isZero()) {
            actions.addAction((Action)new ACMoveLine(context, firstVerticalLine, moveFirstVertical, false));
        }
        if (!moveSecondVertical.isZero()) {
            actions.addAction((Action)new ACMoveLine(context, secondVerticalLine, moveSecondVertical, false));
        }
        double distance = Math.abs(firstVerticalLine.getPoint1stRW().getPosition().y - firstVerticalLine.getPoint2ndRW().getPosition().y) * 0.5;
        IPMLineRW firstHorizontalLine = points.getLineRW(firstVerticalLineIndex + 1);
        assert (firstHorizontalLine.getForce() == 2) : "no first horizontal line found";
        IPMLineRW secondHorizontalLine = points.getLineRW((firstVerticalLineIndex + 3) % 4);
        assert (secondHorizontalLine.getForce() == 2) : "no second horizontal line found";
        GeoVector moveHorizontal = new GeoVector(0.0, bounds.upperLeft.y - firstHorizontalLine.getPoint1stRW().getPosition().y + distance);
        if (!moveHorizontal.isZero()) {
            actions.addAction((Action)new ACMoveLine(context, firstHorizontalLine, moveHorizontal, false));
            actions.addAction((Action)new ACMoveLine(context, secondHorizontalLine, moveHorizontal, false));
        }
        return actions;
    }
}

