/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.pn.reactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.fmc.pn.access.readwrite.IPMPlanElementFMCPNMediumRW;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import java.util.List;

public class RAFixFMCPNMediumNameSupplement
extends AbstractResizeSupplementRouter {
    private static final ILogger logger = Logger.getLogger(RAFixFMCPNMediumNameSupplement.class);

    public ActionIterator calculateReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixAnchoringsAfterFigureModify createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(6);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMPlanElementRW planElement = figure.getPlanElementRW();
        if (!(planElement instanceof IPMPlanElementFMCPNMediumRW)) {
            return;
        }
        IPMPlanElementFMCPNMediumRW medium = (IPMPlanElementFMCPNMediumRW)planElement;
        IPMGraphicalSupplementTextRW supplement = medium.getNameSupplementRW();
        if (supplement == null) {
            return;
        }
        assert (supplement.getPointListRW().getLineCount() == 4);
        IPMPointRW ul = null;
        IPMPointRW lr = null;
        int i = 0;
        while (i < supplement.getPointListRW().getPointCount()) {
            IPMPointRW currentPoint = supplement.getPointListRW().getPointRW(i);
            if (ul == null) {
                ul = currentPoint;
            } else if (currentPoint.getPosition().y + 1.0E-10 < ul.getPosition().y) {
                ul = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)ul.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < ul.getPosition().x) {
                ul = currentPoint;
            }
            if (lr == null) {
                lr = currentPoint;
            } else if (currentPoint.getPosition().y - 1.0E-10 > lr.getPosition().y) {
                lr = currentPoint;
            } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lr.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lr.getPosition().x) {
                lr = currentPoint;
            }
            ++i;
        }
        assert (lr != null) : "lr is NULL.";
        assert (ul != null) : "ul is NULL.";
        double wHalf = (lr.getPosition().x - ul.getPosition().x) / 2.0;
        double h = lr.getPosition().y - ul.getPosition().y;
        double centerX = figure.getPointListRW().getPointRW((int)0).getPosition().x;
        double lowerY = figure.getPointListRW().getPointRW((int)0).getPosition().y;
        double newX1 = centerX - wHalf;
        double newX2 = centerX + wHalf;
        double newY1 = lowerY - h;
        double newY2 = lowerY;
        ACMovePoint moveUl = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)ul, (GeoVector)new GeoVector(ul.getPosition(), new Point(newX1, newY1)), (boolean)false);
        actions.addAction((Action)moveUl);
        ACMovePoint moveLr = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)lr, (GeoVector)new GeoVector(lr.getPosition(), new Point(newX2, newY2)), (boolean)false);
        actions.addAction((Action)moveLr);
    }
}

