/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.implementation;

import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDecider;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Figure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Point;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineStartMarkerAppearanceRO;
import com.arcway.planagent.planmodel.cm.routing.CurveLineRouter;
import com.arcway.planagent.planmodel.cm.routing.RemoveAnchoringRouter;
import com.arcway.planagent.planmodel.cm.routing.SetPointToPointRouter;
import com.arcway.planagent.planmodel.fmc.bd.check.BDValidityMatrix;
import com.arcway.planagent.planmodel.fmc.bd.implementation.PMPlanElementFMCBDChannel;
import com.arcway.planagent.planmodel.fmc.bd.relations.FMCBDRelationMatrix;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import com.arcway.planagent.planmodel.relations.PlanElementRelation;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.AllowAllTransactionsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import java.util.ArrayList;

public class PMPlanFMCBD
extends PMPlan
implements IAnchoringDecider,
IRoutingManager,
INestingManager {
    public static final String PLAN_TYPE_ID = "fmc.bd";
    private static String XML_TYPE = "fmc.bd";

    public PMPlanFMCBD(PlanModelMgr planModelMgr, EOPlan eo) {
        super(planModelMgr, eo);
    }

    public PMPlanFMCBD(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public String[] getSupportedPlanElementTypeIDs() {
        return new String[]{"fmc.bd.agent", "fmc.bd.channel", "fmc.bd.modifyingstorageaccess", "fmc.bd.storage", "fmc.bd.storageaccess", "fmc.cm.entity", "fmc.cm.dotscomment", "fmc.cm.lineshapecomment", "fmc.cm.legend", "fmc.cm.planecomment"};
    }

    public IRoutingManager getRoutingManager() {
        return this;
    }

    public INestingManager getNestingManager() {
        return this;
    }

    public IAnchoringDecider getAnchoringDecider() {
        return this;
    }

    public boolean isDesirableAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isDesirable = false;
        IPMFigureRO fig1 = source.getAnchoringFigure();
        IPMFigureRO fig2 = destination.getAnchoringFigure();
        return isDesirable |= BDValidityMatrix.isTouchValid(fig1, fig2);
    }

    protected boolean isAllowedAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isAllowed = false;
        if (source instanceof IAnchoringSourcePoint) {
            if (destination instanceof IAnchoringDestinationFigure) {
                isAllowed |= BDValidityMatrix.isPointToFigureAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationFigure)destination);
            }
            if (destination instanceof IAnchoringDestinationPoint) {
                isAllowed |= BDValidityMatrix.isPointToPointAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationPoint)destination);
            }
        }
        return isAllowed;
    }

    public IRouter getRouter(IAnchoring anchoring, IRoutingParameters routingParameters) {
        Object router = anchoring instanceof IAnchoringPoint2Figure ? new CurveLineRouter() : (anchoring instanceof IAnchoringPoint2Point ? new SetPointToPointRouter() : new RemoveAnchoringRouter());
        return router;
    }

    public boolean decideNesting(INestable inner, INestable outer) {
        boolean nestingAllowed = false;
        return nestingAllowed;
    }

    public ITransactionValidator getTransactionValidator() {
        return AllowAllTransactionsTransactionValidator.getInstance();
    }

    public PlanElementRelation analyzePlanElementRelation(String startPlanElementType, String endPlanElementType, ILineStartMarkerAppearanceRO lineStartMarkerAppearanceRO, ILineEndMarkerAppearanceRO lineEndMarkerAppearanceRO, ILineAppearanceRO lineAppearanceRO) {
        int direction = FMCBDRelationMatrix.getDirection(lineStartMarkerAppearanceRO, lineEndMarkerAppearanceRO);
        if (direction != -1 && FMCBDRelationMatrix.isAccess(startPlanElementType, endPlanElementType)) {
            return new PlanElementRelation(0, direction);
        }
        return null;
    }

    public void migrateAfterDeserialization() throws EXPlanCreationException {
        ArrayList<PMPlanElement> planElements = new ArrayList<PMPlanElement>();
        int i = 0;
        while (i < this.getPlanElementCount()) {
            PMPlanElement planElement = this.getPlanElement(i);
            planElements.add(planElement);
            ++i;
        }
        for (PMPlanElement planElement : planElements) {
            if (!(planElement instanceof PMPlanElementFMCBDChannel)) continue;
            PMPlanElementFMCBDChannel channel = (PMPlanElementFMCBDChannel)planElement;
            channel.migrateAfterDeserialization();
        }
    }

    public FlowType getFlowType() {
        return FlowType.UNKNOWN;
    }
}

