/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.base.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.Alignment;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.base.access.readonly.IAlignmentProvider;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithDescriptionSupplementRO;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithDescriptionSupplementRW;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.cm.actions.ACCreateGraphicalSupplementPlaneText;
import com.arcway.planagent.planmodel.cm.actions.ACCreateGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;
import java.util.List;

public class TACreateDescriptionSupplement
extends PredeterminedLengthTransaction {
    private static final int NUMBER_OF_ACTIONS = 2;
    private ITextAppearanceRO textAppearance;
    private ILineAppearanceRO lineAppearance;
    private IFillAppearanceRO fillAppearance;
    private Points textPoints;
    private int[] textForce;
    private IPMFigureRW outlineFigure;

    public TACreateDescriptionSupplement(IPMPlanElementWithDescriptionSupplementRO planElement, ActionParameters actionParameters, ITextAppearanceRO textAppearance, Points textPoints) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanElementWithDescriptionSupplementRW)((Object)planElement)), actionParameters);
        List outlineFigures = planElement.getFiguresRO("outline");
        this.outlineFigure = outlineFigures.size() > 0 ? (IPMFigureRW)outlineFigures.get(0) : (IPMFigureRW)planElement.getFigureRO(0);
        try {
            if (planElement instanceof IAlignmentProvider) {
                TextAppearance modifiedAppearance = new TextAppearance(textAppearance);
                Alignment newAlignment = ((IAlignmentProvider)((Object)planElement)).getDefaultNameAlignment();
                assert (newAlignment != null) : "newAlignment is null";
                modifiedAppearance.setAlignment(newAlignment);
                this.textAppearance = modifiedAppearance;
            } else {
                this.textAppearance = textAppearance;
            }
            this.textPoints = textPoints;
            this.textForce = LineHelper.createAlternatingLineForcesClosed(textPoints);
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public TACreateDescriptionSupplement(IPMPlanElementWithDescriptionSupplementRO planElement, ActionParameters actionParameters, ITextAppearanceRO textAppearance, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance, Points textPoints) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanElementWithDescriptionSupplementRW)((Object)planElement)), actionParameters);
        List outlineFigures = planElement.getFiguresRO("outline");
        this.outlineFigure = outlineFigures.size() > 0 ? (IPMFigureRW)outlineFigures.get(0) : (IPMFigureRW)planElement.getFigureRO(0);
        try {
            this.textAppearance = textAppearance;
            this.lineAppearance = lineAppearance;
            this.fillAppearance = fillAppearance;
            this.textPoints = textPoints;
            this.textForce = LineHelper.createAlternatingLineForcesClosed(textPoints);
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public TACreateDescriptionSupplement(IPMPlanElementWithDescriptionSupplementRO planElement, IPMFigureRO nameSupplementFigure, ActionParameters actionParameters, ITextAppearanceRO textAppearance, Points textPoints) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanElementWithDescriptionSupplementRW)((Object)planElement)), actionParameters);
        this.outlineFigure = (IPMFigureRW)nameSupplementFigure;
        try {
            this.textAppearance = textAppearance;
            this.textPoints = textPoints;
            this.textForce = LineHelper.createAlternatingLineForcesClosed(textPoints);
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        Object action = null;
        switch (n) {
            case 0: {
                if (this.lineAppearance != null && this.fillAppearance != null) {
                    action = new ACCreateGraphicalSupplementPlaneText(this.getActionContext(), this.textPoints, this.textForce, this.outlineFigure, "descriptionSupplement", this.textAppearance, this.lineAppearance, this.fillAppearance);
                    break;
                }
                action = new ACCreateGraphicalSupplementText(this.getActionContext(), this.textPoints, this.textForce, this.outlineFigure, "descriptionSupplement", this.textAppearance);
                break;
            }
            case 1: {
                if (this.lineAppearance != null && this.fillAppearance != null) {
                    ACCreateGraphicalSupplementPlaneText createAction = (ACCreateGraphicalSupplementPlaneText)previousActions.get(0);
                    action = new ACSetTextGraphicalSupplementText(this.getActionContext(), createAction.getGraphicalSupplementText(), this.outlineFigure.getPlanElementRW().getDescription());
                    break;
                }
                ACCreateGraphicalSupplementText createAction = (ACCreateGraphicalSupplementText)previousActions.get(0);
                action = new ACSetTextGraphicalSupplementText(this.getActionContext(), createAction.getGraphicalSupplementText(), this.outlineFigure.getPlanElementRW().getDescription());
            }
        }
        return action;
    }

    public String toString() {
        return "TAAddFMCBDDescriptionSupplement (Points " + this.textPoints + ")";
    }
}

