/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.oc.check;

import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.bpre.oc.access.readonly.IPMPlanElementBPREOCEdgeRO;
import com.arcway.planagent.planmodel.bpre.oc.access.readonly.IPMPlanElementBPREOCPositionRO;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMPlanElementDotsCommentRO;

public class OCValidityMatrix {
    public static boolean isPointToFigureAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationFigure destination) {
        boolean anchoringIsPossible = false;
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        anchoringIsPossible |= OCValidityMatrix.isEdge(source.getAnchoringFigure()) && OCValidityMatrix.isNode(destination.getAnchoringFigure());
        return anchoringIsPossible |= OCValidityMatrix.isDotsComment(sourceFigure) && (OCValidityMatrix.isNode(destinationFigure) || OCValidityMatrix.isEdge(destinationFigure));
    }

    public static boolean isPointToPointAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationPoint destination) {
        boolean anchoringIsPossible = false;
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        return anchoringIsPossible |= OCValidityMatrix.isDotsComment(sourceFigure) && (OCValidityMatrix.isNode(destinationFigure) || OCValidityMatrix.isEdge(destinationFigure));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPointToLineAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationLine destination) {
        boolean anchoringIsPossible = false;
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        anchoringIsPossible |= OCValidityMatrix.isEdge(sourceFigure) && OCValidityMatrix.isEdge(destinationFigure);
        IPMPointListRO pointList = destinationFigure.getPointListRO();
        IPMFigureRO destAnchoringFigure = null;
        int i = 0;
        if (i < pointList.getPointCount()) {
            IPMPointRO point = pointList.getPointRO(i);
            if (point.getAnchoringRO() == null) return false;
            destAnchoringFigure = point.getAnchoringRO().getAnchoringDestination().getAnchoringFigure();
            if (destAnchoringFigure == null) return false;
            if (!OCValidityMatrix.isNode(destAnchoringFigure)) return false;
            anchoringIsPossible |= true;
        }
        IPMPointListRO srcPointList = sourceFigure.getPointListRO();
        Object srcAnchoringFigure = null;
        int i2 = 0;
        while (i2 < srcPointList.getPointCount()) {
            IPMPointRO point = srcPointList.getPointRO(i2);
            if (point.getAnchoringRO() != null) {
                srcAnchoringFigure = point.getAnchoringRO().getAnchoringDestination().getAnchoringFigure();
                if (srcAnchoringFigure != null && OCValidityMatrix.isNode((IPMFigureRO)srcAnchoringFigure)) break;
                srcAnchoringFigure = null;
            }
            ++i2;
        }
        if (srcAnchoringFigure == null) return anchoringIsPossible;
        if (!srcAnchoringFigure.equals(destAnchoringFigure)) return anchoringIsPossible;
        return false;
    }

    public static boolean isTouchValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        boolean touchIsValid = false;
        touchIsValid |= OCValidityMatrix.isDirectedTouchValid(figure1, figure2);
        return touchIsValid |= OCValidityMatrix.isDirectedTouchValid(figure2, figure1);
    }

    private static boolean isDirectedTouchValid(IPMFigureRO sourceFigure, IPMFigureRO destinationFigure) {
        boolean touchIsValid = true;
        IPMPlanElementRO edgePlanElement = sourceFigure.getPlanElementRO();
        IPMPlanElementRO nodePlanElement = destinationFigure.getPlanElementRO();
        touchIsValid = OCValidityMatrix.isEdge(sourceFigure) && OCValidityMatrix.isNode(destinationFigure) ? (touchIsValid &= !(edgePlanElement instanceof IPMPlanElementBPREOCEdgeRO) || !(nodePlanElement instanceof IPMPlanElementBPREOCPositionRO)) : (OCValidityMatrix.isEdge(sourceFigure) && OCValidityMatrix.isEdge(destinationFigure) ? (touchIsValid &= true) : (OCValidityMatrix.isDotsComment(sourceFigure) ? (touchIsValid &= OCValidityMatrix.isEdge(destinationFigure) || OCValidityMatrix.isNode(destinationFigure)) : (touchIsValid &= false)));
        return touchIsValid;
    }

    public static boolean isCombinationValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        return true;
    }

    private static boolean isEdge(IPMFigureRO figure) {
        boolean isEdge = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isEdge |= planElement instanceof IPMPlanElementBPREOCEdgeRO;
    }

    private static boolean isNode(IPMFigureRO figure) {
        boolean isNode = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isNode |= planElement instanceof IPMPlanElementBPREOCPositionRO;
    }

    private static boolean isDotsComment(IPMFigureRO figure) {
        boolean isComment = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isComment |= planElement instanceof IPMPlanElementDotsCommentRO;
    }
}

