/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks.palette;

import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CanvasItem
extends Canvas
implements PaintListener,
MouseListener,
MouseTrackListener {
    private static final int TEXT_INSET = 2;
    private Image image;
    private String text = "";
    private boolean mouseOver = false;
    private Integer labelTextHeight;
    private String[] splittedText = null;

    public CanvasItem(Composite parent) {
        super(parent, 0);
        this.addPaintListener(this);
        this.addMouseTrackListener(this);
        this.addMouseListener(this);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void paintControl(PaintEvent e) {
        int spacing = 2;
        Display display = e.display;
        GC gc = e.gc;
        Composite source = (Composite)e.widget;
        Rectangle rect = source.getClientArea();
        Image buf = new Image((Device)display, rect.width, rect.height);
        GC bufGC = new GC((Drawable)buf);
        Image labelBuf = new Image((Device)display, rect.width, 25);
        GC labelGC = new GC((Drawable)labelBuf);
        labelGC.setXORMode(false);
        Color background = labelGC.getBackground();
        Color foreground = labelGC.getForeground();
        labelGC.setBackground(ColorConstants.white);
        labelGC.setForeground(ColorConstants.white);
        labelGC.fillRectangle(0, 0, labelBuf.getImageData().width, labelBuf.getImageData().height);
        labelGC.setForeground(ColorConstants.black);
        if (this.mouseOver) {
            labelGC.fillRectangle(labelBuf.getBounds());
        }
        double centerX = (double)rect.width / 2.0;
        double centerY = ((double)rect.height - 25.0) / 2.0;
        int originX = (int)Math.round(centerX - (double)this.image.getBounds().width / 2.0);
        int originY = (int)Math.round(centerY - (double)this.image.getBounds().height / 2.0);
        bufGC.drawImage(this.image, originX, originY);
        if (this.labelTextHeight == null) {
            int TEST_FONT_SIZE = 10;
            int testFontHeightInPixel = this.getFontHeightInPixel(display, labelGC, TEST_FONT_SIZE);
            int nextFontHeightInPixel = this.getFontHeightInPixel(display, labelGC, TEST_FONT_SIZE - 1);
            while (nextFontHeightInPixel == testFontHeightInPixel) {
                testFontHeightInPixel = this.getFontHeightInPixel(display, labelGC, --TEST_FONT_SIZE);
                nextFontHeightInPixel = this.getFontHeightInPixel(display, labelGC, TEST_FONT_SIZE - 1);
            }
            this.labelTextHeight = (int)Math.floor(12.0 * (double)TEST_FONT_SIZE / (double)testFontHeightInPixel - 1.0E-10);
        }
        int fontHeight = this.labelTextHeight;
        if (this.splittedText == null) {
            if (rect.width >= labelGC.stringExtent((String)this.text.trim()).x + 4) {
                String[] stringArray = new String[2];
                stringArray[0] = this.text.trim();
                this.splittedText = stringArray;
            } else {
                List lineElements = StringUtil.wrapTextLine((String)this.text);
                HashMap<String, Object> lineElementExtents = new HashMap<String, Object>();
                int firstLineExtend = 0;
                int secondLineExtend = 0;
                ArrayList<String> firstLineElements = new ArrayList<String>();
                ArrayList<String> secondLineElements = new ArrayList<String>();
                for (String lineElement : lineElements) {
                    Object lineElementExtent = (Point)lineElementExtents.get(lineElement);
                    if (lineElementExtent == null) {
                        lineElementExtent = labelGC.stringExtent(lineElement);
                        lineElementExtents.put(lineElement, lineElementExtent);
                    }
                    if (secondLineElements.isEmpty() && (firstLineElements.isEmpty() || firstLineExtend + ((Point)lineElementExtent).x <= rect.width - 4)) {
                        firstLineExtend += ((Point)lineElementExtent).x;
                        firstLineElements.add(lineElement);
                        continue;
                    }
                    secondLineExtend += ((Point)lineElementExtent).x;
                    secondLineElements.add(lineElement);
                }
                while (secondLineExtend > firstLineExtend) {
                    String firstElementOfSecondLine = (String)secondLineElements.get(0);
                    int firstElementOfSecondLineExtent = ((Point)lineElementExtents.get((Object)firstElementOfSecondLine)).x;
                    if (firstLineExtend + firstElementOfSecondLineExtent > secondLineExtend) break;
                    secondLineElements.remove(0);
                    secondLineExtend -= firstElementOfSecondLineExtent;
                    firstLineElements.add(firstElementOfSecondLine);
                    firstLineExtend += firstElementOfSecondLineExtent;
                }
                StringBuilder firstLineBuilder = new StringBuilder();
                for (String firstLineElement : firstLineElements) {
                    firstLineBuilder.append(firstLineElement);
                }
                StringBuilder secondLineBuilder = new StringBuilder();
                for (String secondLineElement : secondLineElements) {
                    secondLineBuilder.append(secondLineElement);
                }
                this.splittedText = new String[]{firstLineBuilder.toString(), secondLineBuilder.toString()};
            }
        }
        Font currentFont = labelGC.getFont();
        FontData currentfontData = currentFont.getFontData()[0];
        FontData textFontData = new FontData(currentfontData.getName(), fontHeight, currentfontData.getStyle());
        Font textFont = new Font((Device)display, textFontData);
        labelGC.setFont(textFont);
        String firstLine = this.splittedText[0];
        String secondLine = this.splittedText[1];
        if (firstLine != null) {
            int maxLineExtent;
            Point secondLineExtent;
            Point firstLineExtent = labelGC.stringExtent(firstLine);
            if (secondLine != null) {
                secondLineExtent = labelGC.stringExtent(secondLine);
                maxLineExtent = Math.max(firstLineExtent.x, secondLineExtent.x);
            } else {
                secondLineExtent = null;
                maxLineExtent = firstLineExtent.x;
            }
            if (maxLineExtent > this.getSize().x - 4) {
                int drawFontHeight = (int)Math.floor((double)fontHeight * ((double)(this.getSize().x - 4) / (double)maxLineExtent));
                textFontData = new FontData(currentfontData.getName(), drawFontHeight, currentfontData.getStyle());
                textFont.dispose();
                textFont = new Font((Device)display, textFontData);
                labelGC.setFont(textFont);
                firstLineExtent = null;
                secondLineExtent = null;
            }
            if (firstLineExtent == null) {
                firstLineExtent = labelGC.stringExtent(firstLine);
            }
            labelGC.drawString(firstLine, (int)Math.round(centerX - (double)firstLineExtent.x / 2.0), 0);
            if (secondLine != null) {
                if (secondLineExtent == null) {
                    secondLineExtent = labelGC.stringExtent(secondLine);
                }
                labelGC.drawString(secondLine, (int)Math.round(centerX - (double)secondLineExtent.x / 2.0), 0 + firstLineExtent.y);
            }
        }
        labelGC.setFont(currentFont);
        textFont.dispose();
        labelGC.setBackground(background);
        labelGC.setForeground(foreground);
        bufGC.drawImage(labelBuf, 0, rect.height - labelBuf.getBounds().height);
        --rect.width;
        --rect.height;
        if (this.mouseOver) {
            gc.drawImage(buf, 0, 0);
            gc.drawRectangle(rect);
        } else {
            gc.drawImage(buf, 0, 0);
        }
        buf.dispose();
        bufGC.dispose();
        labelBuf.dispose();
        labelGC.dispose();
    }

    private int getFontHeightInPixel(Display display, GC labelGC, int fontHeightInPoints) {
        Font currentFontA = labelGC.getFont();
        FontData currentfontDataA = currentFontA.getFontData()[0];
        FontData testFontData = new FontData(currentfontDataA.getName(), fontHeightInPoints, currentfontDataA.getStyle());
        Font testFont = new Font((Device)display, testFontData);
        labelGC.setFont(testFont);
        int testFontHeightInPixel = (int)Math.round((double)labelGC.stringExtent((String)"\u00c2y").y * 1.0);
        testFont.dispose();
        labelGC.setFont(currentFontA);
        return testFontHeightInPixel;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
        this.mouseOver = true;
        this.redraw();
    }

    public void mouseExit(MouseEvent e) {
        this.mouseOver = false;
        this.redraw();
    }

    public void mouseHover(MouseEvent e) {
    }

    public void setActive(boolean active) {
        this.redraw();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void dispose() {
        super.dispose();
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(65, 65);
    }
}

