/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.inputinterpreter;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.PlanAgentPlanElementMapping;
import com.arcway.planagent.planeditor.commands.CMCreatePlanElementStructureAsCopy;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.RQCreatePlanElementStructureAsCopy;
import com.arcway.planagent.planeditor.commands.RQDuplicate;
import com.arcway.planagent.planeditor.commands.RQMove;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.FeedbackManager;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.Utilities;
import com.arcway.planagent.planeditor.framecom.FrameComUtilities;
import com.arcway.planagent.planeditor.inputinterpreter.IIUtilities;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PlanElementModelWrapper;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;

public class EPPlanLayoutEditPolicy
extends GraphicalEditPolicy {
    private static final ILogger logger = Logger.getLogger(EPPlanLayoutEditPolicy.class);
    private static final com.arcway.lib.geometry.Point zerozero = com.arcway.lib.geometry.Point.ORIGIN;
    private final FeedbackManager feedbackManager;
    private final EditMgr editManager;
    private Request requestOfCacheContent = null;
    private PMPlan copyPlanToPasteCache = null;
    private List mappingsCache = null;
    private Collection nativeContentCache = null;

    public EPPlanLayoutEditPolicy(EditMgr viewManager, FeedbackManager feedbackManager) {
        assert (viewManager != null) : "viewManager is null";
        assert (feedbackManager != null) : "feedbackManager is null";
        this.editManager = viewManager;
        this.feedbackManager = feedbackManager;
    }

    public void showTargetFeedback(Request request) {
        this.feedbackManager.showTargetFeedback(this.getCommand(request));
    }

    public void eraseTargetFeedback(Request request) {
        this.feedbackManager.eraseTargetFeedback();
    }

    private Command getMoveChildrenCommand(Request request) {
        assert (request instanceof RQMove) : "request has unexpected type: " + request;
        Command cmd = null;
        RQMove reqMove = (RQMove)request;
        List<PEPlanEditPart> elements = reqMove.getElements();
        if (elements.size() > 0) {
            GeoVector translation = new GeoVector((double)reqMove.getMoveX(), (double)reqMove.getMoveY());
            translation = translation.transform(zerozero, (Transformation)this.editManager.getTransformationCanvas2Plan());
            ICommandContext commandContext = ((PEPlanEditPart)this.getHost()).getCommandContext();
            if (!reqMove.getCreateCopy()) {
                cmd = IIUtilities.createCMMoveCommand(elements, translation, reqMove.getMoveChildrenAlso(), commandContext);
            } else {
                try {
                    if (request != this.requestOfCacheContent) {
                        List<PMPlanElement> planElements = IIUtilities.getRelatedPMPlanElements(elements, IPMPlanElementRO.class);
                        if (reqMove.getMoveChildrenAlso()) {
                            Set pmPlanElementsWithContained = ((PMPlan)this.getHost().getModel()).getAllContained(planElements);
                            planElements.clear();
                            planElements.addAll(pmPlanElementsWithContained);
                        }
                        HashMap uidMap = new HashMap();
                        PMPlan oldPlanAndTargetPlan = (PMPlan)this.getHost().getModel();
                        PMPlan newPlanAndSourcePlan = oldPlanAndTargetPlan.getCopy(planElements, uidMap);
                        this.setCache(request, newPlanAndSourcePlan, this.createPlanElementMappings(uidMap, (IPMPlanRO)oldPlanAndTargetPlan, (IPMPlanRO)newPlanAndSourcePlan, 4), commandContext.getEditorController().getNativeContentToAdd(FrameComUtilities.transformModelsToIPlanElements(planElements)));
                    }
                    cmd = new CMCreatePlanElementStructureAsCopy((IPMPlanRW)this.copyPlanToPasteCache, translation, (IPMPlanRW)((PMPlan)this.getHost().getModel()), this.mappingsCache, this.nativeContentCache, 4, commandContext);
                }
                catch (EXPlanCreationException e) {
                    logger.error("Could not copy plan elements", (Throwable)e);
                }
            }
        }
        return cmd;
    }

    private Command getCreatePlanElementStructureAsCopyCommand(Request request) {
        CMCreatePlanElementStructureAsCopy returnCommand;
        assert (request != null) : "request is null";
        assert (request instanceof RQCreatePlanElementStructureAsCopy) : "requets has unexpeted type";
        RQCreatePlanElementStructureAsCopy reqCreate = (RQCreatePlanElementStructureAsCopy)request;
        if (reqCreate.getPlan() == null) {
            return null;
        }
        com.arcway.lib.geometry.Point origin = reqCreate.getPlan().getOuterBounds().center();
        com.arcway.lib.geometry.Point position = this.transformToPlanCoordinates(reqCreate.getPosition());
        GeoVector translation = new GeoVector(position.x - origin.x, position.y - origin.y);
        try {
            HashMap uidMap = new HashMap();
            PMPlan sourcePlan = reqCreate.getPlan();
            PMPlan newPlan = sourcePlan.getCopy(null, uidMap);
            this.setCache(request, sourcePlan, this.createPlanElementMappings(uidMap, (IPMPlanRO)sourcePlan, (IPMPlanRO)newPlan, 4), reqCreate.getNativeContent());
            returnCommand = new CMCreatePlanElementStructureAsCopy((IPMPlanRW)newPlan, translation, (IPMPlanRW)((PEPlanEditPart)this.getHost()).getPEPlan().getPMPlan(), this.mappingsCache, this.nativeContentCache, reqCreate.getCreationMode(), ((PEPlanEditPart)this.getHost()).getCommandContext());
        }
        catch (EXPlanCreationException e) {
            logger.error("Could not paste plan", (Throwable)e);
            returnCommand = null;
        }
        return returnCommand;
    }

    private Command getCreateDuplicateCommand(Request request) {
        assert (request != null) : "request is null";
        assert (request instanceof RQDuplicate) : "request has unexpeted type";
        RQDuplicate reqDupl = (RQDuplicate)request;
        try {
            Rectangle planBounds;
            if (request != this.requestOfCacheContent) {
                List<PMPlanElement> pmPlanElements = IIUtilities.getRelatedPMPlanElements(reqDupl.getElements(), IPMPlanElementRO.class);
                HashMap uidMap = new HashMap();
                PMPlan originPlanAndTargetPlan = (PMPlan)this.getHost().getModel();
                PMPlan newPlanAndSourcePlan = originPlanAndTargetPlan.getCopy(pmPlanElements, uidMap);
                ICommandContext commandContext = ((PEPlanEditPart)this.getHost()).getCommandContext();
                this.setCache(request, newPlanAndSourcePlan, this.createPlanElementMappings(uidMap, (IPMPlanRO)originPlanAndTargetPlan, (IPMPlanRO)newPlanAndSourcePlan, 4), commandContext.getEditorController().getNativeContentToAdd(FrameComUtilities.transformModelsToIPlanElements(pmPlanElements)));
            }
            com.arcway.lib.geometry.Point origin = (planBounds = this.copyPlanToPasteCache.getOuterBounds()) != null ? planBounds.center() : com.arcway.lib.geometry.Point.ORIGIN;
            com.arcway.lib.geometry.Point position = this.transformToPlanCoordinates(reqDupl.getPosition());
            GeoVector translation = new GeoVector(position.x - origin.x, position.y - origin.y);
            CMCreatePlanElementStructureAsCopy cmd = new CMCreatePlanElementStructureAsCopy((IPMPlanRW)this.copyPlanToPasteCache, translation, (IPMPlanRW)((PMPlan)this.getHost().getModel()), this.mappingsCache, this.nativeContentCache, 4, ((PEPlanEditPart)this.getHost()).getCommandContext());
            if (logger.isTraceEnabled()) {
                logger.trace("getCreatePlanElementStructureAsCopyCommand(Request) - end - return value = " + (Object)((Object)cmd));
            }
            return cmd;
        }
        catch (EXPlanCreationException e) {
            logger.error("Could not duplicate", (Throwable)e);
            return null;
        }
    }

    public Command getCommand(Request request) {
        assert (request != null) : "request is null";
        Command command = null;
        command = "move".equals(request.getType()) ? this.getMoveChildrenCommand(request) : ("createPlanElementStructureAsCopy".equals(request.getType()) ? this.getCreatePlanElementStructureAsCopyCommand(request) : ("duplicate".equals(request.getType()) ? this.getCreateDuplicateCommand(request) : super.getCommand(request)));
        return command;
    }

    public EditPart getTargetEditPart(Request request) {
        assert (request != null) : "request is null";
        if ("move".equals(request.getType()) || "createPlanElementStructureAsCopy".equals(request.getType()) || "duplicate".equals(request.getType())) {
            EditPart returnEditPart = Utilities.getEditPartAtLevel(this.getHost(), 0);
            return returnEditPart;
        }
        EditPart returnEditPart = super.getTargetEditPart(request);
        return returnEditPart;
    }

    public boolean understandsRequest(Request request) {
        assert (request != null) : "request is null";
        if ("move".equals(request.getType()) || "createPlanElementStructureAsCopy".equals(request.getType()) || "duplicate".equals(request.getType())) {
            return true;
        }
        boolean returnboolean = super.understandsRequest(request);
        return returnboolean;
    }

    private com.arcway.lib.geometry.Point transformToPlanCoordinates(org.eclipse.swt.graphics.Point pointToTransform) {
        assert (pointToTransform != null) : "pointToTransform is null";
        com.arcway.lib.geometry.Point point = new com.arcway.lib.geometry.Point((double)pointToTransform.x, (double)pointToTransform.y);
        return this.editManager.transformWindowToPlanCoordinates(point, this.getHost().getRoot(), false);
    }

    private com.arcway.lib.geometry.Point transformToPlanCoordinates(Point pointToTransform) {
        assert (pointToTransform != null) : "pointToTransform is null";
        com.arcway.lib.geometry.Point point = new com.arcway.lib.geometry.Point((double)pointToTransform.x, (double)pointToTransform.y);
        return this.editManager.transformWindowToPlanCoordinates(point, this.getHost().getRoot(), false);
    }

    private List createPlanElementMappings(Map uidMap, IPMPlanRO originPlan, IPMPlanRO newPlan, int creationMode) {
        ArrayList<PlanAgentPlanElementMapping> mapping = new ArrayList<PlanAgentPlanElementMapping>();
        int i = 0;
        while (i < newPlan.getPlanElementCount()) {
            IPMPlanElementRO targetElement = newPlan.getPlanElementRO(i);
            PlanElementModelWrapper targetWrapper = null;
            String originID = (String)uidMap.get(targetElement.getUid());
            IPMPlanElementRO originElement = originPlan.getPlanElementRO(originID);
            PlanElementModelWrapper originWrapper = null;
            switch (creationMode) {
                case 1: {
                    originWrapper = null;
                    targetWrapper = new PlanElementModelWrapper(targetElement);
                    break;
                }
                case 3: {
                    originWrapper = new PlanElementModelWrapper(originElement);
                    targetWrapper = new PlanElementModelWrapper(targetElement);
                    break;
                }
                case 4: {
                    originWrapper = new PlanElementModelWrapper(originElement);
                    targetWrapper = new PlanElementModelWrapper(targetElement);
                    break;
                }
                case 2: {
                    originWrapper = null;
                    targetWrapper = new PlanElementModelWrapper(targetElement);
                }
            }
            mapping.add(new PlanAgentPlanElementMapping((IPlanAgentPlanElement)originWrapper, targetWrapper));
            ++i;
        }
        return mapping;
    }

    public void deactivate() {
        this.clearCache();
    }

    private void setCache(Request requestOfCacheContent, PMPlan copyPlanToPasteCache, List mappingsCache, Collection nativeContentCache) {
        this.clearCache();
        this.requestOfCacheContent = requestOfCacheContent;
        this.copyPlanToPasteCache = copyPlanToPasteCache;
        this.mappingsCache = mappingsCache;
        this.nativeContentCache = nativeContentCache;
        copyPlanToPasteCache.activateResourceCache();
    }

    private void clearCache() {
        this.requestOfCacheContent = null;
        this.mappingsCache = null;
        this.nativeContentCache = null;
        if (this.copyPlanToPasteCache != null) {
            this.copyPlanToPasteCache.deactivateResourceCache();
            this.copyPlanToPasteCache = null;
        }
    }
}

