/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.edit;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.graphics.Color;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightHint;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.nonpermanent.PMHighlight;
import com.arcway.planagent.planview.view.HighlightHint;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.widgets.Display;

class SelectionBlinker
extends Thread {
    private static final long BLINKER_FAST_TIME_OFF = 250L;
    private static final long BLINKER_FAST_TIME_ON = 150L;
    private static final int BLINKER_FAST_BLINKS = 1;
    private static final long BLINKER_SLOW_TIME_OFF = 150L;
    private static final long BLINKER_SLOW_TIME_ON = 150L;
    private static final int BLINKER_SLOW_BLINKS = 2;
    private final Display display;
    private final PEPlan plan;
    private boolean terminate = false;
    private boolean demphasized = false;

    public SelectionBlinker(Display display, PEPlan plan) {
        this.display = display;
        this.plan = plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SelectionBlinker selectionBlinker;
        int counter = 1;
        while (!this.terminate && counter > 0) {
            selectionBlinker = this;
            synchronized (selectionBlinker) {
                try {
                    this.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.terminate) {
                    this.deemphasiseSelectionHighlightOn();
                }
                if (!this.terminate) {
                    try {
                        this.wait(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.terminate) {
                    this.deemphasiseSelectionHighlightOff();
                }
            }
            --counter;
        }
        counter = 2;
        while (!this.terminate && counter > 0) {
            selectionBlinker = this;
            synchronized (selectionBlinker) {
                try {
                    this.wait(150L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.terminate) {
                    this.deemphasiseSelectionHighlightOn();
                }
                if (!this.terminate) {
                    try {
                        this.wait(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.terminate) {
                    this.deemphasiseSelectionHighlightOff();
                }
            }
            --counter;
        }
        if (this.demphasized) {
            this.deemphasiseSelectionHighlightOff();
        }
    }

    synchronized void terminate() {
        this.terminate = true;
        this.interrupt();
    }

    private void deemphasiseSelectionHighlightOff() {
        this.demphasized = false;
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectionBlinker.this.removeBlinkerHighlights();
            }
        });
    }

    private void deemphasiseSelectionHighlightOn() {
        this.demphasized = true;
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectionBlinker.this.applyBlinkerHighlights();
            }
        });
    }

    private void removeBlinkerHighlights() {
        Collection<PMHighlight> blinkerHighlights = this.plan.getHighlights(HighlightLevel.BLINKER);
        ArrayList<PMPlanElement> changedElements = new ArrayList<PMPlanElement>(blinkerHighlights.size());
        for (PMHighlight highlight : blinkerHighlights) {
            PMPlanElement planElement = highlight.getPMPlanElement();
            planElement.setHighlight(HighlightLevel.BLINKER, null);
            changedElements.add(planElement);
        }
        this.refreshPlanElements(changedElements);
    }

    private void applyBlinkerHighlights() {
        Collection<PMHighlight> selectionHighlights = this.plan.getHighlights(HighlightLevel.SELECTION);
        ArrayList<PMPlanElement> changedElements = new ArrayList<PMPlanElement>(selectionHighlights.size());
        for (PMHighlight selectionHighlight : selectionHighlights) {
            PMPlanElement planElement = selectionHighlight.getPMPlanElement();
            PMHighlight blinkerHighlight = SelectionBlinker.demphasizeHighligt(selectionHighlight);
            planElement.setHighlight(HighlightLevel.BLINKER, blinkerHighlight);
            changedElements.add(planElement);
        }
        this.refreshPlanElements(changedElements);
    }

    private static PMHighlight demphasizeHighligt(PMHighlight highlight) {
        double modelCoronaWidth;
        final HighlightHint highlightHint = new HighlightHint();
        Color modelCoronaColor = highlightHint.getCoronaColor();
        if (modelCoronaColor == null) {
            modelCoronaColor = Color.BLUE;
        }
        if (Geo.isZero((double)(modelCoronaWidth = highlightHint.getCoronaWidth()))) {
            modelCoronaWidth = 0.5;
        }
        highlightHint.setCorona(modelCoronaColor.gotoWhite(0.9), 0.5);
        final PMPlanElement pmPlanElement = highlight.getPMPlanElement();
        IHighlightRequest highlightRequest = new IHighlightRequest(){

            public String getPlanElementUID() {
                return pmPlanElement.getUid();
            }

            public IHighlightHint getHighlightHint() {
                return highlightHint;
            }
        };
        return new PMHighlight(pmPlanElement, highlightRequest);
    }

    private void refreshPlanElements(Collection<PMPlanElement> changedElements) {
        for (PMPlanElement modelElement : changedElements) {
            Object editPartObject = this.plan.getViewer().getEditPartRegistry().get(modelElement);
            if (editPartObject == null || !(editPartObject instanceof PEPlanElement)) continue;
            PEPlanElement pePlanElement = (PEPlanElement)editPartObject;
            pePlanElement.refresh();
        }
    }
}

