/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor;

import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgentController;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInput;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.PlanEditorInputExtension;
import de.plans.lib.util.gui.IProgressDisplay;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class PlanEditorFacadeInput
implements IEditorInput {
    private final ImageDescriptor planFileImageDescriptor;
    private IPlanEditorControllerExtension controllerExtension;
    private IAbstractPlanAgentController controller;
    private PlanAgentInput planAgentInput;
    private PlanEditorInputExtension editorExtensionInput;
    private IProgressDisplay progressDisplay;
    private final String fallBackName;

    public PlanEditorFacadeInput(PlanAgentInput paInput, PlanEditorInputExtension peInput, ImageDescriptor image, IProgressDisplay progressDisplay) {
        assert (paInput != null);
        assert (peInput != null);
        assert (image != null);
        this.planAgentInput = paInput;
        this.editorExtensionInput = peInput;
        this.controller = this.planAgentInput.getPlanAgentController();
        this.controllerExtension = (IPlanEditorControllerExtension)peInput.getControllerExtension();
        this.planFileImageDescriptor = image;
        this.progressDisplay = progressDisplay;
        this.fallBackName = this.planAgentInput.getPlanInfo().getPlanName();
        if (this.progressDisplay == null) {
            this.progressDisplay = IProgressDisplay.DUMMY;
        }
    }

    public void destroy() {
        this.controllerExtension = null;
        this.controller = null;
        this.planAgentInput = null;
        this.editorExtensionInput = null;
        this.progressDisplay = null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.planFileImageDescriptor;
    }

    public String getName() {
        if (this.planAgentInput != null) {
            return this.planAgentInput.getPlanInfo().getPlanName();
        }
        return this.fallBackName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        String fullQualifiedPlanName = "";
        if (this.planAgentInput != null) {
            String planName;
            String name;
            String path = this.planAgentInput.getPlanInfo().getFullQualifiedPlanNamePath();
            if (path != null) {
                fullQualifiedPlanName = String.valueOf(fullQualifiedPlanName) + path;
            }
            if ((name = this.planAgentInput.getPlanInfo().getFullQualifiedPlanNameName()) != null) {
                fullQualifiedPlanName = String.valueOf(fullQualifiedPlanName) + name;
            }
            if ("".equals(fullQualifiedPlanName) && (planName = this.planAgentInput.getPlanInfo().getPlanName()) != null) {
                fullQualifiedPlanName = planName;
            }
        }
        return fullQualifiedPlanName;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IAbstractPlanAgentController getController() {
        return this.controller;
    }

    public IPlanEditorControllerExtension getControllerExtension() {
        return this.controllerExtension;
    }

    public PlanEditorInputExtension getEditorExtensionInput() {
        return this.editorExtensionInput;
    }

    public PlanAgentInput getPlanAgentInput() {
        return this.planAgentInput;
    }

    public IProgressDisplay getProgressDisplay() {
        return this.progressDisplay;
    }
}

